/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.SessionQos;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class TestReconnectSameClientOnly
extends TestCase
implements I_Callback {
    private static String ME = "TestReconnectSameClientOnly";
    private Global glob;
    private LogChannel log;
    private I_XmlBlasterAccess con = null;
    private String passwd = "secret";
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 9560;
    private boolean startEmbedded = true;

    public TestReconnectSameClientOnly(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
    }

    protected void setUp() {
        this.log.info(ME, "#################### setup-testReconnectSameClientOnly ...");
        this.startEmbedded = this.glob.getProperty().get("startEmbedded", this.startEmbedded);
        if (this.startEmbedded) {
            this.glob.init(Util.getOtherServerPorts(this.serverPort));
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            this.log.info(ME, "XmlBlaster is ready for testing");
        }
    }

    public void testReconnectSameClientOnly() {
        SessionQos sessionQos;
        ConnectQos qos;
        I_XmlBlasterAccess con2;
        Global glob2;
        this.log.info(ME, "#################### testReconnectSameClientOnly ...");
        try {
            this.log.info(ME, "Connecting first ...");
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos2 = new ConnectQos(this.glob, "JOE/1", "secret");
            CallbackAddress callback = new CallbackAddress(this.glob);
            callback.setPingInterval(1000L);
            qos2.addCallbackAddress(callback);
            SessionQos sessionQos2 = qos2.getSessionQos();
            sessionQos2.setMaxSessions(1);
            sessionQos2.setReconnectSameClientOnly(true);
            this.con.connect(qos2, this);
        }
        catch (Exception e) {
            Thread.currentThread();
            Thread.dumpStack();
            Assert.fail(ME + ": Can't connect to xmlBlaster: " + e.toString());
        }
        try {
            this.log.info(ME, "Connecting other ...");
            glob2 = this.glob.getClone(null);
            con2 = glob2.getXmlBlasterAccess();
            qos = new ConnectQos(glob2, "JOE/1", "secret");
            sessionQos = qos.getSessionQos();
            sessionQos.setMaxSessions(1);
            sessionQos.setReconnectSameClientOnly(true);
            con2.connect(qos, this);
            Assert.fail(ME + ": Reconnect to xmlBlaster should not be possible");
        }
        catch (XmlBlasterException e) {
            this.log.info(ME, "SUCCESS, reconnect is not possible: " + e.getMessage());
        }
        try {
            this.con.getCbServer().shutdown();
        }
        catch (XmlBlasterException e) {
            Assert.fail("Can't setup test: " + e.getMessage());
        }
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        try {
            this.log.info(ME, "Connecting other ...");
            glob2 = this.glob.getClone(null);
            con2 = glob2.getXmlBlasterAccess();
            qos = new ConnectQos(glob2, "JOE/1", "secret");
            sessionQos = qos.getSessionQos();
            sessionQos.setMaxSessions(1);
            sessionQos.setReconnectSameClientOnly(true);
            con2.connect(qos, this);
            this.log.info(ME, "SUCCESS, reconnect is OK after first session died");
        }
        catch (XmlBlasterException e) {
            Assert.fail(ME + ": Reconnect should now be possible: " + e.getMessage());
        }
        this.log.info(ME, "Success in testReconnectSameClientOnly()");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.error(ME, "TEST FAILED: UpdateKey.toString()=" + updateKey.toString() + "UpdateQos.toString()=" + updateQos.toString());
        Assert.fail("Unexpected UpdateKey.toString()=" + updateKey.toString());
        return "";
    }

    protected void tearDown() {
        this.log.info(ME, "#################### tearDown-testReconnectSameClientOnly ...");
        this.con.disconnect(null);
        this.con = null;
        if (this.startEmbedded) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
        }
        Util.resetPorts(this.glob);
        this.glob = null;
        this.log = null;
        this.con = null;
        Global.instance().shutdown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestReconnectSameClientOnly(Global.instance(), "testReconnectSameClientOnly"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.exit(0);
        }
        TestReconnectSameClientOnly testSub = new TestReconnectSameClientOnly(glob, "TestReconnectSameClientOnly");
        testSub.setUp();
        testSub.testReconnectSameClientOnly();
        testSub.tearDown();
    }
}

