/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class TestSub
extends TestCase
implements I_Callback {
    private static String ME = "TestSub";
    private final Global glob;
    private final LogChannel log;
    private boolean messageArrived = false;
    private String subscribeOid;
    private String publishOid = "dummyTestSub";
    private I_XmlBlasterAccess senderConnection;
    private String senderName;
    private String senderContent;
    private String receiverName;
    private Timestamp sentTimestamp;
    private String cbSessionId = "0fxrc83plP";
    private int numReceived = 0;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "1.0";
    private UpdateQos updateQos = null;

    public TestSub(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.senderName = loginName;
        this.receiverName = loginName;
    }

    protected void setUp() {
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos qos = new ConnectQos(this.glob, this.senderName, passwd);
            if (this.log.TRACE) {
                this.log.trace(ME, "the connect qos is: " + qos.toXml());
            }
            CallbackAddress cbAddress = new CallbackAddress(this.glob);
            cbAddress.setSecretSessionId(this.cbSessionId);
            qos.addCallbackAddress(cbAddress);
            this.senderConnection.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    protected void tearDown() {
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + this.publishOid + "' queryType='EXACT'>\n" + "</key>";
        String qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, qos);
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.senderConnection.disconnect(null);
    }

    public void testSubscribeXPath() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using XPath syntax ...");
        }
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' queryType='XPATH'>\n   //TestSub-AGENT</key>";
        this.numReceived = 0;
        this.subscribeOid = null;
        try {
            SubscribeReturnQos subscribeReturnQos = this.senderConnection.subscribe(xmlKey, null);
            this.subscribeOid = subscribeReturnQos.getSubscriptionId();
            this.log.info(ME, "Success: Subscribe subscription-id=" + this.subscribeOid + " done: " + subscribeReturnQos.toXml());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned null subscribeOid", this.subscribeOid != null);
        Assert.assertTrue("returned subscribeOid is empty", 0 != this.subscribeOid.length());
    }

    public void testPublish() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + this.publishOid + "' contentMime='" + "text/xml" + "' contentMimeExtended='" + "1.0" + "'>\n" + "   <TestSub-AGENT id='192.168.124.10' subId='1' type='generic'>" + "      <TestSub-DRIVER id='FileProof' pollingFreq='10'>" + "      </TestSub-DRIVER>" + "   </TestSub-AGENT>" + "</key>";
        this.senderContent = "Yeahh, i'm the new content";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), "<qos></qos>");
            this.sentTimestamp = new Timestamp();
            PublishReturnQos tmp = this.senderConnection.publish(msgUnit);
            Assert.assertEquals("Wrong publishOid", this.publishOid, tmp.getKeyOid());
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void testPublishAfterSubscribeXPath() {
        this.testSubscribeXPath();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after subscribe", 0, this.numReceived);
        this.testPublish();
        this.waitOnUpdate(5000L);
        Assert.assertEquals("numReceived after publishing", 1, this.numReceived);
    }

    public String update(String cbSessionId_, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of message oid=" + updateKey.getOid() + "...");
        this.log.info(ME, "subscribeOid=" + this.subscribeOid + ":" + updateQos.toXml());
        ++this.numReceived;
        if (updateQos.isErased()) {
            return "";
        }
        int ii = 0;
        while (ii < 5) {
            if (this.subscribeOid != null) break;
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            this.log.info(ME, "waiting ...");
            ++ii;
        }
        Assert.assertEquals("Wrong cbSessionId", this.cbSessionId, cbSessionId_);
        Assert.assertEquals("Wrong sender", this.senderName, updateQos.getSender().getLoginName());
        Assert.assertEquals("engine.qos.update.subscriptionId: Wrong subscriptionId", this.subscribeOid, updateQos.getSubscriptionId());
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        Assert.assertEquals("Message contentMime is corrupted", "text/xml", updateKey.getContentMime());
        Assert.assertEquals("Message contentMimeExtended is corrupted", "1.0", updateKey.getContentMimeExtended());
        Assert.assertTrue("sentTimestamp=" + this.sentTimestamp + " not in hamony with rcvTimestamp=" + updateQos.getRcvTimestamp(), this.sentTimestamp.getMillis() < updateQos.getRcvTimestamp().getMillis() && this.sentTimestamp.getMillis() + 1000L > updateQos.getRcvTimestamp().getMillis());
        this.messageArrived = true;
        return "";
    }

    private void waitOnUpdate(long timeout) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (!this.messageArrived) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
        this.messageArrived = false;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestSub(new Global(), "testPublishAfterSubscribeXPath", loginName));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestSub testSub = new TestSub(glob, "TestSub", "Tim");
        testSub.setUp();
        testSub.testPublishAfterSubscribeXPath();
        testSub.tearDown();
    }
}

