/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubDispatch
extends TestCase
implements I_Callback {
    private static String ME = "TestSubDispatch";
    private final Global glob;
    private final LogChannel log;
    private boolean messageArrived = false;
    private String publishOid = "dummyTestSubDispatch";
    private I_XmlBlasterAccess senderConnection;
    private String senderName;
    private String senderContent;
    private String receiverName;
    private int numReceived = 0;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "1.0";
    private SubscribeReturnQos subscribeRetQos = null;
    private String assertInUpdate = null;

    public TestSubDispatch(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.senderName = loginName;
        this.receiverName = loginName;
    }

    protected void setUp() {
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            this.senderConnection.connect(connectQos, this);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    protected void tearDown() {
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + this.publishOid + "' queryType='EXACT'>\n" + "</key>";
        String qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, qos);
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.senderConnection.disconnect(null);
    }

    public void testSubscribeXPath() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using XPath syntax ...");
        }
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' queryType='XPATH'>\n   //TestSubDispatch-AGENT</key>";
        String qos = "<qos></qos>";
        this.numReceived = 0;
        try {
            this.subscribeRetQos = this.senderConnection.subscribe(xmlKey, qos, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    TestSubDispatch.this.log.info(ME, "Receiving message with specialized update(" + updateKey.getOid() + ") ... " + updateQos.toXml());
                    if (updateQos.isErased()) {
                        return "";
                    }
                    TestSubDispatch.this.numReceived += 1;
                    Assert.assertEquals("Wrong sender", TestSubDispatch.this.senderName, updateQos.getSender().getLoginName());
                    Assert.assertEquals("engine.qos.update.subscriptionId: Wrong subscriptionId", TestSubDispatch.this.subscribeRetQos.getSubscriptionId(), updateQos.getSubscriptionId());
                    Assert.assertEquals("Wrong oid of message returned", TestSubDispatch.this.publishOid, updateKey.getOid());
                    Assert.assertEquals("Message content is corrupted", new String(TestSubDispatch.this.senderContent), new String(content));
                    Assert.assertEquals("Message contentMime is corrupted", "text/xml", updateKey.getContentMime());
                    Assert.assertEquals("Message contentMimeExtended is corrupted", "1.0", updateKey.getContentMimeExtended());
                    TestSubDispatch.this.messageArrived = true;
                    return "";
                }
            });
            Assert.assertTrue("returned null subscribeRetQos", this.subscribeRetQos != null);
            Assert.assertTrue("returned null subscribeId", this.subscribeRetQos.getSubscriptionId() != null);
            Assert.assertTrue("returned subscribeId is empty", 0 != this.subscribeRetQos.getSubscriptionId().length());
            this.log.info(ME, "Success: Subscribe subscription-id=" + this.subscribeRetQos.getSubscriptionId() + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void testPublish() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + this.publishOid + "' contentMime='" + "text/xml" + "' contentMimeExtended='" + "1.0" + "'>\n" + "   <TestSubDispatch-AGENT id='192.168.124.10' subId='1' type='generic'>" + "      <TestSubDispatch-DRIVER id='FileProof' pollingFreq='10'>" + "      </TestSubDispatch-DRIVER>" + "   </TestSubDispatch-AGENT>" + "</key>";
        this.senderContent = "Yeahh, i'm the new content";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), "<qos></qos>");
            String tmp = this.senderConnection.publish(msgUnit).getKeyOid();
            Assert.assertEquals("Wrong publishOid", this.publishOid, tmp);
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void testPublishAfterSubscribeXPath() {
        this.testSubscribeXPath();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after subscribe", 0, this.numReceived);
        Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
        this.testPublish();
        this.waitOnUpdate(5000L);
        Assert.assertEquals("numReceived after publishing", 1, this.numReceived);
        Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (updateQos.isErased()) {
            return "";
        }
        this.assertInUpdate = "Receiving update of message oid=" + updateKey.getOid() + " state=" + updateQos.getState() + " in default update handler ...";
        this.log.error(ME, "Receiving update of message oid=" + updateKey.getOid() + " state=" + updateQos.getState() + " in default update handler ...");
        return "";
    }

    private void waitOnUpdate(long timeout) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (!this.messageArrived) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
        this.messageArrived = false;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = ME;
        suite.addTest(new TestSubDispatch(new Global(), "testPublishAfterSubscribeXPath", loginName));
        return suite;
    }

    public static void main(String[] args) {
        TestSubDispatch testSub = new TestSubDispatch(new Global(args), "TestSubDispatch", ME);
        testSub.setUp();
        testSub.testPublishAfterSubscribeXPath();
        testSub.tearDown();
    }
}

