/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubExact
extends TestCase
implements I_Callback {
    private static String ME = "TestSubExact";
    private final Global glob;
    private final LogChannel log;
    private boolean messageArrived = false;
    private String subscribeOid;
    private String oidExact = "HelloMessage";
    private String publishOid = "";
    private I_XmlBlasterAccess senderConnection;
    private String senderName;
    private String senderContent;
    private String receiverName;
    private int numReceived = 0;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "1.0";

    public TestSubExact(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.senderName = loginName;
        this.receiverName = loginName;
    }

    protected void setUp() {
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos qos = new ConnectQos(this.glob, this.senderName, passwd);
            this.senderConnection.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    protected void tearDown() {
        String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'>\n" + "</key>";
        try {
            EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, "<qos/>");
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.senderConnection.disconnect(null);
    }

    public void subscribeExact() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using XPath syntax ...");
        }
        String xmlKey = "<key oid='" + this.oidExact + "' queryType='EXACT'>\n" + "</key>";
        String qos = "<qos></qos>";
        this.numReceived = 0;
        this.subscribeOid = null;
        try {
            this.subscribeOid = this.senderConnection.subscribe(xmlKey, qos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on " + this.subscribeOid + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned null subscribeOid", this.subscribeOid != null);
        Assert.assertTrue("returned subscribeOid is empty", 0 != this.subscribeOid.length());
    }

    public void testPublish() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        String xmlKey = "<key oid='" + this.oidExact + "' contentMime='" + "text/xml" + "' contentMimeExtended='" + "1.0" + "'>\n" + "</key>";
        this.senderContent = "Yeahh, i'm the new content";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), "<qos></qos>");
            this.publishOid = this.senderConnection.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned publishOid == null", this.publishOid != null);
        Assert.assertTrue("returned publishOid", 0 != this.publishOid.length());
        Assert.assertEquals("returned publishOid is wrong", this.oidExact, this.publishOid);
    }

    public void testPublishAfterSubscribe() {
        this.subscribeExact();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after subscribe", 0, this.numReceived);
        this.testPublish();
        this.waitOnUpdate(5000L);
        Assert.assertEquals("numReceived after publishing", 1, this.numReceived);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message from sender = " + updateQos.getSender() + " ...");
        }
        ++this.numReceived;
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        if (updateQos.isErased()) {
            return "";
        }
        try {
            Assert.assertEquals("Wrong sender", this.senderName, updateQos.getSender().getLoginName());
            Assert.assertEquals("engine.qos.update.subscriptionId: Wrong subscriptionId", this.subscribeOid, updateQos.getSubscriptionId());
            Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
            Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
            Assert.assertEquals("Message contentMime is corrupted", "text/xml", updateKey.getContentMime());
            Assert.assertEquals("Message contentMimeExtended is corrupted", "1.0", updateKey.getContentMimeExtended());
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.log.error(ME, e.toString());
            throw e;
        }
        this.messageArrived = true;
        return "";
    }

    private void waitOnUpdate(long timeout) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (!this.messageArrived) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
        this.messageArrived = false;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestSubExact(new Global(), "testPublishAfterSubscribe", loginName));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestSubExact testSub = new TestSubExact(glob, "TestSubExact", "Tim");
        testSub.setUp();
        testSub.testPublishAfterSubscribe();
        testSub.tearDown();
    }
}

