/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubLostClient
extends TestCase
implements I_Callback {
    private static String ME = "TestSubLostClient";
    private final Global glob;
    private final LogChannel log;
    private boolean messageArrived = false;
    private final String publishOid1 = "dummy1";
    private I_XmlBlasterAccess oneConnection;
    private String oneName;
    private int numReceived = 0;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "1.0";
    private int numClients;
    private Client[] manyClients;
    private StopWatch stopWatch = new StopWatch();

    public TestSubLostClient(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.oneName = loginName;
        this.numClients = 2;
    }

    protected void setUp() {
        this.log.info(ME, "Setting up test ...");
        this.numReceived = 0;
        try {
            this.oneConnection = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.oneName, passwd);
            this.oneConnection.connect(connectQos, this);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    protected void tearDown() {
        if (this.numReceived != this.numClients - 1) {
            this.log.error(ME, "numClients=" + (this.numClients - 1) + " but numReceived=" + this.numReceived);
        }
        Assert.assertEquals("numClients=1 but numReceived=" + this.numReceived, this.numClients - 1, this.numReceived);
        if (this.manyClients != null) {
            int ii = 0;
            while (ii < this.numClients) {
                Client sub = this.manyClients[ii];
                sub.connection.disconnect(null);
                ++ii;
            }
        }
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='dummy1' queryType='EXACT'>\n</key>";
        try {
            EraseReturnQos[] arr = this.oneConnection.erase(xmlKey, "<qos/>");
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.oneConnection.disconnect(null);
        this.log.info(ME, "Logout done");
    }

    public void susbcribeMany() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing ...");
        }
        String passwd = "secret";
        SubscribeKey subKeyW = new SubscribeKey(this.glob, "dummy1");
        String subKey = subKeyW.toXml();
        SubscribeQos subQosW = new SubscribeQos(this.glob);
        String subQos = subQosW.toXml();
        this.manyClients = new Client[this.numClients];
        this.log.info(ME, "Setting up " + this.numClients + " subscriber clients ...");
        this.stopWatch = new StopWatch();
        int ii = 0;
        while (ii < this.numClients) {
            Client sub = new Client();
            sub.loginName = "Joe-" + ii;
            try {
                Global globSub = this.glob.getClone(null);
                sub.connection = globSub.getXmlBlasterAccess();
                ConnectQos loginQosW = new ConnectQos(globSub, sub.loginName, passwd);
                sub.connection.connect(loginQosW, this);
            }
            catch (Exception e) {
                this.log.error(ME, "Login failed: " + e.toString());
                Assert.assertTrue("Login failed: " + e.toString(), false);
            }
            try {
                sub.subscribeOid = sub.connection.subscribe(subKey, subQos).getSubscriptionId();
                this.log.info(ME, "Client " + sub.loginName + " subscribed to " + subKeyW.getOid());
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
                Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
            }
            this.manyClients[ii] = sub;
            ++ii;
        }
        double timeForLogins = (double)this.stopWatch.elapsed() / 1000.0;
        this.log.info(ME, this.numClients + " subscriber clients are ready.");
        this.log.info(ME, "Time " + (long)((double)this.numClients / timeForLogins) + " logins/sec");
        try {
            this.manyClients[0].connection.getCbServer().shutdown();
        }
        catch (Throwable e) {
            e.printStackTrace();
            Assert.assertTrue("Problems with connection,shutdownCb()", false);
        }
        this.log.info(ME, "Killed callback server of first client.");
    }

    public void publishOne() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='dummy1' contentMime='text/xml' contentMimeExtended='1.0'>\n</key>";
        String senderContent = "Yeahh, i'm the new content";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, senderContent.getBytes(), "<qos></qos>");
            this.stopWatch = new StopWatch();
            String tmp = this.oneConnection.publish(msgUnit).getKeyOid();
            Assert.assertEquals("Wrong publishOid1", "dummy1", tmp);
            this.log.info(ME, "Success: Publishing done, returned oid=dummy1");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException in publish: " + e.getMessage());
            Assert.assertTrue("XmlBlasterException in publish: " + e.getMessage(), true);
        }
    }

    public void testManyClients() {
        this.log.plain(ME, "");
        this.log.info(ME, "TEST 1, many subscribers, one publisher ...");
        this.susbcribeMany();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after subscribe", 0, this.numReceived);
        this.publishOne();
        this.log.info(ME, "Waiting long enough for updates ...");
        Util.delay(2000L + (long)(10 * this.numClients));
        this.log.info(ME, "Received " + this.numReceived + " updates");
        Assert.assertEquals("Wrong number of updates", this.numClients - 1, this.numReceived);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Client " + cbSessionId + " receiving update of message oid=" + updateKey.getOid() + "...");
        ++this.numReceived;
        return "";
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestSubLostClient(new Global(), "testManyClients", loginName));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestSubLostClient testSub = new TestSubLostClient(glob, "TestSubLostClient", "Tim");
        testSub.setUp();
        testSub.testManyClients();
        testSub.tearDown();
    }

    class Client {
        String loginName;
        I_XmlBlasterAccess connection;
        String subscribeOid;

        Client() {
        }
    }
}

