/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubManyClients
extends TestCase
implements I_Callback {
    private static String ME = "TestSubManyClients";
    private final Global glob;
    private final LogChannel log;
    private boolean messageArrived = false;
    private final String publishOid1 = "dummy1";
    private final String publishOid2 = "dummy2";
    private I_XmlBlasterAccess oneConnection;
    private String oneName;
    private int numReceived = 0;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "1.0";
    private int numClients;
    private Client[] manyClients;
    private StopWatch stopWatch = new StopWatch();

    public TestSubManyClients(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.oneName = loginName;
        this.numClients = glob.getProperty().get("numClients", 10);
    }

    protected void setUp() {
        this.log.info(ME, "Setting up test ...");
        this.numReceived = 0;
        try {
            Global globOne = this.glob.getClone(null);
            this.oneConnection = globOne.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos qos = new ConnectQos(globOne, this.oneName, passwd);
            this.oneConnection.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    protected void tearDown() {
        EraseReturnQos[] arr;
        if (this.numReceived != this.numClients) {
            this.log.error(ME, "numClients=" + this.numClients + " but numReceived=" + this.numReceived);
            Assert.assertEquals("numClients=" + this.numClients + " but numReceived=" + this.numReceived, this.numClients, this.numReceived);
        }
        this.log.removeLogLevel("INFO");
        if (this.manyClients != null) {
            int ii = 0;
            while (ii < this.numClients) {
                Client sub = this.manyClients[ii];
                sub.connection.disconnect(null);
                ++ii;
            }
        }
        this.log.addLogLevel("INFO");
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='dummy1' queryType='EXACT'>\n</key>";
        String qos = "<qos></qos>";
        try {
            arr = this.oneConnection.erase(xmlKey, qos);
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase-XmlBlasterException: " + e.getMessage());
        }
        xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='dummy2' queryType='EXACT'>\n</key>";
        qos = "<qos></qos>";
        try {
            arr = this.oneConnection.erase(xmlKey, qos);
            Assert.assertEquals("Ersae", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase-XmlBlasterException: " + e.getMessage());
        }
        this.oneConnection.disconnect(null);
        this.log.info(ME, "Logout done");
    }

    public void subcribeMany() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing ...");
        }
        String passwd = "secret";
        SubscribeKey subKeyW = new SubscribeKey(this.glob, "dummy1");
        String subKey = subKeyW.toXml();
        SubscribeQos subQosW = new SubscribeQos(this.glob);
        String subQos = subQosW.toXml();
        this.manyClients = new Client[this.numClients];
        long usedBefore = this.getUsedServerMemory();
        this.log.info(ME, "Setting up " + this.numClients + " subscriber clients ...");
        this.log.removeLogLevel("INFO");
        this.stopWatch = new StopWatch();
        int ii = 0;
        while (ii < this.numClients) {
            Client sub = new Client();
            sub.loginName = "Joe-" + ii;
            try {
                Global globTmp = this.glob.getClone(null);
                sub.connection = globTmp.getXmlBlasterAccess();
                ConnectQos loginQosW = new ConnectQos(globTmp, sub.loginName, passwd);
                sub.connection.connect(loginQosW, this);
            }
            catch (Exception e) {
                this.log.error(ME, "Login failed: " + e.toString());
                Assert.assertTrue("Login failed: " + e.toString(), false);
            }
            try {
                sub.subscribeOid = sub.connection.subscribe(subKey, subQos).getSubscriptionId();
                this.log.info(ME, "Client " + sub.loginName + " subscribed to " + subKeyW.getOid());
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
                Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
            }
            this.manyClients[ii] = sub;
            ++ii;
        }
        double timeForLogins = (double)this.stopWatch.elapsed() / 1000.0;
        this.log.addLogLevel("INFO");
        long usedAfter = this.getUsedServerMemory();
        long memPerLogin = (usedAfter - usedBefore) / (long)this.numClients;
        this.log.info(ME, this.numClients + " subscriber clients are ready.");
        this.log.info(ME, "Server memory per login consumed=" + memPerLogin);
        this.log.info(ME, "Time " + (long)((double)this.numClients / timeForLogins) + " logins/sec");
    }

    long getUsedServerMemory() {
        String xmlKey = "<key oid='__cmd:?usedMem' queryType='EXACT'></key>";
        String qos = "<qos></qos>";
        try {
            MsgUnit[] msgArr = this.oneConnection.get(xmlKey, qos);
            String mem = new String(msgArr[0].getContent());
            return new Long(mem);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, e.toString());
            return 0L;
        }
    }

    public void publishOne() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='dummy1' contentMime='text/xml' contentMimeExtended='1.0'>\n</key>";
        String senderContent = "Yeahh, i'm the new content";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, senderContent.getBytes(), "<qos></qos>");
            this.stopWatch = new StopWatch();
            String tmp = this.oneConnection.publish(msgUnit).getKeyOid();
            Assert.assertEquals("Wrong publishOid1", "dummy1", tmp);
            this.log.info(ME, "Success: Publishing done, returned oid=dummy1");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publishOne - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void testManyClients() {
        this.log.plain(ME, "");
        this.log.info(ME, "TEST 1, many publishers, one subscriber ...");
        this.subcribeMany();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after subscribe", 0, this.numReceived);
        this.publishOne();
        this.log.info(ME, "Waiting long enough for updates ...");
        Util.delay(2000L + (long)(10 * this.numClients));
        Assert.assertEquals("Wrong number of updates", this.numClients, this.numReceived);
        this.log.plain(ME, "");
        this.log.info(ME, "TEST 2, many publishers, one subscriber ...");
        this.subcribeOne();
        try {
            Thread.currentThread();
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.numReceived = 0;
        this.publishMany();
        this.log.info(ME, "Waiting long enough for updates ...");
        Util.delay(2000L + (long)(10 * this.numClients));
        Assert.assertEquals("Wrong number of updates", this.numClients, this.numReceived);
    }

    public void subcribeOne() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing ...");
        }
        SubscribeKey subKeyW = new SubscribeKey(this.glob, "dummy2");
        String subKey = subKeyW.toXml();
        SubscribeQos subQosW = new SubscribeQos(this.glob);
        String subQos = subQosW.toXml();
        try {
            SubscribeReturnQos subscribeOid = this.oneConnection.subscribe(subKey, subQos);
            this.log.info(ME, "Client " + this.oneName + " subscribed to " + subKeyW.getOid());
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void publishMany() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        PublishKey pubKeyW = new PublishKey(this.glob, "dummy2", "text/xml", "1.0");
        String pubKey = pubKeyW.toXml();
        PublishQos pubQosW = new PublishQos(this.glob);
        String pubQos = pubQosW.toXml();
        long usedBefore = this.getUsedServerMemory();
        this.log.info(ME, this.numClients + " clients are publishing one message each ...");
        this.log.removeLogLevel("INFO");
        this.stopWatch = new StopWatch();
        int ii = 0;
        while (ii < this.numClients) {
            Client client = this.manyClients[ii];
            String senderContent = "New content from publisher " + client.loginName;
            try {
                MsgUnit msgUnit = new MsgUnit(pubKey, senderContent.getBytes(), pubQos);
                PublishReturnQos tmp = this.oneConnection.publish(msgUnit);
                Assert.assertEquals("Wrong publishOid2", "dummy2", tmp.getKeyOid());
            }
            catch (XmlBlasterException e) {
                this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
                Assert.assertTrue("publishOne - XmlBlasterException: " + e.getMessage(), false);
            }
            ++ii;
        }
        double timeToPublish = (double)this.stopWatch.elapsed() / 1000.0;
        this.log.addLogLevel("INFO");
        long usedAfter = this.getUsedServerMemory();
        long memPerLogin = (usedAfter - usedBefore) / (long)this.numClients;
        this.log.info(ME, this.numClients + " have published their messages.");
        this.log.info(ME, "Server memory consumed=" + memPerLogin + " bytes.");
        this.log.info(ME, "Time " + (long)((double)this.numClients / timeToPublish) + " publish/sec");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        ++this.numReceived;
        if (this.numReceived == this.numClients) {
            long avg = 0L;
            double elapsed = this.stopWatch.elapsed();
            if (elapsed > 0.0) {
                avg = (long)(1000.0 * (double)this.numReceived / elapsed);
            }
            this.log.info(ME, this.numReceived + " messages updated, average messages/second = " + avg + this.stopWatch.nice());
        }
        return "";
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestSubManyClients(new Global(), "testManyClients", loginName));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestSubManyClients testSub = new TestSubManyClients(glob, "TestSubManyClients", "Tim");
        testSub.setUp();
        testSub.testManyClients();
        testSub.tearDown();
    }

    class Client {
        String loginName;
        I_XmlBlasterAccess connection;
        String subscribeOid;

        Client() {
        }
    }
}

