/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubMulti
extends TestCase
implements I_Callback {
    private static String ME = "TestSubMulti";
    private final Global glob;
    private final LogChannel log;
    private String publishOid = "";
    private I_XmlBlasterAccess con;
    private String senderName;
    private String senderContent;
    private String receiverName;
    private Timestamp sentTimestamp;
    private int numReceived = 0;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "action";

    public TestSubMulti(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.senderName = loginName;
        this.receiverName = loginName;
    }

    protected void setUp() {
        try {
            this.con = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos qos = new ConnectQos(this.glob, this.senderName, passwd);
            this.con.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    protected void tearDown() {
        try {
            EraseReturnQos[] arr = this.con.erase("<key oid='" + this.publishOid + "'/>", "<qos/>");
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
    }

    public void testSubscribeXPath() {
        this.log.info(ME, "Subscribing using XPath syntax ...");
        try {
            SubscribeKey key = new SubscribeKey(this.glob, "//key/location[@dest='agent-192.168.10.218']", "XPATH");
            SubscribeQos qos = new SubscribeQos(this.glob);
            this.con.subscribe(key.toXml(), qos.toXml(), (I_Callback)this);
            key = new SubscribeKey(this.glob, "//key[@contentMimeExtended='action']/location[@dest='agent-192.168.10.218' and @driver='PSD1']", "XPATH");
            qos = new SubscribeQos(this.glob);
            this.con.subscribe(key.toXml(), qos.toXml(), (I_Callback)this);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void testPublish() {
        this.log.info(ME, "Publishing a message ...");
        this.numReceived = 0;
        PublishKey key = new PublishKey(this.glob, "", "text/xml", "action");
        key.setClientTags("<location dest='agent-192.168.10.218' driver='PSD1'></location>");
        PublishQos qos = new PublishQos(this.glob);
        this.senderContent = "some content";
        try {
            MsgUnit msgUnit = new MsgUnit(key.toXml(), this.senderContent.getBytes(), qos.toXml());
            this.sentTimestamp = new Timestamp();
            this.publishOid = this.con.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void testPublishAfterSubscribeXPath() {
        this.testSubscribeXPath();
        this.waitOnUpdate(1000L, 0);
        this.testPublish();
        this.waitOnUpdate(4000L, 2);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of message oid=" + updateKey.getOid() + "...");
        ++this.numReceived;
        if (updateQos.isErased()) {
            return "";
        }
        Assert.assertEquals("Wrong sender", this.senderName, updateQos.getSender().getLoginName());
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        Assert.assertEquals("Message contentMime is corrupted", "text/xml", updateKey.getContentMime());
        Assert.assertEquals("Message contentMimeExtended is corrupted", "action", updateKey.getContentMimeExtended());
        Assert.assertTrue("sentTimestamp=" + this.sentTimestamp + " not in hamony with rcvTimestamp=" + updateQos.getRcvTimestamp(), this.sentTimestamp.getMillis() < updateQos.getRcvTimestamp().getMillis() && this.sentTimestamp.getMillis() + 1000L > updateQos.getRcvTimestamp().getMillis());
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            Assert.assertTrue("Timeout of " + timeout + " occurred without update", (sum += pollingInterval) <= timeout);
        }
        try {
            Thread.currentThread();
            Thread.sleep(timeout);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("Wrong number of messages arrived", numWait, this.numReceived);
        this.numReceived = 0;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestSubMulti(new Global(), "testPublishAfterSubscribeXPath", loginName));
        return suite;
    }

    public static void main(String[] args) {
        TestSubMulti testSub = new TestSubMulti(new Global(args), "TestSubMulti", "Tim");
        testSub.setUp();
        testSub.testPublishAfterSubscribeXPath();
        testSub.tearDown();
    }
}

