/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubMultiSubscribe
extends TestCase {
    private static String ME = "TestSubMultiSubscribe";
    private final Global glob;
    private final LogChannel log;
    private String subscribeId;
    private MsgInterceptor updateInterceptor;
    private String publishOid = "HelloMessageMultiSub";
    private I_XmlBlasterAccess connection;

    public TestSubMultiSubscribe(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    protected void setUp() {
        try {
            this.connection = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob);
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
            this.connection.connect(qos, this.updateInterceptor);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("Login failed: " + e.toString());
        }
    }

    protected void tearDown() {
        if (this.connection != null) {
            if (this.publishOid != null) {
                String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'/>";
                try {
                    EraseReturnQos[] arr = this.connection.erase(xmlKey, "<qos/>");
                    Assert.assertEquals("Erase", 1, arr.length);
                }
                catch (XmlBlasterException e) {
                    Assert.fail("Erase XmlBlasterException: " + e.getMessage());
                }
            }
            this.connection.disconnect(null);
            this.connection = null;
        }
    }

    public void subscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing ...");
        }
        try {
            int i = 0;
            while (i < 10) {
                SubscribeKey key = new SubscribeKey(this.glob, this.publishOid);
                SubscribeQos qos = new SubscribeQos(this.glob);
                qos.setMultiSubscribe(false);
                SubscribeReturnQos ret = this.connection.subscribe(key.toXml(), qos.toXml());
                this.log.info(ME, "Subscribe #" + i + " state=" + ret.getState() + " subscriptionId=" + ret.getSubscriptionId());
                if (this.subscribeId == null) {
                    this.subscribeId = ret.getSubscriptionId();
                    Assert.assertEquals("", "OK", ret.getState());
                } else {
                    Assert.assertEquals("", this.subscribeId, ret.getSubscriptionId());
                    Assert.assertEquals("", "WARNING", ret.getState());
                }
                ++i;
            }
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("subscribe - XmlBlasterException: " + e.getMessage());
        }
    }

    public void publish() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        String xmlKey = "<key oid='" + this.publishOid + "'/>";
        String senderContent = "Yeahh, i'm the new content";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, senderContent.getBytes(), "<qos/>");
            this.publishOid = this.connection.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("publish - XmlBlasterException: " + e.getMessage());
        }
        Assert.assertTrue("returned publishOid == null", this.publishOid != null);
        Assert.assertTrue("returned publishOid", 0 != this.publishOid.length());
    }

    public void unSubscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "unSubscribing ...");
        }
        String qos = "<qos/>";
        try {
            this.connection.unSubscribe("<key oid='" + this.subscribeId + "'/>", qos);
            this.log.info(ME, "Success: unSubscribe 1 on " + this.subscribeId + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("unSubscribe - XmlBlasterException: " + e.getMessage());
        }
    }

    public void testMultiSubscribe() {
        this.log.info(ME, "testMultiSubscribe ...");
        this.subscribe();
        Assert.assertEquals("", 0, this.updateInterceptor.waitOnUpdate(1000L, 0));
        int numPub = 5;
        int i = 0;
        while (i < numPub) {
            this.publish();
            ++i;
        }
        Assert.assertEquals("", numPub, this.updateInterceptor.waitOnUpdate(1000L, this.publishOid, "OK"));
        this.updateInterceptor.clear();
        this.unSubscribe();
        this.publish();
        Assert.assertEquals("", 0, this.updateInterceptor.waitOnUpdate(1000L, 0));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestSubMultiSubscribe(new Global(), "testMultiSubscribe"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("Init failed");
            System.exit(1);
        }
        TestSubMultiSubscribe testSub = new TestSubMultiSubscribe(glob, "TestSubMultiSubscribe");
        testSub.setUp();
        testSub.testMultiSubscribe();
        testSub.tearDown();
    }
}

