/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubNoDup
extends TestCase
implements I_Callback {
    private static String ME = "TestSubNoDup";
    private final Global glob;
    private final LogChannel log;
    private String subscribeId1;
    private String subscribeId2;
    private String subscribeId3;
    private String oidExact = "HelloMessageNoDup";
    private String publishOid = null;
    private I_XmlBlasterAccess senderConnection;
    private String senderContent;
    private boolean duplicates = false;
    private int numReceived = 0;
    private final String contentMime = "text/xml";

    public TestSubNoDup(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    protected void setUp() {
    }

    protected void tearDown() {
        if (this.senderConnection != null) {
            if (this.publishOid != null) {
                String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'/>";
                try {
                    EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, "<qos/>");
                    Assert.assertEquals("Erase", 1, arr.length);
                }
                catch (XmlBlasterException e) {
                    Assert.fail("Erase XmlBlasterException: " + e.getMessage());
                }
            }
            this.senderConnection.disconnect(null);
            this.senderConnection = null;
        }
    }

    public void subscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing ...");
        }
        String xmlKey = "<key oid='" + this.oidExact + "' queryType='EXACT'/>";
        String qos = "<qos/>";
        this.numReceived = 0;
        this.subscribeId1 = null;
        this.subscribeId2 = null;
        this.subscribeId3 = null;
        try {
            this.subscribeId1 = this.senderConnection.subscribe(xmlKey, qos).getSubscriptionId();
            Assert.assertTrue("returned null subscribeId1", this.subscribeId1 != null);
            Assert.assertTrue("returned subscribeId1 is empty", 0 != this.subscribeId1.length());
            this.log.info(ME, "Success: Subscribe 1 on " + this.subscribeId1 + " done");
            this.subscribeId2 = this.senderConnection.subscribe(xmlKey, qos).getSubscriptionId();
            Assert.assertTrue("returned subscribeId2 is empty", 0 != this.subscribeId2.length());
            if (this.duplicates) {
                Assert.assertTrue("Wrong subscriptionId", !this.subscribeId1.equals(this.subscribeId2));
            } else {
                Assert.assertEquals("Wrong subscriptionId", this.subscribeId1, this.subscribeId2);
            }
            this.log.info(ME, "Success: Subscribe 2 on " + this.subscribeId2 + " done");
            this.subscribeId3 = this.senderConnection.subscribe(xmlKey, qos).getSubscriptionId();
            Assert.assertTrue("returned subscribeId3 is empty", 0 != this.subscribeId3.length());
            if (this.duplicates) {
                Assert.assertTrue("Wrong subscriptionId", !this.subscribeId1.equals(this.subscribeId2));
            } else {
                Assert.assertEquals("Wrong subscriptionId", this.subscribeId1, this.subscribeId3);
            }
            this.log.info(ME, "Success: Subscribe 3 on " + this.subscribeId3 + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void publish() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        String xmlKey = "<key oid='" + this.oidExact + "' contentMime='" + "text/xml" + "'/>";
        this.senderContent = "Yeahh, i'm the new content";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), "<qos/>");
            this.publishOid = this.senderConnection.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned publishOid == null", this.publishOid != null);
        Assert.assertTrue("returned publishOid", 0 != this.publishOid.length());
        Assert.assertEquals("returned publishOid is wrong", this.oidExact, this.publishOid);
    }

    public void unSubscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "unSubscribing ...");
        }
        String qos = "<qos/>";
        this.numReceived = 0;
        try {
            this.senderConnection.unSubscribe("<key oid='" + this.subscribeId1 + "'/>", qos);
            this.log.info(ME, "Success: unSubscribe 1 on " + this.subscribeId1 + " done");
            this.senderConnection.unSubscribe("<key oid='" + this.subscribeId2 + "'/>", qos);
            this.log.info(ME, "Success: unSubscribe 2 on " + this.subscribeId2 + " done");
            this.senderConnection.unSubscribe("<key oid='" + this.subscribeId3 + "'/>", qos);
            this.log.info(ME, "Success: unSubscribe 3 on " + this.subscribeId3 + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("unSubscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    private void connect() {
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob);
            qos.setDuplicateUpdates(this.duplicates);
            this.senderConnection.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    public void testPublishAfterMultiSubscribeNoDup() {
        this.log.info(ME, "testPublishAfterMultiSubscribeNoDup ...");
        this.numReceived = 0;
        this.duplicates = false;
        this.connect();
        this.subscribe();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after subscribe", 0, this.numReceived);
        this.publish();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after publishing", 1, this.numReceived);
        this.unSubscribe();
        this.numReceived = 0;
        this.publish();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after publishing", 0, this.numReceived);
    }

    public void testPublishAfterMultiSubscribe() {
        this.log.info(ME, "testPublishAfterMultiSubscribe ...");
        this.numReceived = 0;
        this.duplicates = true;
        this.connect();
        this.subscribe();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after subscribe", 0, this.numReceived);
        this.publish();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after publishing", 3, this.numReceived);
        this.unSubscribe();
        this.numReceived = 0;
        this.publish();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after publishing", 0, this.numReceived);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message " + updateKey.getOid() + " state=" + updateQos.getState());
        ++this.numReceived;
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        if (!this.duplicates) {
            Assert.assertEquals("engine.qos.update.subscriptionId: Wrong subscriptionId", this.subscribeId1, updateQos.getSubscriptionId());
        }
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        Assert.assertEquals("Message contentMime is corrupted", "text/xml", updateKey.getContentMime());
        return "";
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestSubNoDup(new Global(), "testPublishAfterMultiSubscribeNoDup"));
        suite.addTest(new TestSubNoDup(new Global(), "testPublishAfterMultiSubscribe"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("Init failed");
            System.exit(1);
        }
        TestSubNoDup testSub = new TestSubNoDup(glob, "TestSubNoDup");
        testSub.setUp();
        testSub.testPublishAfterMultiSubscribeNoDup();
        testSub.tearDown();
        testSub = new TestSubNoDup(glob, "TestSubNoDup");
        testSub.setUp();
        testSub.testPublishAfterMultiSubscribe();
        testSub.tearDown();
    }
}

