/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubNoLocal
extends TestCase
implements I_Callback {
    private static String ME = "TestSubNoLocal";
    private final Global glob;
    private final LogChannel log;
    private String subscribeId1;
    private MsgInterceptor updateInterceptor1;
    private String subscribeId2;
    private MsgInterceptor updateInterceptor2;
    private String publishOid = "HelloMessageNoLocal";
    private I_XmlBlasterAccess connection;

    public TestSubNoLocal(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    protected void setUp() {
    }

    protected void tearDown() {
        if (this.connection != null) {
            if (this.publishOid != null) {
                String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'/>";
                try {
                    EraseReturnQos[] arr = this.connection.erase(xmlKey, "<qos/>");
                    Assert.assertEquals("Erase", 1, arr.length);
                }
                catch (XmlBlasterException e) {
                    Assert.fail("Erase XmlBlasterException: " + e.getMessage());
                }
            }
            this.connection.disconnect(null);
            this.connection = null;
        }
    }

    public void subscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing ...");
        }
        try {
            SubscribeKey key = new SubscribeKey(this.glob, this.publishOid);
            SubscribeQos qos = new SubscribeQos(this.glob);
            qos.setWantLocal(false);
            this.updateInterceptor1 = new MsgInterceptor(this.glob, this.log, null);
            SubscribeReturnQos ret = this.connection.subscribe(key.toXml(), qos.toXml(), (I_Callback)this.updateInterceptor1);
            this.subscribeId1 = ret.getSubscriptionId();
            key = new SubscribeKey(this.glob, this.publishOid);
            qos = new SubscribeQos(this.glob);
            qos.setWantLocal(true);
            this.updateInterceptor2 = new MsgInterceptor(this.glob, this.log, null);
            ret = this.connection.subscribe(key.toXml(), qos.toXml(), (I_Callback)this.updateInterceptor2);
            this.subscribeId2 = ret.getSubscriptionId();
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("subscribe - XmlBlasterException: " + e.getMessage());
        }
    }

    public void publish() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        String xmlKey = "<key oid='" + this.publishOid + "'/>";
        String senderContent = "Yeahh, i'm the new content";
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, senderContent.getBytes(), "<qos/>");
            this.publishOid = this.connection.publish(msgUnit).getKeyOid();
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("publish - XmlBlasterException: " + e.getMessage());
        }
        Assert.assertTrue("returned publishOid == null", this.publishOid != null);
        Assert.assertTrue("returned publishOid", 0 != this.publishOid.length());
    }

    public void unSubscribe() {
        if (this.log.TRACE) {
            this.log.trace(ME, "unSubscribing ...");
        }
        String qos = "<qos/>";
        try {
            this.connection.unSubscribe("<key oid='" + this.subscribeId1 + "'/>", qos);
            this.log.info(ME, "Success: unSubscribe 1 on " + this.subscribeId1 + " done");
            this.connection.unSubscribe("<key oid='" + this.subscribeId2 + "'/>", qos);
            this.log.info(ME, "Success: unSubscribe 2 on " + this.subscribeId2 + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("unSubscribe - XmlBlasterException: " + e.getMessage());
        }
    }

    private void connect() {
        try {
            this.connection = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob);
            this.connection.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.fail("Login failed: " + e.toString());
        }
    }

    public void testLocalUpdates() {
        this.log.info(ME, "testLocalUpdates ...");
        this.connect();
        this.subscribe();
        Assert.assertEquals("", 0, this.updateInterceptor1.waitOnUpdate(1000L, 0));
        Assert.assertEquals("", 0, this.updateInterceptor2.waitOnUpdate(1000L, 0));
        int numPub = 5;
        int i = 0;
        while (i < numPub) {
            this.publish();
            ++i;
        }
        Assert.assertEquals("", 0, this.updateInterceptor1.waitOnUpdate(1000L, 0));
        Assert.assertEquals("", numPub, this.updateInterceptor2.waitOnUpdate(1000L, this.publishOid, "OK"));
        this.updateInterceptor2.clear();
        this.unSubscribe();
        this.publish();
        Assert.assertEquals("", 0, this.updateInterceptor1.waitOnUpdate(1000L, 0));
        Assert.assertEquals("", 0, this.updateInterceptor2.waitOnUpdate(1000L, 0));
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.error(ME, "Receiving unexpected update of a message " + updateKey.getOid() + " state=" + updateQos.getState());
        return "";
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestSubNoLocal(new Global(), "testLocalUpdates"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println("Init failed");
            System.exit(1);
        }
        TestSubNoLocal testSub = new TestSubNoLocal(glob, "TestSubNoLocal");
        testSub.setUp();
        testSub.testLocalUpdates();
        testSub.tearDown();
    }
}

