/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.test.Msg;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubXPath
extends TestCase {
    private String ME = "TestSubXPath";
    private final Global glob;
    private final LogChannel log;
    private String publishOid = "";
    private I_XmlBlasterAccess senderConnection;
    private String senderName;
    private String receiverName;
    private int numPublish = 5;
    private final String contentMime = "text/xml";
    private String subscribeOid = null;
    private MsgInterceptor updateInterceptor;

    public TestSubXPath(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.senderName = loginName;
        this.receiverName = loginName;
    }

    protected void setUp() {
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, this.senderName, "secret");
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, null);
            this.senderConnection.connect(qos, this.updateInterceptor);
        }
        catch (Exception e) {
            this.log.error(this.ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
        this.updateInterceptor.clear();
    }

    protected void tearDown() {
        this.senderConnection.disconnect(null);
    }

    private void subscribeXPath(String query) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Subscribing using XPath syntax ...");
        }
        String xmlKey = "<key oid='' queryType='XPATH'>\n" + query + "</key>";
        String qos = "<qos/>";
        try {
            this.subscribeOid = this.senderConnection.subscribe(xmlKey, qos).getSubscriptionId();
            this.log.info(this.ME, "Success: Subscribe on " + this.subscribeOid + " done:\n" + xmlKey);
        }
        catch (XmlBlasterException e) {
            this.log.warn(this.ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned null subscribeOid", this.subscribeOid != null);
        Assert.assertTrue("returned subscribeOid is empty", 0 != this.subscribeOid.length());
    }

    private void doPublish() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Publishing a message ...");
        }
        int counter = 1;
        while (counter <= this.numPublish) {
            String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + counter + "' contentMime='" + "text/xml" + "'>\n" + "<AGENT id='message_" + counter + "' subId='1' type='generic'>" + "<DRIVER id='FileProof' pollingFreq='10'>" + "</DRIVER>" + "</AGENT>" + "</key>";
            String content = "Content: message_" + counter;
            try {
                MsgUnit msgUnit = new MsgUnit(this.glob, xmlKey, content.getBytes(), "<qos></qos>");
                this.publishOid = this.senderConnection.publish(msgUnit).getKeyOid();
                this.log.info(this.ME, "Success: Publishing #" + counter + " done, returned oid=" + this.publishOid);
            }
            catch (XmlBlasterException e) {
                this.log.warn(this.ME, "XmlBlasterException: " + e.getMessage());
                Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
            }
            Assert.assertTrue("returned publishOid == null", this.publishOid != null);
            Assert.assertTrue("returned publishOid", 0 != this.publishOid.length());
            ++counter;
        }
    }

    public void testInitial() {
        this.ME = "TestSubXPath:testInitial()";
        String oid = "INITIAL";
        this.subscribeXPath("//demoXPath");
        Assert.assertEquals("numReceived after subscribe", 0, this.updateInterceptor.waitOnUpdate(1000L, null, null));
        this.updateInterceptor.clear();
        try {
            PublishKey pk = new PublishKey(this.glob, oid, "text/xml", "1.0");
            pk.setClientTags("<org.xmlBlaster><demoXPath/></org.xmlBlaster>");
            PublishQos pq = new PublishQos(this.glob);
            MsgUnit msgUnit = new MsgUnit(pk, "Hi", pq);
            PublishReturnQos tmp = this.senderConnection.publish(msgUnit);
            Assert.assertEquals("returned oid", oid, tmp.getKeyOid());
            Assert.assertEquals("numReceived after publishing", 1, this.updateInterceptor.waitOnUpdate(2000L, oid, "OK"));
            Assert.assertEquals("", 1, this.updateInterceptor.getMsgs().length);
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, e.getMessage());
            Assert.fail(e.getMessage());
        }
        try {
            EraseReturnQos[] arr = this.senderConnection.erase("<key oid='" + oid + "'/>", "<qos/>");
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
    }

    public void testPublishAfterSubscribeXPath() {
        this.ME = "TestSubXPath:testPublishAfterSubscribeXPath()";
        this.subscribeXPath("/xmlBlaster/key/AGENT[@id='message_3']");
        Assert.assertEquals("numReceived after subscribe", 0, this.updateInterceptor.waitOnUpdate(1000L, null, null));
        this.updateInterceptor.clear();
        int n = 4;
        int i = 0;
        while (i < n) {
            this.log.info(this.ME, "TEST " + (i + 1) + " - publishing 5 messages, expecting No.3");
            this.doPublish();
            Assert.assertEquals("numReceived after publishing", 1, this.updateInterceptor.waitOnUpdate(2000L, "3", "OK"));
            Assert.assertEquals("", 1, this.updateInterceptor.getMsgs().length);
            Msg msg = this.updateInterceptor.getMsgs()[0];
            Assert.assertEquals("Corrupt content", this.senderName, msg.getUpdateQos().getSender().getLoginName());
            Assert.assertEquals("Corrupt content", "Content: message_3", msg.getContentStr());
            Assert.assertEquals("Message contentMime is corrupted", "text/xml", msg.getUpdateKey().getContentMime());
            Assert.assertEquals("engine.qos.update.subscriptionId: Wrong subscriptionId", this.subscribeOid, msg.getUpdateQos().getSubscriptionId());
            this.updateInterceptor.clear();
            ++i;
        }
        String xmlKey = "<key oid='' queryType='XPATH'>\n   /xmlBlaster/key/AGENT</key>";
        try {
            EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, "<qos/>");
            Assert.assertEquals("Erase", this.numPublish, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        suite.addTest(new TestSubXPath(new Global(), "testInitial", loginName));
        suite.addTest(new TestSubXPath(new Global(), "testPublishAfterSubscribeXPath", loginName));
        return suite;
    }

    public static void main(String[] args) {
        TestSubXPath testSub = new TestSubXPath(new Global(args), "TestSubXPath", "Tim");
        testSub.setUp();
        testSub.testInitial();
        testSub.tearDown();
    }
}

