/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestSubXPathMany
extends TestCase {
    private static String ME = "TestSubXPathMany";
    private final Global glob;
    private final LogChannel log;
    private String publishOid = "";
    private I_XmlBlasterAccess con1;
    private I_XmlBlasterAccess con2;
    private I_XmlBlasterAccess con3;
    private int numReceived1 = 0;
    private StringBuffer messageArrived1 = new StringBuffer();
    private int numReceived2 = 0;
    private StringBuffer messageArrived2 = new StringBuffer();
    private int numReceived3 = 0;
    private StringBuffer messageArrived3 = new StringBuffer();

    public TestSubXPathMany(String name) {
        super(name);
        this.glob = new Global();
        this.log = this.glob.getLog(null);
    }

    public TestSubXPathMany(Global glob) {
        super("TestSubXPathMany");
        this.glob = glob;
        this.log = glob.getLog(null);
    }

    protected void setUp() {
        try {
            Global glob1 = this.glob.getClone(null);
            this.con1 = glob1.getXmlBlasterAccess();
            ConnectQos connectQos = new ConnectQos(glob1, "con1", "secret");
            this.con1.connect(connectQos, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    TestSubXPathMany.this.log.info("con1", "Reveiving asynchronous message '" + updateKey.getOid() + "' in default handler");
                    TestSubXPathMany.this.numReceived1++;
                    Assert.assertEquals("Message not expected", "command-navigation", updateKey.getOid());
                    TestSubXPathMany.this.messageArrived1.append("OK");
                    return "";
                }
            });
            Global glob2 = this.glob.getClone(null);
            this.con2 = glob2.getXmlBlasterAccess();
            connectQos = new ConnectQos(glob2, "con2", "secret");
            this.con2.connect(connectQos, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    TestSubXPathMany.this.log.info("con2", "Reveiving asynchronous message '" + updateKey.getOid() + "' in default handler");
                    TestSubXPathMany.this.numReceived2++;
                    Assert.assertEquals("Message not expected", "command-radar-1", updateKey.getOid());
                    TestSubXPathMany.this.messageArrived2.append("OK");
                    return "";
                }
            });
            Global glob3 = this.glob.getClone(null);
            this.con3 = glob3.getXmlBlasterAccess();
            connectQos = new ConnectQos(glob3, "con3", "secret");
            this.con3.connect(connectQos, new I_Callback(){

                public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
                    TestSubXPathMany.this.log.info("con3", "Reveiving asynchronous message '" + updateKey.getOid() + "' in default handler");
                    TestSubXPathMany.this.numReceived3++;
                    Assert.assertEquals("Message not expected", "command-radar-1", updateKey.getOid());
                    TestSubXPathMany.this.messageArrived3.append("OK");
                    return "";
                }
            });
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "login failed: " + e.toString());
            Assert.fail("Login failed: " + e.toString());
        }
    }

    protected void tearDown() {
        if (this.con1 != null) {
            try {
                EraseKey ek = new EraseKey(this.glob, "command-navigation");
                EraseQos eq = new EraseQos(this.glob);
                this.con1.erase(ek.toXml(), eq.toXml());
                ek = new EraseKey(this.glob, "command-radar-1");
                eq = new EraseQos(this.glob);
                this.con1.erase(ek.toXml(), eq.toXml());
                ek = new EraseKey(this.glob, "dummyTestSubXPathMany");
                eq = new EraseQos(this.glob);
                this.con1.erase(ek.toXml(), eq.toXml());
            }
            catch (XmlBlasterException e) {
                Assert.fail("doPublish failed: " + e.toString());
            }
            this.con1.disconnect(null);
        }
        if (this.con2 != null) {
            this.con2.disconnect(null);
            this.con2 = null;
        }
        if (this.con3 != null) {
            this.con3.disconnect(null);
            this.con3 = null;
        }
    }

    public void doSubscribe() {
        this.log.info(ME, "*****Subscribing using XPath syntax ...");
        try {
            SubscribeKey sk = new SubscribeKey(this.glob, "//key[@oid = 'command-navigation']", "XPATH");
            SubscribeQos sq = new SubscribeQos(this.glob);
            String subId = this.con1.subscribe(sk.toXml(), sq.toXml()).getSubscriptionId();
            String xpath2 = "//key[starts-with(@oid,'command-radar')]";
            sk = new SubscribeKey(this.glob, xpath2, "XPATH");
            sq = new SubscribeQos(this.glob);
            subId = this.con2.subscribe(sk.toXml(), sq.toXml()).getSubscriptionId();
            sk = new SubscribeKey(this.glob, xpath2, "XPATH");
            sq = new SubscribeQos(this.glob);
            String string = this.con3.subscribe(sk.toXml(), sq.toXml()).getSubscriptionId();
        }
        catch (XmlBlasterException e) {
            Assert.fail("doPublish failed: " + e.toString());
        }
    }

    public void doPublish() {
        this.log.info(ME, "*****Publishing messages ...");
        try {
            PublishKey pk = new PublishKey(this.glob, "command-navigation", "text/plain", "1.0");
            PublishQos pq = new PublishQos(this.glob);
            MsgUnit msgUnit = new MsgUnit(pk.toXml(), "Hi".getBytes(), pq.toXml());
            PublishReturnQos retQos = this.con1.publish(msgUnit);
            this.log.info(ME, "Published message '" + pk.getOid() + "'");
            pk = new PublishKey(this.glob, "command-radar-1", "text/plain", "1.0");
            pq = new PublishQos(this.glob);
            msgUnit = new MsgUnit(pk.toXml(), "Hi".getBytes(), pq.toXml());
            retQos = this.con1.publish(msgUnit);
            this.log.info(ME, "Published message '" + pk.getOid() + "'");
            pk = new PublishKey(this.glob, "dummyTestSubXPathMany", "text/plain", "1.0");
            pq = new PublishQos(this.glob);
            msgUnit = new MsgUnit(pk.toXml(), "Hi".getBytes(), pq.toXml());
            retQos = this.con1.publish(msgUnit);
            this.log.info(ME, "Published message '" + pk.getOid() + "'");
        }
        catch (XmlBlasterException e) {
            Assert.fail("doPublish failed: " + e.toString());
        }
    }

    public void testIt() {
        this.doSubscribe();
        try {
            Thread.currentThread();
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Assert.assertEquals("numReceived1 after subscribe", 0, this.numReceived1);
        Assert.assertEquals("numReceived2 after subscribe", 0, this.numReceived2);
        Assert.assertEquals("numReceived3 after subscribe", 0, this.numReceived3);
        this.doPublish();
        this.waitOnUpdate(2000L, this.messageArrived1);
        Assert.assertEquals("numReceived1 after publishing", 1, this.numReceived1);
        this.waitOnUpdate(2000L, this.messageArrived2);
        Assert.assertEquals("numReceived2 after publishing", 1, this.numReceived2);
        this.waitOnUpdate(2000L, this.messageArrived3);
        Assert.assertEquals("numReceived3 after publishing", 1, this.numReceived3);
        this.numReceived3 = 0;
        this.numReceived2 = 0;
        this.numReceived1 = 0;
        this.messageArrived1.setLength(0);
        this.messageArrived2.setLength(0);
        this.messageArrived3.setLength(0);
        if (this.con3 != null) {
            this.con3.disconnect(null);
            this.con3 = null;
        }
        this.doPublish();
        this.waitOnUpdate(2000L, this.messageArrived1);
        Assert.assertEquals("numReceived1 after publishing", 1, this.numReceived1);
        this.waitOnUpdate(2000L, this.messageArrived2);
        Assert.assertEquals("numReceived2 after publishing", 1, this.numReceived2);
        this.waitOnUpdate(2000L, this.messageArrived3);
        Assert.assertEquals("numReceived3 after publishing", 0, this.numReceived3);
        this.numReceived3 = 0;
        this.numReceived2 = 0;
        this.numReceived1 = 0;
        this.messageArrived1.setLength(0);
        this.messageArrived2.setLength(0);
        this.messageArrived3.setLength(0);
    }

    private void waitOnUpdate(long timeout, StringBuffer messageArrived) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (messageArrived.length() < 1) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
        messageArrived.setLength(0);
    }

    public static void main(String[] args) {
        TestSubXPathMany testSub = new TestSubXPathMany(new Global(args));
        testSub.setUp();
        testSub.testIt();
        testSub.tearDown();
    }
}

