/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.qos;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UnSubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class TestUnSub
extends TestCase
implements I_Callback {
    private static String ME = "TestUnSub";
    private final Global glob;
    private final LogChannel log;
    private boolean messageArrived = false;
    private String subscribeOid;
    private String publishOid = "";
    private I_XmlBlasterAccess senderConnection;
    private String senderName;
    private String senderContent;
    private String receiverName;
    private String xpath = "//TestUnSub-AGENT";
    private int numReceived = 0;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "1.0";

    public TestUnSub(Global glob, String testName, String loginName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.senderName = loginName;
        this.receiverName = loginName;
    }

    protected void setUp() {
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            this.senderConnection.connect(connectQos, this);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        if (this.publishOid.length() > 0) {
            String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + this.publishOid + "' queryType='EXACT'>\n" + "</key>";
            try {
                EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, "<qos/>");
                Assert.assertEquals("Erase", 1, arr.length);
            }
            catch (XmlBlasterException e) {
                Assert.fail("Erase XmlBlasterException: " + e.getMessage());
            }
        }
        this.senderConnection.disconnect(null);
    }

    public void subscribeXPath() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using XPath syntax ...");
        }
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' queryType='XPATH'>\n   " + this.xpath + "</key>";
        String qos = "<qos></qos>";
        this.numReceived = 0;
        this.subscribeOid = null;
        try {
            this.subscribeOid = this.senderConnection.subscribe(xmlKey, qos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on " + this.subscribeOid + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned null subscribeOid", this.subscribeOid != null);
        Assert.assertTrue("returned subscribeOid is empty", 0 != this.subscribeOid.length());
    }

    public void unSubscribeXPath() {
        if (this.log.TRACE) {
            this.log.trace(ME, "UnSubscribing using XPath syntax ...");
        }
        String xmlKey = "<key oid='' queryType='XPATH'>\n   " + this.xpath + "</key>";
        String qos = "<qos></qos>";
        this.numReceived = 0;
        try {
            this.senderConnection.unSubscribe(xmlKey, qos);
            this.log.info(ME, "Success: UnSubscribe with " + this.xpath + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("unSubscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void unSubscribeExact() {
        if (this.log.TRACE) {
            this.log.trace(ME, "UnSubscribing using EXACT syntax ...");
        }
        String xmlKey = "<key oid='" + this.subscribeOid + "' queryType='EXACT'>\n" + "</key>";
        String qos = "<qos></qos>";
        this.numReceived = 0;
        try {
            this.senderConnection.unSubscribe(xmlKey, qos);
            this.log.info(ME, "Success: UnSubscribe on " + this.subscribeOid + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("unSubscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void doPublish() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' contentMime='text/xml' contentMimeExtended='1.0'>\n   <TestUnSub-AGENT id='192.168.124.10' subId='1' type='generic'>      <TestUnSub-DRIVER id='FileProof' pollingFreq='10'>      </TestUnSub-DRIVER>   </TestUnSub-AGENT></key>";
        this.senderContent = "Yeahh, i'm the new content";
        PublishReturnQos publishReturnQos = null;
        try {
            MsgUnit msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), "<qos></qos>");
            publishReturnQos = this.senderConnection.publish(msgUnit);
            this.publishOid = publishReturnQos.getKeyOid();
            this.log.info(ME, "Success: Publishing done, returned oid=" + this.publishOid);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        Assert.assertTrue("returned publishOid == null", this.publishOid != null);
        Assert.assertTrue("returned publishOid: " + publishReturnQos.toXml(), 0 != this.publishOid.length());
    }

    public void testSubscribeUnSubscribeOid() {
        this.log.info(ME, "Starting testSubscribeUnSubscribeOid()");
        this.publishOid = "";
        String oid = "SomeDummySubscribe";
        SubscribeReturnQos subRet = null;
        try {
            SubscribeKey sk = new SubscribeKey(this.glob, oid);
            SubscribeQos sq = new SubscribeQos(this.glob);
            subRet = this.senderConnection.subscribe(sk.toXml(), sq.toXml());
            this.log.info(ME, "testSubscribeUnSubscribeOid() subscribed to " + subRet.getSubscriptionId());
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "testSubscribeUnSubscribeOid() subscribe failed: " + e.getMessage());
            Assert.fail("testSubscribeUnSubscribeOid() subscribe failed: " + e.getMessage());
        }
        try {
            UnSubscribeKey uk = new UnSubscribeKey(this.glob, oid);
            UnSubscribeQos uq = new UnSubscribeQos(this.glob);
            UnSubscribeReturnQos[] urq = this.senderConnection.unSubscribe(uk.toXml(), uq.toXml());
            this.log.info(ME, "testSubscribeUnSubscribeOid() unSubscribed");
            Assert.assertEquals("Return wrong", 1, urq.length);
            Assert.assertEquals("SubId wrong", subRet.getSubscriptionId(), urq[0].getSubscriptionId());
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "testSubscribeUnSubscribeOid() unSubscribe failed: " + e.getMessage());
            Assert.fail("testSubscribeUnSubscribeOid() unSubscribe failed: " + e.getMessage());
        }
    }

    public void testSubscribeUnSubscribeEmpty() {
        this.log.info(ME, "Starting testSubscribeUnSubscribeEmpty()");
        this.publishOid = "";
        SubscribeReturnQos subRet = null;
        try {
            SubscribeKey sk = new SubscribeKey(this.glob, "SomeDummySubscribe");
            SubscribeQos sq = new SubscribeQos(this.glob);
            subRet = this.senderConnection.subscribe(sk.toXml(), sq.toXml());
            this.log.info(ME, "testSubscribeUnSubscribeEmpty() subscribed to " + subRet.getSubscriptionId());
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "testSubscribeUnSubscribeEmpty() subscribe failed: " + e.getMessage());
            Assert.fail("testSubscribeUnSubscribeEmpty() subscribe failed: " + e.getMessage());
        }
        try {
            UnSubscribeKey uk = new UnSubscribeKey(this.glob, subRet.getSubscriptionId());
            UnSubscribeQos uq = new UnSubscribeQos(this.glob);
            UnSubscribeReturnQos[] urq = this.senderConnection.unSubscribe(uk.toXml(), uq.toXml());
            this.log.info(ME, "testSubscribeUnSubscribeEmpty() unSubscribed");
            Assert.assertEquals("Return wrong", 1, urq.length);
            Assert.assertEquals("SubId wrong", subRet.getSubscriptionId(), urq[0].getSubscriptionId());
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "testSubscribeUnSubscribeEmpty() unSubscribe failed: " + e.getMessage());
            Assert.fail("testSubscribeUnSubscribeEmpty() unSubscribe failed: " + e.getMessage());
        }
    }

    public void testSubscribeUnSubscribeExact() {
        this.log.info(ME, "Starting testSubscribeUnSubscribeExact()");
        this.numReceived = 0;
        this.doPublish();
        this.subscribeXPath();
        this.waitOnUpdate(2000L);
        Assert.assertEquals("numReceived after publishing", 1, this.numReceived);
        this.unSubscribeExact();
    }

    public void testSubscribeUnSubscribeXPath() {
        this.log.info(ME, "Starting testSubscribeUnSubscribeXPath()");
        this.numReceived = 0;
        this.doPublish();
        this.subscribeXPath();
        this.waitOnUpdate(2000L);
        Assert.assertEquals("numReceived after publishing", 1, this.numReceived);
        this.unSubscribeXPath();
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
        ++this.numReceived;
        Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
        Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        Assert.assertEquals("Message contentMime is corrupted", "text/xml", updateKey.getContentMime());
        Assert.assertEquals("Message contentMimeExtended is corrupted", "1.0", updateKey.getContentMimeExtended());
        this.messageArrived = true;
        return "";
    }

    private void waitOnUpdate(long timeout) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (!this.messageArrived) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
        this.messageArrived = false;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "TestUnSub/5";
        Global glob = new Global();
        suite.addTest(new TestUnSub(glob, "testSubscribeUnSubscribeEmpty", loginName));
        suite.addTest(new TestUnSub(glob, "testSubscribeUnSubscribeOid", loginName));
        suite.addTest(new TestUnSub(glob, "testSubscribeUnSubscribeExact", loginName));
        suite.addTest(new TestUnSub(glob, "testSubscribeUnSubscribeXPath", loginName));
        return suite;
    }

    public static void main(String[] args) {
        TestUnSub testSub = new TestUnSub(new Global(args), "TestUnSub", "TestUnSub/5");
        testSub.setUp();
        testSub.testSubscribeUnSubscribeOid();
        testSub.tearDown();
        testSub.setUp();
        testSub.testSubscribeUnSubscribeEmpty();
        testSub.tearDown();
        testSub.setUp();
        testSub.testSubscribeUnSubscribeXPath();
        testSub.tearDown();
        testSub.setUp();
        testSub.testSubscribeUnSubscribeExact();
        testSub.tearDown();
    }
}

