/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.stress;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class BigMessage
extends TestCase
implements I_Callback {
    private static String ME = "BigMessage";
    private final Global glob = Global.instance();
    private final LogChannel log = this.glob.getLog(null);
    private I_XmlBlasterAccess con = null;
    private String name;
    private String passwd = "secret";
    private EmbeddedXmlBlaster serverThread;
    private boolean startEmbedded = true;
    private int serverPort = 7615;
    private String oid = "BigMessage";
    private int contentSize = 3000000;
    private boolean messageArrived = false;
    private String assertInUpdate = null;
    private StopWatch stopWatchRoundTrip = null;

    public BigMessage(String testName) {
        super(testName);
        this.name = testName;
    }

    protected void setUp() {
        this.contentSize = this.glob.getProperty().get("contentSize", this.contentSize);
        this.startEmbedded = this.glob.getProperty().get("startEmbedded", this.startEmbedded);
        if (this.startEmbedded) {
            this.glob.init(Util.getOtherServerPorts(this.serverPort));
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            this.log.info(ME, "XmlBlaster is ready for testing a big message");
        } else {
            this.log.warn(ME, "You need to start an external xmlBlaster server for this test or use option -startEmbedded true");
        }
        try {
            this.log.info(ME, "Connecting ...");
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob, this.name, this.passwd);
            this.con.connect(qos, this);
        }
        catch (Exception e) {
            Thread.currentThread();
            Thread.dumpStack();
            this.log.error(ME, "Can't connect to xmlBlaster: " + e.toString());
        }
    }

    protected void tearDown() {
        try {
            this.log.info(ME, "Erasing message " + this.oid + " ...");
            EraseReturnQos[] arr = this.con.erase("<key oid='" + this.oid + "'/>", "<qos/>");
            this.log.info(ME, "Erasing of message " + this.oid + " done.");
            Assert.assertEquals("Wrong number of message erased", 1, arr.length);
            Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
        this.con = null;
        if (this.startEmbedded) {
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            Util.resetPorts();
        }
    }

    public void testBigMessage() {
        this.log.info(ME, "######## Start testBigMessage()");
        StopWatch stopWatch = null;
        stopWatch = new StopWatch();
        byte[] content = new byte[this.contentSize];
        int i = 0;
        while (i < content.length) {
            content[i] = (byte)(i % 255);
            ++i;
        }
        this.log.info(ME, "Allocated message content with size=" + content.length / 1000000 + " MB");
        try {
            PublishQos qosWrapper = new PublishQos(this.glob);
            MsgUnit msgUnit = new MsgUnit("<key oid='" + this.oid + "'/>", content, "<qos/>");
            stopWatch = new StopWatch();
            this.stopWatchRoundTrip = new StopWatch();
            this.con.publish(msgUnit);
            long avg = 0L;
            long elapsed = stopWatch.elapsed();
            if (elapsed > 0L) {
                avg = (long)this.contentSize / elapsed;
            }
            this.log.info(ME, "Success: Publishing of " + this.oid + " with size=" + this.contentSize / 1000000 + " MB done, avg=" + avg + " KB/sec " + stopWatch.nice());
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("Can't publish huge message: " + e.getMessage());
        }
        this.messageArrived = false;
        try {
            SubscribeReturnQos subscriptionId = this.con.subscribe("<key oid='" + this.oid + "'/>", "<qos/>");
            this.log.info(ME, "Success: Subscribe on subscriptionId=" + subscriptionId.getSubscriptionId() + " done");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail("subscribe - XmlBlasterException: " + e.getMessage());
        }
        this.waitOnUpdate(20000L);
        Assert.assertTrue(this.assertInUpdate, this.assertInUpdate == null);
        Assert.assertEquals("Message not arrived", true, this.messageArrived);
        try {
            Thread.currentThread();
            Thread.sleep(3000L);
        }
        catch (InterruptedException i2) {
            // empty catch block
        }
        this.log.info(ME, "######## End testBigMessage()");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(ME, "Receiving update of a message state=" + updateQos.getState());
        if (updateQos.isErased()) {
            this.log.info(ME, "Ignore erase event");
            return "";
        }
        long elapsed = this.stopWatchRoundTrip.elapsed();
        long avg = 0L;
        if (elapsed > 0L) {
            avg = (long)this.contentSize / elapsed;
        }
        this.log.info(ME, "Receiving update of message oid=" + updateKey.getOid() + " size=" + content.length + " ...");
        this.log.info(ME, "Success: Publish+Update of " + this.oid + " with size=" + this.contentSize / 1000000 + " MB done, roundtrip avg=" + avg + " KB/sec " + this.stopWatchRoundTrip.nice());
        this.assertInUpdate = "Wrong sender, expected:" + this.name + " but was:" + updateQos.getSender().getLoginName();
        Assert.assertEquals("Wrong sender", this.name, updateQos.getSender().getLoginName());
        this.assertInUpdate = "Wrong oid of message returned expected:" + this.oid + " but was:" + updateKey.getOid();
        Assert.assertEquals("Message oid is wrong", this.oid, updateKey.getOid());
        this.assertInUpdate = "Wrong message size arrived in update, expected:" + this.contentSize + " but was:" + content.length;
        Assert.assertEquals("Wrong message size arrived", this.contentSize, content.length);
        this.assertInUpdate = null;
        this.messageArrived = true;
        return "";
    }

    private void waitOnUpdate(long timeout) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (!this.messageArrived) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.info(ME, "Timeout of " + timeout + " occurred");
            Assert.fail("Timeout of " + timeout + " occurred");
        }
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.exit(0);
        }
        BigMessage big = new BigMessage("BigMessage");
        big.setUp();
        big.testBigMessage();
        big.tearDown();
    }
}

