/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.stress;

import java.io.IOException;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class LoadTestSub
extends TestCase
implements I_Callback {
    private static String ME = "LoadTestSub";
    private boolean messageArrived = false;
    private StopWatch stopWatch = null;
    private Global glob;
    private LogChannel log;
    private String subscribeOid;
    private String publishOid = "LoadTestSub";
    private I_XmlBlasterAccess senderConnection;
    private String senderName;
    private String receiverName;
    private String passwd;
    private final int numPublish;
    private int numReceived = 0;
    private int burstModePublish = 1;
    private boolean publishOneway = false;
    private boolean persistent = false;
    private final String contentMime = "text/plain";
    private final String contentMimeExtended = "1.0";
    private int lastContentNumber = -1;
    private final String someContent = "Yeahh, i'm the new content, my total length is big an bigger but still i want to be longer and longer until i have reached some 180 bytes, here is remaining blahh to fill the last";

    public LoadTestSub() {
        this(new Global(), "LoadTestSub", "LoadTestSub", "secret", 1000, 1, false, false);
    }

    public LoadTestSub(Global glob, String testName, String loginName, String passwd, int numPublish, int burstModePublish, boolean publishOneway, boolean persistent) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.senderName = loginName;
        this.receiverName = loginName;
        this.passwd = passwd;
        this.numPublish = numPublish;
        this.burstModePublish = burstModePublish;
        this.publishOneway = publishOneway;
        this.persistent = persistent;
    }

    protected void setUp() {
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, this.passwd);
            this.senderConnection.connect(connectQos, this);
            if (this.burstModePublish > this.numPublish) {
                this.burstModePublish = this.numPublish;
            }
            if (this.numPublish % this.burstModePublish != 0) {
                this.log.error(ME, "numPublish should by dividable by publish.burstMode");
            }
            this.log.info(ME, "Connected to xmlBlaster, numPublish=" + this.numPublish + " burstModePublish=" + this.burstModePublish + " dispatch/callback/burstMode/collectTime=" + this.glob.getProperty().get("dispatch/callback/burstMode/collectTime", 0L));
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
            Assert.assertTrue(e.toString(), false);
        }
    }

    protected void tearDown() {
        long avg = 0L;
        double elapsed = this.stopWatch.elapsed();
        if (elapsed > 0.0) {
            avg = (long)(1000.0 * (double)this.numPublish / elapsed);
        }
        this.log.info(ME, this.numPublish + " messages updated, average messages/second = " + avg + this.stopWatch.nice());
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='" + this.publishOid + "' queryType='EXACT'>\n" + "</key>";
        String qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, qos);
            if (arr.length != 1) {
                this.log.error(ME, "Erased " + arr.length + " messages:");
            }
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
        }
        this.senderConnection.disconnect(null);
    }

    public void doSubscribeXPath() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using XPath syntax ...");
        }
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='' queryType='XPATH'>\n   //LoadTestSub-AGENT</key>";
        String qos = "<qos></qos>";
        this.numReceived = 0;
        this.subscribeOid = null;
        try {
            this.subscribeOid = this.senderConnection.subscribe(xmlKey, qos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on " + this.subscribeOid + " done");
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
        }
    }

    public void doPublish() {
        this.log.info(ME, "Publishing " + this.numPublish + " messages ...");
        this.numReceived = 0;
        String xmlKey = "<key oid='" + this.publishOid + "' contentMime='" + "text/plain" + "' contentMimeExtended='" + "1.0" + "'>\n" + "   <LoadTestSub-AGENT id='192.168.124.10' subId='1' type='generic'>" + "      <LoadTestSub-DRIVER id='FileProof' pollingFreq='10'>" + "      </LoadTestSub-DRIVER>" + "   </LoadTestSub-AGENT>" + "</key>";
        String qos = "";
        if (this.persistent) {
            qos = "<qos><persistent>true</persistent></qos>";
        }
        MsgUnit[] arr = new MsgUnit[this.burstModePublish];
        try {
            int kk = 0;
            while (kk < this.burstModePublish) {
                arr[kk] = new MsgUnit(xmlKey, "Yeahh, i'm the new content, my total length is big an bigger but still i want to be longer and longer until i have reached some 180 bytes, here is remaining blahh to fill the last".getBytes(), qos);
                ++kk;
            }
        }
        catch (XmlBlasterException e) {
            Assert.fail(e.getMessage());
        }
        this.stopWatch = new StopWatch();
        try {
            int ii = 0;
            while (ii < this.numPublish) {
                int jj = 0;
                while (jj < this.burstModePublish) {
                    arr[jj] = new MsgUnit(arr[jj], null, new String("Yeahh, i'm the new content, my total length is big an bigger but still i want to be longer and longer until i have reached some 180 bytes, here is remaining blahh to fill the last" + (ii + 1)).getBytes(), null);
                    ++jj;
                }
                ii += this.burstModePublish;
                if (this.publishOneway) {
                    this.senderConnection.publishOneway(arr);
                    continue;
                }
                PublishReturnQos[] publishOids = this.senderConnection.publishArr(arr);
            }
            long avg = 0L;
            double elapsed = this.stopWatch.elapsed();
            if (elapsed > 0.0) {
                avg = (long)(1000.0 * (double)this.numPublish / elapsed);
            }
            this.log.info(ME, "Success: Publishing done, " + this.numPublish + " messages sent, average messages/second = " + avg);
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void testManyPublish() {
        this.doSubscribeXPath();
        this.doPublish();
        this.waitOnUpdate(60000L, this.numPublish);
        Assert.assertEquals("numReceived after publishing", this.numPublish, this.numReceived);
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        if (this.log.CALL) {
            this.log.call(ME, "Receiving update of a message ...");
        }
        ++this.numReceived;
        if (this.numReceived % 1000 == 0) {
            long avg = (long)((double)this.numReceived / ((double)this.stopWatch.elapsed() / 1000.0));
            String contentStr = new String(content);
            String tok = "... " + contentStr.substring(contentStr.length() - 10);
            this.log.info(ME, "Success: Update #" + this.numReceived + " received: '" + tok + "', average messages/second = " + avg);
        }
        this.messageArrived = true;
        String currentContent = new String(content);
        int val = -1;
        if (this.lastContentNumber >= 0) {
            String number = currentContent.substring("Yeahh, i'm the new content, my total length is big an bigger but still i want to be longer and longer until i have reached some 180 bytes, here is remaining blahh to fill the last".length());
            try {
                val = new Integer(number);
            }
            catch (NumberFormatException e) {
                this.log.error(ME, e.toString());
            }
            if (val <= this.lastContentNumber) {
                this.log.error(ME, "lastContent=" + this.lastContentNumber + " currentContent=" + currentContent);
            }
        }
        this.lastContentNumber = val;
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(ME, "Timeout of " + timeout + " occurred");
            break;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        int numMsg = 200;
        suite.addTest(new LoadTestSub(new Global(), "testManyPublish", loginName, "secret", numMsg, 200, false, false));
        return suite;
    }

    static void usage() {
        System.out.println("\nAvailable options:");
        System.out.println("   -numPublish         Number of messages to send [5000].");
        System.out.println("   -publish.burstMode  Collect given number of messages when publishing [1].");
        System.out.println("   -publish.oneway     Send messages oneway (publish does not receive return value) [false].");
        System.out.println("   -publish.persistent Send persistent messages if set to true, otherwise transient. [false].");
        System.out.println(Global.instance().usage());
    }

    public static void main(String[] args) {
        Global glob = new Global();
        int ret = glob.init(args);
        if (ret != 0) {
            LoadTestSub.usage();
            System.out.println("Oneway Example: java -Xms18M -Xmx32M org.xmlBlaster.test.stress.LoadTestSub -publish.oneway true -burstMode/collectTime 500 -dispatch/callback/oneway true -dispatch/callback/burstMode/collectTime 200 -numPublish 5000 -protocol IOR");
            System.out.println("Syn    Example: java -Xms18M -Xmx32M org.xmlBlaster.test.stress.LoadTestSub -publish.oneway false -dispatch/callback/oneway false -publish.burstMode 200 -dispatch/callback/burstMode/collectTime 200 -numPublish 5000 -protocol IOR");
            System.exit(1);
        }
        int numPublish = glob.getProperty().get("numPublish", 5000);
        int burstModePublish = glob.getProperty().get("publish.burstMode", 1);
        boolean publishOneway = glob.getProperty().get("publish.oneway", false);
        boolean persistent = glob.getProperty().get("publish.persistent", false);
        LoadTestSub testSub = new LoadTestSub(glob, "LoadTestSub", glob.getProperty().get("name", "Tim"), glob.getProperty().get("passwd", "secret"), numPublish, burstModePublish, publishOneway, persistent);
        testSub.setUp();
        testSub.testManyPublish();
        System.out.println("Success, hit a key to logout and exit");
        try {
            System.in.read();
        }
        catch (IOException e) {
            // empty catch block
        }
        testSub.tearDown();
    }
}

