/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.stress;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.JUtilsException;
import org.jutils.log.LogChannel;
import org.jutils.runtime.ThreadLister;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.j2ee.util.GlobalUtil;
import org.xmlBlaster.protocol.corba.OrbInstanceWrapper;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.storage.CbQueueProperty;

public class MassiveSubTest
extends TestCase
implements I_Callback {
    private int numSubscribers = 5000;
    private int maxSubPerCon = 0;
    private boolean useOneConnection = false;
    private boolean withEmbedded = true;
    private int noToPub = 1;
    private int numToRec = this.numSubscribers * this.noToPub;
    private String ME = "MassiveSubTest";
    private Global glob;
    private LogChannel log;
    private int serverPort = 7615;
    private EmbeddedXmlBlaster serverThread;
    private boolean messageArrived = false;
    private MsgInterceptor updateInterceptor;
    private final String publishOid1 = "dummy1";
    private I_XmlBlasterAccess oneConnection;
    private String oneName;
    private int numReceived = 0;
    private final String contentMime = "text/xml";
    private final String contentMimeExtended = "1.0";
    private GlobalUtil globalUtil;
    private Client[] manyClients;
    private I_XmlBlasterAccess[] manyConnections;
    private StopWatch stopWatch = new StopWatch();

    public MassiveSubTest(String testName) {
        super(testName);
        Global glob_ = Global.instance();
        MassiveSubTest.setProtoMax(glob_, "IOR", "500");
        this.init(glob_, testName, "testManyClients", true);
    }

    public MassiveSubTest(Global glob, String testName, String loginName, boolean useOneConnection) {
        super(testName);
        this.init(glob, testName, loginName, useOneConnection);
    }

    public void init(Global glob, String testName, String loginName, boolean useOneConnection) {
        this.glob = glob;
        this.log = this.glob.getLog("test");
        this.oneName = loginName;
        this.numSubscribers = glob.getProperty().get("numSubscribers", this.numSubscribers);
        this.maxSubPerCon = glob.getProperty().get("maxSubPerCon", this.maxSubPerCon);
        this.withEmbedded = glob.getProperty().get("withEmbedded", this.withEmbedded);
        this.noToPub = glob.getProperty().get("noToPub", this.noToPub);
        this.useOneConnection = useOneConnection;
        String clientProtocol = glob.getProperty().get("client.protocol", "IOR");
        try {
            glob.getProperty().set("client.protocol", clientProtocol);
        }
        catch (JUtilsException ex) {
            Assert.assertTrue("Could not setup test: " + ex, false);
        }
        this.ME = this.ME + ":" + clientProtocol + (useOneConnection ? ":oneCon" : ":manyCon") + ":" + this.numSubscribers + (this.maxSubPerCon > 0 ? "/" + this.maxSubPerCon : "");
        this.numToRec = this.numSubscribers * this.noToPub;
    }

    protected void setUp() {
        String[] args = new String[]{"-ClientProtocolPlugin[LOCAL][1.0]", "org.xmlBlaster.client.protocol.local.LocalConnection", "-ClientCbServerProtocolPlugin[LOCAL][1.0]", "org.xmlBlaster.client.protocol.local.LocalCallbackImpl", "-CbProtocolPlugin[LOCAL][1.0]", "org.xmlBlaster.protocol.local.CallbackLocalDriver"};
        this.glob.init(args);
        this.log.info(this.ME, "Setting up test ...");
        if (this.withEmbedded) {
            this.glob.init(Util.getOtherServerPorts(this.serverPort));
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            this.log.info(this.ME, "XmlBlaster is ready for testing a lots of subscribers");
            this.globalUtil = new GlobalUtil(this.serverThread.getMain().getGlobal());
        } else {
            this.globalUtil = new GlobalUtil();
        }
        this.glob = this.globalUtil.getClone(this.glob);
        this.numReceived = 0;
        try {
            this.oneConnection = this.glob.getXmlBlasterAccess();
            ConnectQos connectQos = new ConnectQos(this.glob, this.oneName, "secret");
            CbQueueProperty cbProp = connectQos.getSessionCbQueueProperty();
            cbProp.setMaxEntries(this.numSubscribers + 1000);
            cbProp.setMaxEntriesCache(this.numSubscribers + 1000);
            this.updateInterceptor = new MsgInterceptor(this.glob, this.log, this);
            ConnectReturnQos connectReturnQos = this.oneConnection.connect(connectQos, this.updateInterceptor);
            this.log.info(this.ME, "Connected: " + connectReturnQos.toXml());
        }
        catch (Exception e) {
            this.log.error(this.ME, "Login failed: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("Login failed: " + e.toString(), false);
        }
    }

    protected void tearDown() {
        int ii;
        this.log.info(this.ME, "Tearing down");
        if (this.numReceived != this.numToRec) {
            this.log.error(this.ME, "numToRec=" + this.numToRec + " but numReceived=" + this.numReceived);
            Assert.assertEquals("numToRec=" + this.numToRec + " but numReceived=" + this.numReceived, this.numSubscribers, this.numReceived);
        }
        this.log.removeLogLevel("INFO");
        if (this.manyClients != null) {
            ii = 0;
            while (ii < this.numSubscribers) {
                block15: {
                    Client sub = this.manyClients[ii];
                    if (sub.oneConnection) {
                        try {
                            if (sub.connection != null) {
                                sub.connection.unSubscribe("<key oid='" + sub.subscribeOid + "'/>", "<qos/>");
                                break block15;
                            }
                            this.oneConnection.unSubscribe("<key oid='" + sub.subscribeOid + "'/>", "<qos/>");
                        }
                        catch (XmlBlasterException ex) {
                            this.log.error(this.ME, "Could not unsubscribe: " + sub.subscribeOid + ": " + ex);
                        }
                    } else {
                        sub.connection.disconnect(null);
                    }
                }
                ++ii;
            }
        }
        if (this.manyConnections != null) {
            ii = 0;
            while (ii < this.manyConnections.length) {
                this.manyConnections[ii].disconnect(null);
                ++ii;
            }
        }
        this.log.addLogLevel("INFO");
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='dummy1' queryType='EXACT'>\n</key>";
        String qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.oneConnection.erase(xmlKey, qos);
            Assert.assertEquals("Erase", 1, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase-XmlBlasterException: " + e.getMessage());
        }
        this.oneConnection.disconnect(null);
        this.oneConnection = null;
        this.log.info(this.ME, "Logout done");
        if (this.withEmbedded) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
            Util.resetPorts();
        }
        this.glob = null;
        this.log = null;
        this.updateInterceptor = null;
        this.oneConnection = null;
        this.manyClients = null;
        this.manyConnections = null;
        this.stopWatch = null;
    }

    public void subcribeMany() {
        int ci = -1;
        try {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Subscribing ...");
            }
            String passwd = "secret";
            SubscribeKey subKeyW = new SubscribeKey(this.glob, "dummy1");
            String subKey = subKeyW.toXml();
            SubscribeQos subQosW = new SubscribeQos(this.glob);
            String subQos = subQosW.toXml();
            this.manyClients = new Client[this.numSubscribers];
            if (this.maxSubPerCon > 0) {
                if (this.numSubscribers % this.maxSubPerCon != 0) {
                    Assert.assertTrue("numSubscribers not divadable by breakpoint", false);
                }
                this.manyConnections = new I_XmlBlasterAccess[this.numSubscribers / this.maxSubPerCon];
            }
            long usedBefore = this.getUsedServerMemory();
            this.log.info(this.ME, "Setting up " + this.numSubscribers + " subscriber clients ...");
            this.log.removeLogLevel("INFO");
            int startNoThreads = ThreadLister.countThreads();
            this.stopWatch = new StopWatch();
            int ii = 0;
            while (ii < this.numSubscribers) {
                ConnectQos connectQos;
                Global gg;
                Client sub = new Client();
                sub.loginName = "Joe-" + ii;
                sub.oneConnection = this.useOneConnection;
                if (this.useOneConnection) {
                    if (this.maxSubPerCon > 0) {
                        if (ii % this.maxSubPerCon == 0) {
                            ++ci;
                            try {
                                this.log.trace(this.ME, "Creating connection no: " + ci);
                                gg = this.globalUtil.getClone(this.glob);
                                if ("IOR".equals(gg.getProperty().get("protocol", "IOR")) && ci > 0) {
                                    gg.addObjectEntry("connection:org.xmlBlaster.protocol.corba.OrbInstanceWrapper", (OrbInstanceWrapper)this.manyConnections[ci - 1].getGlobal().getObjectEntry("connection:org.xmlBlaster.protocol.corba.OrbInstanceWrapper"));
                                }
                                this.manyConnections[ci] = gg.getXmlBlasterAccess();
                                connectQos = new ConnectQos(gg, sub.loginName, passwd);
                                CbQueueProperty cbProp = connectQos.getSessionCbQueueProperty();
                                cbProp.setMaxEntries(this.maxSubPerCon * 1000);
                                this.log.trace(this.ME, "Login qos: " + connectQos.toXml());
                                ConnectReturnQos connectReturnQos = this.manyConnections[ci].connect(connectQos, this);
                                this.log.info(this.ME, "Connected maxSubPerCon=" + this.maxSubPerCon + " : " + connectReturnQos.toXml());
                            }
                            catch (Exception e) {
                                this.log.error(this.ME, "Login failed: " + e.toString());
                                Assert.assertTrue("Login failed: " + e.toString(), false);
                            }
                        }
                        sub.connection = this.manyConnections[ci];
                    } else {
                        sub.connection = this.oneConnection;
                    }
                } else {
                    try {
                        gg = this.globalUtil.getClone(this.glob);
                        sub.connection = gg.getXmlBlasterAccess();
                        connectQos = new ConnectQos(gg, sub.loginName, passwd);
                        ConnectReturnQos connectReturnQos = sub.connection.connect(connectQos, this);
                        this.log.info(this.ME, "Connected: " + connectReturnQos.toXml());
                    }
                    catch (Exception e) {
                        this.log.error(this.ME, "Login failed: " + e.toString());
                        Assert.assertTrue("Login failed: " + e.toString(), false);
                    }
                }
                try {
                    sub.subscribeOid = sub.connection.subscribe(subKey, subQos).getSubscriptionId();
                    this.log.trace(this.ME, "Client " + sub.loginName + " subscribed to " + subKeyW.getOid());
                }
                catch (XmlBlasterException e) {
                    this.log.warn(this.ME, "XmlBlasterException: " + e.getMessage());
                    Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
                }
                this.manyClients[ii] = sub;
                ++ii;
            }
            double timeForLogins = (double)this.stopWatch.elapsed() / 1000.0;
            this.log.addLogLevel("INFO");
            long usedAfter = this.getUsedServerMemory();
            long memPerLogin = (usedAfter - usedBefore) / (long)this.numSubscribers;
            int noThreads = ThreadLister.countThreads();
            int tDiff = noThreads - startNoThreads;
            int tPerConn = ci == 0 || ci == -1 ? tDiff : tDiff / (ci + 1);
            int subPerT = tDiff != 0 ? this.numSubscribers / tDiff : 0;
            this.log.info(this.ME, this.numSubscribers + " subscriber clients are ready.");
            this.log.info(this.ME, "Server memory per login consumed=" + memPerLogin);
            this.log.info(this.ME, "Time " + (long)((double)this.numSubscribers / timeForLogins) + " logins/sec");
            this.log.info(this.ME, "Threads created " + tDiff + ", threads per connection " + tPerConn + ", sub  per thread " + subPerT);
        }
        catch (Error e) {
            e.printStackTrace();
            this.log.error(this.ME, "Could not set up subscribers: " + e);
            this.log.error(this.ME, "No of threads " + ThreadLister.countThreads() + " for connection no " + ci);
            throw e;
        }
    }

    long getUsedServerMemory() {
        String xmlKey = "<key oid='__cmd:?usedMem' queryType='EXACT'></key>";
        String qos = "<qos></qos>";
        try {
            MsgUnit[] msgArr = this.oneConnection.get(xmlKey, qos);
            String mem = new String(msgArr[0].getContent());
            return new Long(mem);
        }
        catch (XmlBlasterException e) {
            this.log.warn(this.ME, e.toString());
            return 0L;
        }
    }

    public void publish() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Publishing a message ...");
        }
        this.numReceived = 0;
        String xmlKey = "<?xml version='1.0' encoding='ISO-8859-1' ?>\n<key oid='dummy1' contentMime='text/xml' contentMimeExtended='1.0'>\n</key>";
        String senderContent = "Yeahh, i'm the new content";
        try {
            this.stopWatch = new StopWatch();
            int i = 0;
            while (i < this.noToPub) {
                senderContent = senderContent + "-" + i;
                MsgUnit msgUnit = new MsgUnit(xmlKey, senderContent.getBytes(), "<qos></qos>");
                String tmp = this.oneConnection.publish(msgUnit).getKeyOid();
                Assert.assertEquals("Wrong publishOid1", "dummy1", tmp);
                this.log.info(this.ME, "Success: Publishing done for " + i + ", returned oid=" + "dummy1");
                ++i;
            }
        }
        catch (XmlBlasterException e) {
            this.log.warn(this.ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publishOne - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        ++this.numReceived;
        if (this.numReceived == this.numToRec) {
            long avg = 0L;
            double elapsed = this.stopWatch.elapsed();
            if (elapsed > 0.0) {
                avg = (long)(1000.0 * (double)this.numReceived / elapsed);
            }
            this.log.info(this.ME, this.numReceived + " messages updated, average messages/second = " + avg + this.stopWatch.nice());
        }
        return "";
    }

    public void testManyClients() {
        this.log.plain(this.ME, "");
        this.log.info(this.ME, "TEST 1, many clients, useOneConnection=" + this.useOneConnection);
        this.subcribeMany();
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        Assert.assertEquals("numReceived after subscribe", 0, this.numReceived);
        this.publish();
        long delay = 2000L + (long)(10 * this.numToRec);
        this.log.info(this.ME, "Waiting long enough for updates ..." + delay);
        Util.delay(delay);
        if (this.numReceived != this.numToRec) {
            this.log.warn(this.ME, "Have not yet received more than " + this.numReceived + "/" + this.numToRec + " waiting some more");
            int midRec = this.numReceived;
            long avg = 0L;
            double elapsed = this.stopWatch.elapsed();
            if (elapsed > 0.0) {
                avg = (long)(1000.0 * (double)this.numReceived / elapsed);
            }
            this.log.info(this.ME, this.numReceived + " messages updated, average firts round messages/second = " + avg + this.stopWatch.nice(false));
            Util.delay(2L * delay);
            if (this.numReceived != this.numToRec) {
                this.log.warn(this.ME, "Have NOT yet received more than " + this.numReceived + "/" + this.numToRec + " waiting last round");
                avg = 0L;
                elapsed = (double)this.stopWatch.elapsed() - elapsed;
                if (elapsed > 0.0) {
                    avg = (long)(1000.0 * (double)(this.numReceived - midRec) / elapsed);
                }
                this.log.info(this.ME, this.numReceived - midRec + " messages updated this round, average second round messages/second = " + avg + this.stopWatch.nice(false));
                Util.delay(4L * delay);
            }
        }
        this.log.info(this.ME, "Got messages:" + this.numReceived + "/" + this.numToRec);
        Assert.assertEquals("Wrong number of updates", this.numToRec, this.numReceived);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        Global glob = Global.instance();
        MassiveSubTest.setProtoMax(glob, "IOR", "0");
        suite.addTest(new MassiveSubTest(glob, "testManyClients", loginName, true));
        MassiveSubTest.setProtoMax(glob, "IOR", "500");
        suite.addTest(new MassiveSubTest(glob, "testManyClients", loginName, true));
        MassiveSubTest.setProtoMax(glob, "RMI", "0");
        suite.addTest(new MassiveSubTest(glob, "testManyClients", loginName, true));
        MassiveSubTest.setProtoMax(glob, "RMI", "500");
        suite.addTest(new MassiveSubTest(glob, "testManyClients", loginName, true));
        MassiveSubTest.setProtoMax(glob, "IOR", "0");
        suite.addTest(new MassiveSubTest(glob, "testManyClients", loginName, false));
        MassiveSubTest.setProtoMax(glob, "RMI", "0");
        suite.addTest(new MassiveSubTest(glob, "testManyClients", loginName, false));
        return suite;
    }

    private static void setProtoMax(Global glob, String proto, String max) {
        try {
            glob.getProperty().set("client.protocol", proto);
            glob.getProperty().set("maxSubPerCon", max);
        }
        catch (JUtilsException ex) {
            Assert.assertTrue("Could not setup test: " + ex, false);
        }
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        MassiveSubTest.setProtoMax(glob, "IOR", "500");
        MassiveSubTest m = new MassiveSubTest(glob, "testManyClients", "testManyClients", false);
        m.setUp();
        m.testManyClients();
        m.tearDown();
    }

    class Client {
        String loginName;
        I_XmlBlasterAccess connection;
        String subscribeOid;
        boolean oneConnection;

        Client() {
        }
    }
}

