/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.stress;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.jutils.runtime.Memory;
import org.jutils.time.StopWatch;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;

public class RamTest
extends TestCase {
    private static String ME = "Tim";
    private final Global glob;
    private final LogChannel log;
    private StopWatch stopWatch = null;
    private String publishOid = "";
    private I_XmlBlasterAccess senderConnection;
    private String senderName;
    private String senderContent;
    private final int numPublish;
    private final String contentMime = "text/plain";
    private final String contentMimeExtended = "1.0";

    public RamTest() {
        this(new Global(), "RamTest", "RamTest", 1000);
    }

    public RamTest(Global glob, String testName, String loginName, int numPublish) {
        super(testName);
        this.glob = glob;
        this.log = glob.getLog("test");
        this.senderName = loginName;
        this.numPublish = numPublish;
    }

    protected void setUp() {
        try {
            this.senderConnection = this.glob.getXmlBlasterAccess();
            String passwd = "secret";
            ConnectQos connectQos = new ConnectQos(this.glob, this.senderName, passwd);
            this.senderConnection.connect(connectQos, null);
        }
        catch (Exception e) {
            this.log.error(ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        this.log.info(ME, "tearDown() ...");
        this.stopWatch = new StopWatch();
        int ii = 0;
        while (ii < this.numPublish) {
            String xmlKey = "<key oid='RamTest-" + (ii + 1) + "'>\n" + "</key>";
            String qos = "<qos></qos>";
            try {
                EraseReturnQos[] arr = this.senderConnection.erase(xmlKey, qos);
                Assert.assertTrue("returned erased oid array == null", null != arr);
                Assert.assertEquals("num erased messages is wrong", 1, arr.length);
            }
            catch (XmlBlasterException e) {
                this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            }
            ++ii;
        }
        long avg = 0L;
        double elapsed = this.stopWatch.elapsed();
        if (elapsed > 0.0) {
            avg = (long)(1000.0 * (double)this.numPublish / elapsed);
        }
        this.log.info(ME, "Success: Erasing done, " + this.numPublish + " messages erased, average messages/second = " + avg);
        this.senderConnection.disconnect(null);
    }

    public void doPublish() {
        this.log.info(ME, "Publishing " + this.numPublish + " messages ...");
        long usedMemBefore = 0L;
        MsgUnit[] msgUnitArr = new MsgUnit[this.numPublish];
        try {
            String xmlKey;
            int ii = 0;
            while (ii < this.numPublish) {
                MsgUnit msgUnit;
                xmlKey = "<key oid='RamTest-" + (ii + 1) + "' contentMime='" + "text/plain" + "' contentMimeExtended='" + "1.0" + "'>\n" + "   <RamTest-AGENT id='192.168.124.10' subId='1' type='generic'>" + "      <RamTest-DRIVER id='FileProof' pollingFreq='10'>" + "      </RamTest-DRIVER>" + "   </RamTest-AGENT>" + "</key>";
                this.senderContent = "" + (ii + 1);
                msgUnitArr[ii] = msgUnit = new MsgUnit(xmlKey, this.senderContent.getBytes(), "<qos></qos>");
                ++ii;
            }
            xmlKey = "<key oid='__cmd:?usedMem' queryType='EXACT'></key>";
            String qos = "<qos></qos>";
            MsgUnit[] msgArr = this.senderConnection.get(xmlKey, qos);
            Assert.assertTrue("returned msgArr == null", null != msgArr);
            Assert.assertEquals("msgArr.length!=1", 1, msgArr.length);
            Assert.assertTrue("returned msgArr[0].msgUnit == null", null != msgArr[0]);
            Assert.assertTrue("returned msgArr[0].msgUnit.content == null", null != msgArr[0].getContent());
            Assert.assertTrue("returned msgArr[0].msgUnit.content.length == 0", 0 != msgArr[0].getContent().length);
            String mem = new String(msgArr[0].getContent());
            usedMemBefore = new Long(mem);
            this.log.info(ME, "xmlBlaster used allocated memory before publishing = " + Memory.byteString(usedMemBefore));
            this.stopWatch = new StopWatch();
            PublishReturnQos[] publishOidArr = this.senderConnection.publishArr(msgUnitArr);
            long avg = 0L;
            double elapsed = this.stopWatch.elapsed();
            if (elapsed > 0.0) {
                avg = (long)(1000.0 * (double)this.numPublish / elapsed);
            }
            this.log.info(ME, "Success: Publishing done, " + this.numPublish + " messages sent, average messages/second = " + avg);
            Assert.assertTrue("returned publishOidArr == null", null != publishOidArr);
            Assert.assertEquals("numPublished is wrong", this.numPublish, publishOidArr.length);
            msgArr = this.senderConnection.get(xmlKey, qos);
            long usedMemAfter = new Long(new String(msgArr[0].getContent()));
            this.log.info(ME, "xmlBlaster used allocated memory after publishing = " + Memory.byteString(usedMemAfter));
            this.log.info(ME, "Consumed memory for each message = " + Memory.byteString((usedMemAfter - usedMemBefore) / (long)this.numPublish));
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
        catch (Exception e) {
            this.log.warn(ME, "Exception: " + e.toString());
            e.printStackTrace();
            Assert.assertTrue("get or publish - Exception: " + e.toString(), false);
        }
    }

    public void testManyPublish() {
        this.doPublish();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        String loginName = "Tim";
        int numMsg = 100;
        suite.addTest(new RamTest(new Global(), "testManyPublish", loginName, numMsg));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        int numPublish = glob.getProperty().get("numPublish", 1000);
        RamTest testSub = new RamTest(glob, "RamTest", "Tim", numPublish);
        testSub.setUp();
        testSub.testManyPublish();
        testSub.tearDown();
    }
}

