/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.topic;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_ConnectionStateListener;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.MsgInterceptor;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.dispatch.ConnectionStateEnum;
import org.xmlBlaster.util.qos.address.CallbackAddress;

public class TestReferenceCount
extends TestCase
implements I_ConnectionStateListener {
    private static String ME = "TestReferenceCount";
    private Global glob;
    private LogChannel log;
    private int serverPort = 7694;
    private EmbeddedXmlBlaster serverThread;
    private String oid = "referenceCountMsg";

    public TestReferenceCount(String testName) {
        this(null, testName);
    }

    public TestReferenceCount(Global glob, String testName) {
        super(testName);
        this.glob = glob;
    }

    protected void setUp() {
        this.glob = this.glob == null ? new Global() : this.glob;
        this.log = this.glob.getLog("test");
        this.glob.init(Util.getOtherServerPorts(this.serverPort));
    }

    protected void tearDown() {
        this.log.info(ME, "Entering tearDown(), test is finished");
        if (this.serverThread != null) {
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        }
        Util.resetPorts(this.glob);
        Global.instance().shutdown();
        this.glob = null;
        this.log = null;
        this.serverThread = null;
    }

    private Client doConnect(String loginName, I_Callback cb) {
        try {
            Client client = new Client();
            Global gg = this.glob.getClone(null);
            ConnectQos connectQos = new ConnectQos(gg, loginName, "secret");
            CallbackAddress cbAddress = new CallbackAddress(this.glob);
            cbAddress.setRetries(-1);
            connectQos.addCallbackAddress(cbAddress);
            client.con = gg.getXmlBlasterAccess();
            client.con.registerConnectionListener(this);
            client.updateInterceptor = new MsgInterceptor(gg, this.log, cb);
            client.con.connect(connectQos, client.updateInterceptor);
            return client;
        }
        catch (XmlBlasterException e) {
            this.log.warn(ME, "doConnect() - login failed: " + e.getMessage());
            Assert.fail(ME + ".doConnect() failed: " + e.getMessage());
            return null;
        }
    }

    private void doSubscribe(I_XmlBlasterAccess con) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Subscribing using EXACT oid syntax ...");
        }
        try {
            SubscribeKey subscribeKey = new SubscribeKey(con.getGlobal(), this.oid);
            SubscribeQos subscribeQos = new SubscribeQos(con.getGlobal());
            String subscribeOid = con.subscribe(subscribeKey, subscribeQos).getSubscriptionId();
            this.log.info(ME, "Success: Subscribe on " + subscribeOid + " done");
            Assert.assertTrue("returned null subscribeOid", subscribeOid != null);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail(ME + ".doSubscribe() failed: " + e.getMessage());
        }
    }

    private void doPublish(I_XmlBlasterAccess con) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Publishing a message");
        }
        try {
            PublishKey publishKey = new PublishKey(con.getGlobal(), this.oid);
            PublishQos publishQos = new PublishQos(con.getGlobal());
            publishQos.setPersistent(true);
            String content = "Hi";
            MsgUnit msgUnit = new MsgUnit(publishKey, content.getBytes(), publishQos);
            con.publish(msgUnit);
            this.log.info(ME, "Success: Publishing of " + this.oid + " done");
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail(ME + ".doPublish() failed: " + e.getMessage());
        }
    }

    private void doErase(I_XmlBlasterAccess con) {
        if (this.log.TRACE) {
            this.log.trace(ME, "Erasing ...");
        }
        try {
            EraseKey eraseKey = new EraseKey(con.getGlobal(), this.oid);
            EraseQos eraseQos = new EraseQos(con.getGlobal());
            eraseQos.setForceDestroy(true);
            EraseReturnQos[] arr = con.erase(eraseKey, eraseQos);
        }
        catch (XmlBlasterException e) {
            this.log.error(ME, "XmlBlasterException: " + e.getMessage());
            Assert.fail(ME + ".doErase() failed: " + e.getMessage());
        }
    }

    public void testReferenceCount() {
        this.log.info(ME, "testReferenceCount START");
        this.log.info(ME, "STEP1: Start xmlBlaster server");
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverPort);
        this.log.info(ME, "STEP2: Publish a message twice");
        Client pub = this.doConnect("publisher", null);
        this.doPublish(pub.con);
        this.doPublish(pub.con);
        this.log.info(ME, "STEP3: Start subscriber and subscribe and block in callback");
        Client sub1 = this.doConnect("subscribe/1", new I_Callback(){

            public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
                TestReferenceCount.this.log.info(ME, "Receiving update of a message oid=" + updateKey.getOid() + " priority=" + updateQos.getPriority() + " state=" + updateQos.getState() + " we going to sleep and don't return control to server");
                try {
                    Thread.sleep(1000000L);
                }
                catch (InterruptedException i) {
                    // empty catch block
                }
                TestReferenceCount.this.log.error(ME, "Waiking up from sleep");
                Assert.fail("Waiking up from sleep");
                return "";
            }
        });
        this.doSubscribe(sub1.con);
        Assert.assertEquals("", 1, sub1.updateInterceptor.waitOnUpdate(1000L, 1));
        sub1.updateInterceptor.clear();
        this.log.info(ME, "STEP4: Kill server and thereafter the clients");
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
        pub.con.disconnect(null);
        sub1.con.leaveServer(null);
        this.log.info(ME, "STEP5: Start server and recover message from persistence store");
        this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.serverPort);
        this.log.info(ME, "STEP6: Start subscriber and expect the last not delivered message to be sent automatically");
        sub1 = this.doConnect("subscribe/1", null);
        Assert.assertEquals("", 1, sub1.updateInterceptor.waitOnUpdate(1000L, 1));
        sub1.updateInterceptor.clear();
        sub1.con.disconnect(null);
        this.log.info(ME, "STEP7: Start another subscriber and subscribe");
        Client sub2 = this.doConnect("subscribe2", null);
        this.doSubscribe(sub2.con);
        Assert.assertEquals("", 1, sub2.updateInterceptor.waitOnUpdate(1000L, 1));
        sub2.updateInterceptor.clear();
        this.log.info(ME, "testReferenceCount SUCCESS");
        this.log.info(ME, "STEP8: Cleanup");
        this.doErase(sub2.con);
        sub2.con.disconnect(null);
        EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
        this.serverThread = null;
    }

    public void reachedAlive(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        this.log.info(ME, "I_ConnectionStateListener-" + connection.getId() + ": We were lucky, reconnected to xmlBlaster");
    }

    public void reachedPolling(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        if (this.log != null) {
            this.log.warn(ME, "I_ConnectionStateListener-" + connection.getId() + ": Lost connection to xmlBlaster");
        }
    }

    public void reachedDead(ConnectionStateEnum oldState, I_XmlBlasterAccess connection) {
        if (this.log != null) {
            this.log.error(ME, "DEBUG ONLY: Changed from connection state " + oldState + " to " + ConnectionStateEnum.DEAD);
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestReferenceCount(null, "testReferenceCount"));
        return suite;
    }

    public static void main(String[] args) {
        Global glob = new Global();
        if (glob.init(args) != 0) {
            System.err.println(ME + ": Init failed");
            System.exit(1);
        }
        TestReferenceCount testSub = new TestReferenceCount(glob, "TestReferenceCount");
        testSub.setUp();
        testSub.testReferenceCount();
        testSub.tearDown();
    }

    class Client {
        I_XmlBlasterAccess con;
        MsgInterceptor updateInterceptor;

        Client() {
        }
    }
}

