/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.topic;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.TopicProperty;

public class TestTopicHistory
extends TestCase
implements I_Callback {
    private String ME = "TestTopicHistory";
    private final Global glob;
    private final LogChannel log;
    private final String senderName = "Gesa";
    private I_XmlBlasterAccess con = null;
    private String senderContent = "Some message content";
    private String publishOid = "TestTopicHistoryMsg";
    private SubscribeReturnQos subscribeReturnQos;
    private long blockUpdateTime = 0L;
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 9566;
    private boolean startEmbedded = false;
    private int numReceived = 0;

    public TestTopicHistory(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
        this.startEmbedded = this.glob.getProperty().get("startEmbedded", this.startEmbedded);
        if (this.startEmbedded) {
            this.glob.init(Util.getOtherServerPorts(this.serverPort));
            String[] args = new String[]{};
            this.glob.init(args);
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            this.log.info(this.ME, "XmlBlaster is ready for testing the priority dispatch plugin");
        }
        try {
            String passwd = "secret";
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob);
            this.con.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(this.ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'>\n</key>";
        String qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.con.erase(xmlKey, qos);
            if (arr.length != 0) {
                this.log.error(this.ME, "Erased " + arr.length + " messages instead of 0");
            }
            Assert.assertEquals("Erase", 0, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
        if (this.startEmbedded) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
        }
        Util.resetPorts();
    }

    public EraseReturnQos[] sendErase(boolean forceDestroy) {
        this.log.info(this.ME, "Erasing a topic forceDestroy=" + forceDestroy);
        try {
            EraseQos eq = new EraseQos(this.glob);
            eq.setForceDestroy(forceDestroy);
            EraseKey ek = new EraseKey(this.glob, this.publishOid);
            EraseReturnQos[] er = this.con.erase(ek.toXml(), eq.toXml());
            return er;
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
            return null;
        }
    }

    public void createTopic(String keyOid, TopicProperty topicProperty) {
        this.log.info(this.ME, "Creating topic " + keyOid);
        try {
            PublishKey pk = new PublishKey(this.glob, this.publishOid, "text/xml", "1.0");
            PublishQos pq = new PublishQos(this.glob);
            pq.setTopicProperty(topicProperty);
            MsgUnit msgUnit = new MsgUnit(pk, this.senderContent, pq);
            PublishReturnQos publishReturnQos = this.con.publish(msgUnit);
            Assert.assertEquals("Retunred oid is invalid", this.publishOid, publishReturnQos.getKeyOid());
            this.log.info(this.ME, "Topic oid=" + this.publishOid + " created: " + msgUnit.toXml());
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void sendExpiringMsg(boolean initializeTopic, long topicDestroyDelay, long msgLifeTime) {
        this.log.info(this.ME, "Sending a message initializeTopic=" + initializeTopic + " topicDestroyDelay=" + topicDestroyDelay + " msgLifeTime=" + msgLifeTime);
        try {
            PublishKey pk = new PublishKey(this.glob, this.publishOid, "text/xml", "1.0");
            PublishQos pq = new PublishQos(this.glob);
            pq.setLifeTime(msgLifeTime);
            pq.setForceDestroy(false);
            if (initializeTopic) {
                TopicProperty topicProperty = new TopicProperty(this.glob);
                topicProperty.setDestroyDelay(topicDestroyDelay);
                topicProperty.setCreateDomEntry(false);
                pq.setTopicProperty(topicProperty);
            }
            MsgUnit msgUnit = new MsgUnit(pk, this.senderContent, pq);
            PublishReturnQos publishReturnQos = this.con.publish(msgUnit);
            Assert.assertEquals("Retunred oid is invalid", this.publishOid, publishReturnQos.getKeyOid());
            this.log.info(this.ME, "Sending of '" + this.senderContent + "' done, returned oid=" + this.publishOid + " " + msgUnit.toXml());
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void subscribeMsg() {
        this.log.info(this.ME, "Subscribing message '" + this.publishOid + "'...");
        try {
            SubscribeKey sk = new SubscribeKey(this.glob, this.publishOid);
            SubscribeQos sq = new SubscribeQos(this.glob);
            this.subscribeReturnQos = this.con.subscribe(sk.toXml(), sq.toXml());
            this.log.info(this.ME, "Subscribing of '" + this.publishOid + "' done");
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "subscribe() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void unSubscribeMsg() {
        this.log.info(this.ME, "unSubscribing a volatile message ...");
        try {
            UnSubscribeKey sk = new UnSubscribeKey(this.glob, this.subscribeReturnQos.getSubscriptionId());
            UnSubscribeQos sq = new UnSubscribeQos(this.glob);
            this.con.unSubscribe(sk.toXml(), sq.toXml());
            this.log.info(this.ME, "UnSubscribing of '" + this.publishOid + "' done");
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "unSubscribe() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("unSubscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    private String getDump() {
        try {
            GetKey gk = new GetKey(this.glob, "__cmd:?dump");
            GetQos gq = new GetQos(this.glob);
            MsgUnit[] msgs = this.con.get(gk.toXml(), gq.toXml());
            Assert.assertEquals("Did not expect returned msg for get()", 1, msgs.length);
            return msgs[0].getContentStr();
        }
        catch (XmlBlasterException e) {
            Assert.fail("Didn't expect an exception in get(): " + e.getMessage());
            return "";
        }
    }

    public void testHistory() {
        this.ME = "TestTopicHistory-testHistory";
        this.log.info(this.ME, "Entering testHistory ...");
        this.numReceived = 0;
        String keyOid = "smallTopic";
        TopicProperty topicProperty = new TopicProperty(this.glob);
        long topicDestroyDelay = 6000L;
        topicProperty.setDestroyDelay(topicDestroyDelay);
        topicProperty.setCreateDomEntry(false);
        this.createTopic(keyOid, topicProperty);
        this.log.info(this.ME, "SUCCESS testHistory");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(this.ME, "Receiving update of a message " + updateKey.getOid() + " " + updateQos.getState());
        ++this.numReceived;
        if (updateQos.isOk()) {
            Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
            Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        }
        if (this.blockUpdateTime > 0L) {
            this.log.info(this.ME, "Blocking the update callback for " + this.blockUpdateTime + " millis");
            try {
                Thread.currentThread();
                Thread.sleep(this.blockUpdateTime);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            this.blockUpdateTime = 0L;
            this.log.info(this.ME, "Block released, reset blockTimer");
        }
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(this.ME, "Timeout of " + timeout + " occurred");
            break;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestTopicHistory(new Global(), "testHistory"));
        return suite;
    }

    public static void main(String[] args) {
        TestTopicHistory testSub = new TestTopicHistory(new Global(args), "TestTopicHistory");
        testSub.setUp();
        testSub.testHistory();
        testSub.tearDown();
    }
}

