/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.topic;

import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.GetKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UnSubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.EraseReturnQos;
import org.xmlBlaster.client.qos.GetQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.SubscribeReturnQos;
import org.xmlBlaster.client.qos.UnSubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.test.Util;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.qos.TopicProperty;

public class TestTopicLifeCycle
extends TestCase
implements I_Callback {
    private String ME = "TestTopicLifeCycle";
    private Global glob;
    private LogChannel log;
    private final String senderName = "Gesa";
    private I_XmlBlasterAccess con = null;
    private String senderContent = "Some message content";
    private String publishOid = "TestTopicLifeCycleMsg";
    private SubscribeReturnQos subscribeReturnQos;
    private long blockUpdateTime = 0L;
    private EmbeddedXmlBlaster serverThread;
    private int serverPort = 9566;
    private boolean startEmbedded = true;
    private int numReceived = 0;

    public TestTopicLifeCycle(Global glob, String testName) {
        super(testName);
        this.glob = glob;
        this.log = this.glob.getLog("test");
    }

    protected void setUp() {
        this.startEmbedded = this.glob.getProperty().get("startEmbedded", this.startEmbedded);
        if (this.startEmbedded) {
            this.glob.init(Util.getOtherServerPorts(this.serverPort));
            String[] args = new String[]{};
            this.glob.init(args);
            this.serverThread = EmbeddedXmlBlaster.startXmlBlaster(this.glob);
            this.log.info(this.ME, "XmlBlaster is ready for testing the priority dispatch plugin");
        }
        try {
            String passwd = "secret";
            this.con = this.glob.getXmlBlasterAccess();
            ConnectQos qos = new ConnectQos(this.glob);
            this.con.connect(qos, this);
        }
        catch (Exception e) {
            this.log.error(this.ME, e.toString());
            e.printStackTrace();
        }
    }

    protected void tearDown() {
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        String xmlKey = "<key oid='" + this.publishOid + "' queryType='EXACT'>\n</key>";
        String qos = "<qos></qos>";
        try {
            EraseReturnQos[] arr = this.con.erase(xmlKey, qos);
            if (arr.length != 0) {
                this.log.error(this.ME, "Erased " + arr.length + " messages instead of 0");
            }
            Assert.assertEquals("Erase", 0, arr.length);
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
        }
        this.con.disconnect(null);
        this.con = null;
        if (this.startEmbedded) {
            try {
                Thread.currentThread();
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EmbeddedXmlBlaster.stopXmlBlaster(this.serverThread);
            this.serverThread = null;
        }
        Util.resetPorts();
        this.glob = null;
        this.log = null;
    }

    public EraseReturnQos[] sendErase(boolean forceDestroy) {
        this.log.info(this.ME, "Erasing a topic forceDestroy=" + forceDestroy);
        try {
            EraseQos eq = new EraseQos(this.glob);
            eq.setForceDestroy(forceDestroy);
            EraseKey ek = new EraseKey(this.glob, this.publishOid);
            EraseReturnQos[] er = this.con.erase(ek.toXml(), eq.toXml());
            return er;
        }
        catch (XmlBlasterException e) {
            Assert.fail("Erase XmlBlasterException: " + e.getMessage());
            return null;
        }
    }

    public void sendExpiringMsg(boolean initializeTopic, long topicDestroyDelay, long msgLifeTime) {
        this.log.info(this.ME, "Sending a message initializeTopic=" + initializeTopic + " topicDestroyDelay=" + topicDestroyDelay + " msgLifeTime=" + msgLifeTime);
        try {
            PublishKey pk = new PublishKey(this.glob, this.publishOid, "text/xml", "1.0");
            PublishQos pq = new PublishQos(this.glob);
            pq.setLifeTime(msgLifeTime);
            pq.setForceDestroy(false);
            if (initializeTopic) {
                TopicProperty topicProperty = new TopicProperty(this.glob);
                topicProperty.setDestroyDelay(topicDestroyDelay);
                topicProperty.setCreateDomEntry(false);
                pq.setTopicProperty(topicProperty);
            }
            MsgUnit msgUnit = new MsgUnit(pk, this.senderContent, pq);
            PublishReturnQos publishReturnQos = this.con.publish(msgUnit);
            Assert.assertEquals("Retunred oid is invalid", this.publishOid, publishReturnQos.getKeyOid());
            this.log.info(this.ME, "Sending of '" + this.senderContent + "' done, returned oid=" + this.publishOid + " " + msgUnit.toXml());
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "publish() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("publish - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void subscribeMsg() {
        this.log.info(this.ME, "Subscribing message '" + this.publishOid + "'...");
        try {
            SubscribeKey sk = new SubscribeKey(this.glob, this.publishOid);
            SubscribeQos sq = new SubscribeQos(this.glob);
            this.subscribeReturnQos = this.con.subscribe(sk.toXml(), sq.toXml());
            this.log.info(this.ME, "Subscribing of '" + this.publishOid + "' done");
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "subscribe() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("subscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    public void unSubscribeMsg() {
        this.log.info(this.ME, "unSubscribing a volatile message ...");
        try {
            UnSubscribeKey sk = new UnSubscribeKey(this.glob, this.subscribeReturnQos.getSubscriptionId());
            UnSubscribeQos sq = new UnSubscribeQos(this.glob);
            this.con.unSubscribe(sk.toXml(), sq.toXml());
            this.log.info(this.ME, "UnSubscribing of '" + this.publishOid + "' done");
        }
        catch (XmlBlasterException e) {
            this.log.error(this.ME, "unSubscribe() XmlBlasterException: " + e.getMessage());
            Assert.assertTrue("unSubscribe - XmlBlasterException: " + e.getMessage(), false);
        }
    }

    private String getDump() {
        try {
            GetKey gk = new GetKey(this.glob, "__cmd:?dump");
            GetQos gq = new GetQos(this.glob);
            MsgUnit[] msgs = this.con.get(gk.toXml(), gq.toXml());
            Assert.assertEquals("Did not expect returned msg for get()", 1, msgs.length);
            return msgs[0].getContentStr();
        }
        catch (XmlBlasterException e) {
            Assert.fail("Didn't expect an exception in get(): " + e.getMessage());
            return "";
        }
    }

    public void testExpiry() {
        this.ME = "TestTopicLifeCycle-testExpiry";
        this.log.info(this.ME, "Entering testExpiry ...");
        this.numReceived = 0;
        long topicDestroyDelay = 6000L;
        long msgLifeTime = 3000L;
        this.sendExpiringMsg(true, topicDestroyDelay, msgLifeTime);
        this.waitOnUpdate(1000L, 0);
        Assert.assertEquals("numReceived after sending", 0, this.numReceived);
        String dump = this.getDump();
        this.log.trace(this.ME, dump);
        Assert.assertTrue("Missing topic", dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump, dump.indexOf("TestTopicLifeCycleMsg' state='ALIVE'") != -1);
        try {
            Thread.currentThread();
            Thread.sleep(3500L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        String dump2 = this.getDump();
        Assert.assertTrue("Missing topic", dump2.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump2, dump2.indexOf("TestTopicLifeCycleMsg' state='UNREFERENCED'") != -1);
        this.log.info(this.ME, "Sleeping for another 5 sec, the topic (with destroyDelay=6sec) should be dead then");
        try {
            Thread.currentThread();
            Thread.sleep(6000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        dump2 = this.getDump();
        this.log.trace(this.ME, "IS DEAD?" + dump2);
        Assert.assertTrue("Not expected a dead topic", dump2.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") == -1);
        this.log.info(this.ME, "SUCCESS testExpiry");
    }

    public void testUnreferencedAlive() {
        this.ME = "TestTopicLifeCycle-testUnreferencedAlive";
        this.log.info(this.ME, "Entering testUnreferencedAlive ...");
        this.numReceived = 0;
        long topicDestroyDelay = 6000L;
        long msgLifeTime = 3000L;
        this.sendExpiringMsg(true, topicDestroyDelay, msgLifeTime);
        this.waitOnUpdate(1000L, 0);
        Assert.assertEquals("numReceived after sending", 0, this.numReceived);
        String dump = this.getDump();
        this.log.trace(this.ME, dump);
        Assert.assertTrue("Missing topic", dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump, dump.indexOf("TestTopicLifeCycleMsg' state='ALIVE'") != -1);
        try {
            Thread.currentThread();
            Thread.sleep(3500L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        String dump2 = this.getDump();
        Assert.assertTrue("Missing topic", dump2.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump2, dump2.indexOf("TestTopicLifeCycleMsg' state='UNREFERENCED'") != -1);
        long msgLifeTime2 = 3000L;
        this.sendExpiringMsg(true, 0L, msgLifeTime2);
        this.waitOnUpdate(1000L, 0);
        Assert.assertEquals("numReceived after sending", 0, this.numReceived);
        String dump3 = this.getDump();
        this.log.trace(this.ME, dump3);
        Assert.assertTrue("Missing topic", dump3.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump3, dump3.indexOf("TestTopicLifeCycleMsg' state='ALIVE'") != -1);
        boolean forceDestroy = true;
        EraseReturnQos[] erq = this.sendErase(forceDestroy);
        Assert.assertEquals("erase failed", 1, erq.length);
        dump3 = this.getDump();
        Assert.assertTrue("Not expected a dead topic:" + dump3, dump3.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") == -1);
        this.log.info(this.ME, "SUCCESS testUnreferencedAlive");
    }

    public void testVolatile() {
        this.ME = "TestTopicLifeCycle-testVolatile";
        this.log.info(this.ME, "Entering testVolatile ...");
        this.numReceived = 0;
        long topicDestroyDelay = 0L;
        long msgLifeTime = 0L;
        this.sendExpiringMsg(true, topicDestroyDelay, msgLifeTime);
        Assert.assertTrue("Not expected a dead topic", this.getDump().indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") == -1);
        this.log.info(this.ME, "SUCCESS testVolatile");
    }

    public void testSubscribeVolatile() {
        this.ME = "TestTopicLifeCycle-testSubscribeVolatile";
        this.log.info(this.ME, "Entering testSubscribeVolatile ...");
        this.numReceived = 0;
        this.subscribeMsg();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Retrieving initial dump=" + this.getDump());
        }
        String dump = this.getDump();
        this.log.trace(this.ME, dump);
        Assert.assertTrue("Missing topic", dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump, dump.indexOf("TestTopicLifeCycleMsg' state='UNCONFIGURED'") != -1);
        long topicDestroyDelay = 0L;
        long msgLifeTime = 0L;
        this.sendExpiringMsg(true, topicDestroyDelay, msgLifeTime);
        this.waitOnUpdate(2000L, 1);
        Assert.assertEquals("numReceived after sending", 1, this.numReceived);
        String dump2 = this.getDump();
        this.log.trace(this.ME, dump2);
        Assert.assertTrue("Missing topic", dump2.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump2, dump2.indexOf("TestTopicLifeCycleMsg' state='ALIVE'") != -1);
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        this.unSubscribeMsg();
        try {
            Thread.currentThread();
            Thread.sleep(200L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        dump = this.getDump();
        Assert.assertTrue("Not expected a dead topic:" + dump, dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") == -1);
        this.log.info(this.ME, "SUCCESS testSubscribeVolatile");
    }

    public void testUnconfiguredSubscribeSubscribe() {
        this.ME = "TestTopicLifeCycle-testUnconfiguredSubscribeSubscribe";
        this.log.info(this.ME, "Entering testUnconfiguredSubscribeSubscribe ...");
        this.numReceived = 0;
        this.subscribeMsg();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Retrieving initial dump=" + this.getDump());
        }
        String dump = this.getDump();
        this.log.trace(this.ME, dump);
        Assert.assertTrue("Missing topic", dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump, dump.indexOf("TestTopicLifeCycleMsg' state='UNCONFIGURED'") != -1);
        this.subscribeMsg();
        dump = this.getDump();
        this.log.trace(this.ME, dump);
        Assert.assertTrue("Missing topic", dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump, dump.indexOf("TestTopicLifeCycleMsg' state='UNCONFIGURED'") != -1);
        boolean forceDestroy = false;
        EraseReturnQos[] erq = this.sendErase(forceDestroy);
        this.log.info(this.ME, "erase num=" + erq.length);
        Assert.assertEquals("erase failed", 1, erq.length);
        this.waitOnUpdate(1000L, 2);
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        String dump2 = this.getDump();
        Assert.assertTrue("Not expected a dead topic:" + dump2, dump2.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") == -1);
        this.log.info(this.ME, "SUCCESS testUnconfiguredSubscribeSubscribe");
    }

    public void testSoftErased() {
        this.ME = "TestTopicLifeCycle-testSoftErased";
        this.log.info(this.ME, "Entering testSoftErased ...");
        this.numReceived = 0;
        try {
            this.subscribeMsg();
            String dump = this.getDump();
            this.log.trace(this.ME, dump);
            Assert.assertTrue("Missing topic", dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
            Assert.assertTrue("Topic in wrong state:" + dump, dump.indexOf("TestTopicLifeCycleMsg' state='UNCONFIGURED'") != -1);
            long topicDestroyDelay = 400000L;
            long msgLifeTime = 400000L;
            this.blockUpdateTime = 3000L;
            this.sendExpiringMsg(true, topicDestroyDelay, msgLifeTime);
            this.waitOnUpdate(2000L, 1);
            Assert.assertEquals("numReceived after sending", 1, this.numReceived);
            String dump2 = this.getDump();
            this.log.trace(this.ME, dump2);
            Assert.assertTrue("Missing topic", dump2.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
            Assert.assertTrue("Topic in wrong state:" + dump2, dump2.indexOf("TestTopicLifeCycleMsg' state='ALIVE'") != -1);
            boolean forceDestroy = false;
            EraseReturnQos[] erq = this.sendErase(forceDestroy);
            Assert.assertEquals("erase failed", 1, erq.length);
            this.waitOnUpdate(1000L, 1);
            try {
                Thread.currentThread();
                Thread.sleep(1000L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            String dump3 = this.getDump();
            Assert.assertTrue("Missing topic", dump3.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
            Assert.assertTrue("Topic in wrong state:" + dump3, dump3.indexOf("TestTopicLifeCycleMsg' state='SOFTERASED'") != -1);
            try {
                Thread.currentThread();
                Thread.sleep(4500L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            dump = this.getDump();
            Assert.assertTrue("Not expected a dead topic:" + dump, dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") == -1);
        }
        catch (Throwable e) {
            this.log.error(this.ME, "Problem: " + e.toString());
            e.printStackTrace();
        }
        this.log.info(this.ME, "SUCCESS testSoftErased");
    }

    public void testForcedErased() {
        this.ME = "TestTopicLifeCycle-testForcedErased";
        this.log.info(this.ME, "Entering testForcedErased ...");
        this.numReceived = 0;
        this.subscribeMsg();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Retrieving initial dump=" + this.getDump());
        }
        String dump = this.getDump();
        this.log.trace(this.ME, dump);
        Assert.assertTrue("Missing topic", dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump, dump.indexOf("TestTopicLifeCycleMsg' state='UNCONFIGURED'") != -1);
        long topicDestroyDelay = 400000L;
        long msgLifeTime = 400000L;
        this.blockUpdateTime = 0L;
        this.sendExpiringMsg(true, topicDestroyDelay, msgLifeTime);
        this.waitOnUpdate(2000L, 1);
        Assert.assertEquals("numReceived after sending", 1, this.numReceived);
        String dump2 = this.getDump();
        this.log.trace(this.ME, dump2);
        Assert.assertTrue("Missing topic", dump2.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump2, dump2.indexOf("TestTopicLifeCycleMsg' state='ALIVE'") != -1);
        boolean forceDestroy = true;
        EraseReturnQos[] erq = this.sendErase(forceDestroy);
        Assert.assertEquals("erase failed", 1, erq.length);
        String dump3 = this.getDump();
        Assert.assertTrue("Not expected a dead topic:" + dump3, dump3.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") == -1);
        this.log.info(this.ME, "SUCCESS testForcedErased");
    }

    public void testUnconfiguredErased() {
        this.ME = "TestTopicLifeCycle-testUnconfiguredErased";
        this.log.info(this.ME, "Entering testUnconfiguredErased ...");
        this.numReceived = 0;
        this.subscribeMsg();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Retrieving initial dump=" + this.getDump());
        }
        String dump = this.getDump();
        this.log.trace(this.ME, dump);
        Assert.assertTrue("Missing topic", dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump, dump.indexOf("TestTopicLifeCycleMsg' state='UNCONFIGURED'") != -1);
        boolean forceDestroy = false;
        EraseReturnQos[] erq = this.sendErase(forceDestroy);
        Assert.assertEquals("erase failed", 1, erq.length);
        this.waitOnUpdate(1000L, 1);
        try {
            Thread.currentThread();
            Thread.sleep(1000L);
        }
        catch (InterruptedException i) {
            // empty catch block
        }
        String dump2 = this.getDump();
        Assert.assertTrue("Not expected a dead topic:" + dump2, dump2.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") == -1);
        this.log.info(this.ME, "SUCCESS testUnconfiguredErased");
    }

    public void testUnconfiguredUnSubscribe() {
        this.ME = "TestTopicLifeCycle-testUnconfiguredUnSubscribe";
        this.log.info(this.ME, "Entering testUnconfiguredUnSubscribe ...");
        this.numReceived = 0;
        this.subscribeMsg();
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Retrieving initial dump=" + this.getDump());
        }
        String dump = this.getDump();
        this.log.trace(this.ME, dump);
        Assert.assertTrue("Missing topic", dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") != -1);
        Assert.assertTrue("Topic in wrong state:" + dump, dump.indexOf("TestTopicLifeCycleMsg' state='UNCONFIGURED'") != -1);
        this.unSubscribeMsg();
        dump = this.getDump();
        Assert.assertTrue("Not expected a dead topic:" + dump, dump.indexOf("<uniqueKey>" + this.publishOid + "</uniqueKey>") == -1);
        this.log.info(this.ME, "SUCCESS testUnconfiguredUnSubscribe");
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(this.ME, "Receiving update of a message " + updateKey.getOid() + " " + updateQos.getState());
        ++this.numReceived;
        if (updateQos.isOk()) {
            Assert.assertEquals("Wrong oid of message returned", this.publishOid, updateKey.getOid());
            Assert.assertEquals("Message content is corrupted", new String(this.senderContent), new String(content));
        }
        if (this.blockUpdateTime > 0L) {
            this.log.info(this.ME, "Blocking the update callback for " + this.blockUpdateTime + " millis");
            try {
                Thread.currentThread();
                Thread.sleep(this.blockUpdateTime);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            this.blockUpdateTime = 0L;
            this.log.info(this.ME, "Block released, reset blockTimer");
        }
        return "";
    }

    private void waitOnUpdate(long timeout, int numWait) {
        long pollingInterval = 50L;
        if (timeout < 50L) {
            pollingInterval = timeout / 10L;
        }
        long sum = 0L;
        while (this.numReceived < numWait) {
            try {
                Thread.currentThread();
                Thread.sleep(pollingInterval);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
            if ((sum += pollingInterval) <= timeout) continue;
            this.log.warn(this.ME, "Timeout of " + timeout + " occurred");
            break;
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest(new TestTopicLifeCycle(new Global(), "testExpiry"));
        suite.addTest(new TestTopicLifeCycle(new Global(), "testUnreferencedAlive"));
        suite.addTest(new TestTopicLifeCycle(new Global(), "testVolatile"));
        suite.addTest(new TestTopicLifeCycle(new Global(), "testSubscribeVolatile"));
        suite.addTest(new TestTopicLifeCycle(new Global(), "testUnconfiguredSubscribeSubscribe"));
        suite.addTest(new TestTopicLifeCycle(new Global(), "testSoftErased"));
        suite.addTest(new TestTopicLifeCycle(new Global(), "testForcedErased"));
        suite.addTest(new TestTopicLifeCycle(new Global(), "testUnconfiguredErased"));
        suite.addTest(new TestTopicLifeCycle(new Global(), "testUnconfiguredUnSubscribe"));
        return suite;
    }

    public static void main(String[] args) {
        TestTopicLifeCycle testSub = new TestTopicLifeCycle(new Global(args), "TestTopicLifeCycle");
        testSub.setUp();
        testSub.testExpiry();
        testSub.testUnreferencedAlive();
        testSub.testVolatile();
        testSub.testSubscribeVolatile();
        testSub.testUnconfiguredSubscribeSubscribe();
        testSub.testSoftErased();
        testSub.testForcedErased();
        testSub.testUnconfiguredErased();
        testSub.testUnconfiguredUnSubscribe();
        testSub.tearDown();
    }
}

