/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.util;

import java.util.ArrayList;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.EraseKey;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.DisconnectQos;
import org.xmlBlaster.client.qos.EraseQos;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.SessionName;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.qos.TopicProperty;

public class Client
implements I_Callback {
    private String ME = "Client-";
    private Global global;
    private LogChannel log;
    private I_XmlBlasterAccess accessor;
    private String name;
    private String publishOid;
    private String subscribeOid;
    private boolean consumable;
    private ArrayList responses;
    private XmlBlasterException updateException;

    public Client(Global global, String name, ArrayList responses) {
        this.global = global.getClone(null);
        this.log = this.global.getLog("test");
        this.accessor = this.global.getXmlBlasterAccess();
        this.name = name;
        this.ME = this.ME + this.name;
        this.responses = responses;
        if (this.log.CALL) {
            this.log.call(this.ME, "constructor");
        }
    }

    public void init(String publishOid, String subscribeOid, boolean consumable, int session) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "init");
        }
        this.consumable = consumable;
        ConnectQos connectQos = new ConnectQos(this.global, this.name, "secret");
        if (session > 0) {
            SessionName sessionName = new SessionName(this.global, this.name + "/" + session);
            connectQos.setSessionName(sessionName);
        }
        this.accessor.connect(connectQos, this);
        this.publishOid = publishOid;
        this.subscribeOid = subscribeOid;
        if (this.subscribeOid != null) {
            SubscribeQos subQos = new SubscribeQos(this.global);
            this.accessor.subscribe(new SubscribeKey(this.global, this.subscribeOid), subQos);
        }
    }

    public void publish(String content) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "publish");
        }
        if (this.publishOid == null) {
            throw new XmlBlasterException(this.global, ErrorCode.USER_CLIENTCODE, this.ME, "no oid configured for publishing");
        }
        if (content == null) {
            throw new XmlBlasterException(this.global, ErrorCode.USER_CLIENTCODE, this.ME, "no content passed");
        }
        PublishQos pubQos = new PublishQos(this.global);
        TopicProperty topicProp = new TopicProperty(this.global);
        topicProp.setMsgDistributor("ConsumableQueue,1.0");
        if (this.consumable) {
            pubQos.setTopicProperty(topicProp);
        }
        MsgUnit msgUnit = new MsgUnit(new PublishKey(this.global, this.publishOid), content, pubQos);
        this.accessor.publish(msgUnit);
    }

    public void shutdown(boolean doEraseTopic) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "shutdown");
        }
        if (this.publishOid != null && doEraseTopic) {
            this.accessor.erase(new EraseKey(this.global, this.publishOid), new EraseQos(this.global));
        }
        this.accessor.disconnect(new DisconnectQos(this.global));
    }

    public void setUpdateException(XmlBlasterException ex) {
        this.updateException = ex;
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "update '" + cbSessionId + "' content='" + new String(content) + "'");
        }
        String clientProp = (String)updateQos.getData().getClientProperties().get("MsgDistributorPlugin");
        if (this.responses != null) {
            ArrayList arrayList = this.responses;
            synchronized (arrayList) {
                try {
                    this.responses.add(this.name);
                    XmlBlasterException ex = this.updateException;
                    this.updateException = null;
                    if (ex != null) {
                        throw ex;
                    }
                    Object var9_9 = null;
                    this.responses.notify();
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    this.responses.notify();
                    throw throwable;
                }
            }
        }
        XmlBlasterException ex = this.updateException;
        this.updateException = null;
        if (ex != null) {
            throw ex;
        }
        return "OK";
    }
}

