/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.test.util;

import java.io.PrintStream;
import java.util.HashSet;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.naming.NamingService;

public class JndiDumper {
    public static void scanContext(String contextName, Context context, PrintStream out) throws NamingException {
        HashSet subCtx = new HashSet();
        if (context == null) {
            context = new InitialContext();
        }
        if (contextName == null) {
            contextName = "/";
        }
        out.println(contextName);
        StringBuffer buf = new StringBuffer(contextName.length());
        int i = 0;
        while (i < contextName.length()) {
            buf.append(" ");
            ++i;
        }
        String offset = buf.toString();
        NamingEnumeration<NameClassPair> enumer = context.list("");
        while (enumer.hasMore()) {
            NameClassPair pair = enumer.next();
            Object obj = context.lookup(pair.getName());
            if (obj instanceof Context) {
                JndiDumper.scanContext(contextName + pair.getName() + "/", (Context)obj, out);
                continue;
            }
            out.println(offset + pair.getName() + " class='" + pair.getClassName() + "'");
        }
    }

    public static void main(String[] args) {
        try {
            boolean startNamingService = false;
            boolean fillNames = true;
            String factory = null;
            int i = 0;
            while (i < args.length - 1) {
                if (args[i].equalsIgnoreCase("-startNamingService")) {
                    startNamingService = new Boolean(args[++i]);
                } else if (args[i].equalsIgnoreCase("-java.naming.factory.initial")) {
                    factory = args[++i];
                } else if (args[i].equalsIgnoreCase("-fillNames")) {
                    fillNames = new Boolean(args[++i]);
                }
                ++i;
            }
            NamingService namingService = null;
            if (startNamingService) {
                namingService = new NamingService();
                namingService.start();
                System.out.println("Started an ebedded naming service.");
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            if (factory != null) {
                properties.put("java.naming.factory.initial", factory);
                System.out.println("Forcing java.naming.factory.initial=" + factory);
            } else {
                System.out.println("Using System.getProperty(java.naming.factory.initial)=" + System.getProperty("java.naming.factory.initial"));
            }
            InitialContext context = new InitialContext(properties);
            if (fillNames) {
                context.bind("first", (Object)new String("first"));
                context.bind("second", (Object)new String("first"));
                context.bind("third", (Object)new String("first"));
                context.createSubcontext("dir1");
                context.createSubcontext("dir2");
                context.createSubcontext("dir3");
                context.bind("dir1/first", (Object)new String("first"));
                context.bind("dir1/second", (Object)new String("first"));
                context.bind("dir1/third", (Object)new String("first"));
                Context ctx = (Context)context.lookup("dir2");
                ctx.bind("first", (Object)new String("first"));
                ctx.bind("second", (Object)new String("first"));
                ctx.bind("third", (Object)new String("first"));
            }
            System.out.println("================JNDI CONTENT START=============");
            JndiDumper.scanContext(null, context, System.out);
            System.out.println("================JNDI CONTENT END  =============");
            if (namingService != null) {
                namingService.stop();
            }
        }
        catch (Exception ex) {
            ex.getMessage();
            ex.printStackTrace();
        }
    }
}

