/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.lang.ref.WeakReference;
import org.xmlBlaster.util.I_Timeout;

final class Container {
    private final boolean useWeakReference;
    private Object callback;
    private Object userData;
    final long creation;

    Container(boolean useWeakReference, I_Timeout callback, Object userData) {
        this.useWeakReference = useWeakReference;
        if (this.useWeakReference) {
            this.callback = new WeakReference<I_Timeout>(callback);
            if (userData != null) {
                this.userData = new WeakReference<Object>(userData);
            }
        } else {
            this.callback = callback;
            this.userData = userData;
        }
        this.creation = System.currentTimeMillis();
    }

    I_Timeout getCallback() {
        if (this.useWeakReference) {
            WeakReference weak = (WeakReference)this.callback;
            return (I_Timeout)weak.get();
        }
        return (I_Timeout)this.callback;
    }

    Object getUserData() {
        if (this.userData == null) {
            return null;
        }
        if (this.useWeakReference) {
            WeakReference weak = (WeakReference)this.userData;
            return weak.get();
        }
        return this.userData;
    }

    void reset() {
        if (this.callback != null && this.useWeakReference) {
            ((WeakReference)this.callback).clear();
        }
        this.callback = null;
        if (this.userData != null && this.useWeakReference) {
            ((WeakReference)this.userData).clear();
        }
        this.userData = null;
    }
}

