/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.net.URLClassLoader;
import org.jutils.log.LogChannel;
import org.xmlBlaster.I_Main;
import org.xmlBlaster.Main;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.classloader.ClassLoaderFactory;

public class EmbeddedXmlBlaster {
    private static final String ME = "EmbeddedXmlBlaster";
    private Global glob;
    LogChannel log;
    private String origThreadName;
    private String[] args;
    private I_Main xmlBlasterMain;

    public static EmbeddedXmlBlaster startXmlBlaster(int serverPort) {
        Global glob = Global.instance().getClone(null);
        String[] args = new String[]{"-bootstrapPort", "" + serverPort, "-doBlocking", "false", "-xmlBlaster.isEmbedded", "true"};
        glob.init(args);
        EmbeddedXmlBlaster serverThread = new EmbeddedXmlBlaster(glob);
        serverThread.run();
        while (!serverThread.isReady()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
        }
        glob.getLog(glob.getId()).info(ME, "Server is up and ready");
        return serverThread;
    }

    public static EmbeddedXmlBlaster startXmlBlaster(String[] args) {
        return EmbeddedXmlBlaster.startXmlBlaster(args, null);
    }

    public static EmbeddedXmlBlaster startXmlBlaster(String[] args, String clusterNodeId) {
        Global glob = Global.instance().getClone(args);
        glob.setId(clusterNodeId);
        String[] args2 = new String[]{"-doBlocking", "false", "-xmlBlaster.isEmbedded", "true"};
        glob.init(args2);
        EmbeddedXmlBlaster serverThread = new EmbeddedXmlBlaster(glob);
        serverThread.run();
        while (!serverThread.isReady()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException i) {
                // empty catch block
            }
        }
        glob.getLog(glob.getId()).info(ME, "Server is up and ready.");
        return serverThread;
    }

    public static EmbeddedXmlBlaster startXmlBlaster(Global glob) {
        String[] args = new String[]{"-doBlocking", "false", "-xmlBlaster.isEmbedded", "true"};
        glob.init(args);
        EmbeddedXmlBlaster serverThread = new EmbeddedXmlBlaster(glob);
        serverThread.run();
        while (!serverThread.isReady()) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException i) {
                glob.getLog(glob.getId()).info(ME, "Server has been interrupted.");
            }
        }
        glob.getLog(glob.getId()).info(ME, "Server is up and ready.");
        return serverThread;
    }

    public static void stopXmlBlaster(EmbeddedXmlBlaster serverThread) {
        serverThread.stopServer(true);
    }

    private EmbeddedXmlBlaster(Global glob) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = glob.getLog(glob.getId());
        this.origThreadName = Thread.currentThread().getName();
    }

    private boolean isReady() {
        return this.xmlBlasterMain != null;
    }

    public I_Main getMain() {
        return this.xmlBlasterMain;
    }

    public void stopServer(boolean sync) {
        try {
            this.log.info(ME, "Stopping the xmlBlaster server instance (sync=" + sync + ") ...");
            this.xmlBlasterMain.destroy();
            if (sync) {
                while (this.xmlBlasterMain != null && !this.xmlBlasterMain.isHalted()) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException i) {
                        this.log.info(ME, "Server has been interrupted");
                    }
                }
                this.xmlBlasterMain = null;
                Thread.currentThread().setName(this.origThreadName);
                this.log.info(ME, "Server is down!");
            } else {
                this.log.info(ME, "Server is processing shutdown!");
            }
            Object var4_3 = null;
            if (this.log.TRACE) {
                this.log.trace(ME, "stopServer done");
            }
            this.glob = null;
            this.xmlBlasterMain = null;
            this.log = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.log.TRACE) {
                this.log.trace(ME, "stopServer done");
            }
            this.glob = null;
            this.xmlBlasterMain = null;
            this.log = null;
            throw throwable;
        }
    }

    public void run() {
        ClassLoaderFactory factory = this.glob.getClassLoaderFactory();
        URLClassLoader cl = null;
        try {
            cl = factory.getXmlBlasterClassLoader();
            if (this.log.TRACE) {
                this.log.trace(ME, "Get first instance of org.xmlBlaster.Main via own class loader.");
            }
            this.xmlBlasterMain = (I_Main)cl.loadClass("org.xmlBlaster.Main").newInstance();
            this.xmlBlasterMain.init(this.glob);
            this.log.info(ME, "Successfully loaded org.xmlBlaster.Main instance with specific classloader");
        }
        catch (Throwable e) {
            if (cl != null) {
                this.log.error(ME, "Problems loading org.xmlBlaster.Main with ClassLoader " + cl.getClass().getName() + ": " + e.toString() + " -> using default classloader");
            } else {
                this.log.error(ME, "Problems loading org.xmlBlaster.Main (classloader = 'null' ???): " + e.toString() + " -> using default classloader");
            }
            this.xmlBlasterMain = new Main(this.glob);
            this.log.info(ME, "Successfully loaded org.xmlBlaster.Main instance with default classloader");
        }
    }

    public int changeRunlevel(int newRunlevel, boolean force) throws XmlBlasterException {
        int numErrors = 1;
        if (newRunlevel == 0 || newRunlevel == 3 || newRunlevel == 6 || newRunlevel == 9) {
            numErrors = this.getMain().getGlobal().getRunlevelManager().changeRunlevel(newRunlevel, force);
        }
        return numErrors;
    }

    public static void main(String[] args) {
        EmbeddedXmlBlaster xmlBlaster = EmbeddedXmlBlaster.startXmlBlaster(args);
        EmbeddedXmlBlaster.stopXmlBlaster(xmlBlaster);
    }
}

