/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.xmlBlaster.util.Global;

public class EncodableData
implements Serializable,
Cloneable {
    protected String ME = "EncodableData";
    private final transient Global glob;
    private final String name;
    private String type;
    private String value;
    private String encoding;
    public static final boolean isChunked = false;
    protected String tagName;

    public EncodableData(Global glob, String tagName, String name, String type, String encoding) {
        this.glob = glob == null ? Global.instance() : glob;
        this.tagName = tagName;
        this.name = name;
        this.type = type;
        this.encoding = encoding;
    }

    public EncodableData(Global glob, String tagName, String name, String type, String encoding, String value) {
        this.glob = glob == null ? Global.instance() : glob;
        this.name = name;
        this.tagName = tagName;
        this.type = type;
        this.encoding = encoding;
        this.setValue(value);
    }

    public EncodableData(Global glob, String tagName, String name, byte[] value) {
        this.glob = glob == null ? Global.instance() : glob;
        this.name = name;
        this.tagName = tagName;
        this.setValue(value);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public boolean isBase64() {
        return "base64".equalsIgnoreCase(this.encoding);
    }

    public String getValueRaw() {
        return this.value;
    }

    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        if ("base64".equalsIgnoreCase(this.encoding)) {
            byte[] content = Base64.decodeBase64((byte[])this.value.getBytes());
            return new String(content);
        }
        return this.value;
    }

    public byte[] getBlobValue() {
        if (this.value == null) {
            return null;
        }
        if ("base64".equalsIgnoreCase(this.encoding)) {
            byte[] content = Base64.decodeBase64((byte[])this.value.getBytes());
            return content;
        }
        return this.value.getBytes();
    }

    public int getIntValue() {
        return new Integer(this.getStringValue());
    }

    public boolean getBooleanValue() {
        return new Boolean(this.getStringValue());
    }

    public double getDoubleValue() {
        return new Double(this.getStringValue());
    }

    public float getFloatValue() {
        return new Float(this.getStringValue()).floatValue();
    }

    public byte getByteValue() {
        return new Byte(this.getStringValue());
    }

    public long getLongValue() {
        return new Long(this.getStringValue());
    }

    public short getShortValue() {
        return new Short(this.getStringValue());
    }

    public Object getObjectValue() {
        return EncodableData.convertPropertyObject(this.type, this.getStringValue());
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setValue(String value) {
        this.setValue(value, this.encoding);
    }

    public void setValue(byte[] value) {
        this.type = "byte[]";
        this.encoding = "base64";
        byte[] content = Base64.encodeBase64((byte[])value, (boolean)false);
        this.value = new String(content);
    }

    public void setValueRaw(String value) {
        this.value = value;
    }

    public void setValue(String value, String encoding) {
        this.encoding = encoding;
        if (value == null) {
            this.value = null;
            return;
        }
        if ("base64".equalsIgnoreCase(this.encoding)) {
            this.encoding = "base64";
            byte[] content = Base64.encodeBase64((byte[])value.getBytes(), (boolean)false);
            this.value = new String(content);
        } else {
            this.value = value;
            this.getValidatedValueForXml();
        }
    }

    private String getValidatedValueForXml() {
        if (this.value == null) {
            return "";
        }
        if (!("base64".equalsIgnoreCase(this.encoding) || this.value.indexOf("<") == -1 && this.value.indexOf("]]>") == -1)) {
            this.setValue(this.value, "base64");
        }
        return this.value;
    }

    public static final String getPropertyType(Object val) {
        if (val == null) {
            return null;
        }
        if (val instanceof String) {
            return null;
        }
        if (val instanceof Boolean) {
            return "boolean";
        }
        if (val instanceof Byte) {
            return "byte";
        }
        if (val instanceof Double) {
            return "double";
        }
        if (val instanceof Float) {
            return "float";
        }
        if (val instanceof Integer) {
            return "int";
        }
        if (val instanceof Long) {
            return "long";
        }
        if (val instanceof Short) {
            return "short";
        }
        if (val instanceof byte[]) {
            return "byte[]";
        }
        return null;
    }

    public static final Object convertPropertyObject(String type, String val) {
        if (type == null) {
            return val;
        }
        if (val == null) {
            return null;
        }
        if ("boolean".equalsIgnoreCase(type)) {
            return new Boolean(val);
        }
        if ("byte".equalsIgnoreCase(type)) {
            return new Byte(val);
        }
        if ("double".equalsIgnoreCase(type)) {
            return new Double(val);
        }
        if ("float".equalsIgnoreCase(type)) {
            return new Float(val);
        }
        if ("int".equalsIgnoreCase(type)) {
            return new Integer(val);
        }
        if ("short".equalsIgnoreCase(type)) {
            return new Short(val);
        }
        if ("long".equalsIgnoreCase(type)) {
            return new Long(val);
        }
        if ("byte[]".equalsIgnoreCase(type)) {
            return val.getBytes();
        }
        return null;
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        String val;
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<").append(this.tagName);
        if (this.getName() != null) {
            sb.append(" name='").append(this.getName()).append("'");
        }
        if (this.getType() != null) {
            sb.append(" type='").append(this.getType()).append("'");
        }
        if (this.getEncoding() != null) {
            sb.append(" encoding='").append(this.getEncoding()).append("'");
        }
        if ((val = this.getValueRaw()) == null) {
            sb.append("/>");
        } else {
            sb.append(">");
            sb.append(val);
            sb.append("</").append(this.tagName).append(">");
        }
        return sb.toString();
    }
}

