/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_ExecuteListener;

public class Execute {
    private static final String ME = "Execute";
    private Global glob;
    private LogChannel log;
    private Process process;
    private String[] commandArr;
    private String[] envArr;
    private String errorText;
    private I_ExecuteListener outListener;
    private int BUFFERED_READER_SIZE = 200000;
    private OutputThread stdoutThread;
    private StringBuffer stdout = new StringBuffer();
    private OutputThread stderrThread;
    private StringBuffer stderr = new StringBuffer();
    private int exitValue;

    public Execute(Global glob, String[] commandArr, String[] envArr) {
        this.glob = glob;
        this.log = glob.getLog("core");
        this.commandArr = commandArr;
        this.envArr = envArr;
        if (this.commandArr == null || this.commandArr.length < 1) {
            throw new IllegalArgumentException("Please provide the process to start");
        }
    }

    public void setExecuteListener(I_ExecuteListener l) {
        this.outListener = l;
    }

    public void run() {
        if (this.log.TRACE) {
            this.log.trace(ME, "Entering Method Execute.run()");
        }
        this.errorText = null;
        try {
            try {
                Runtime runtime = Runtime.getRuntime();
                this.process = runtime.exec(this.commandArr, this.envArr);
                InputStream istr = this.process.getInputStream();
                BufferedReader ibr = new BufferedReader(new InputStreamReader(istr), this.BUFFERED_READER_SIZE);
                this.stdoutThread = new OutputThread(this, ibr, this.stdout);
                this.stdoutThread.start();
                InputStream estr = this.process.getErrorStream();
                BufferedReader ebr = new BufferedReader(new InputStreamReader(estr), this.BUFFERED_READER_SIZE);
                this.stderrThread = new OutputThread(this, ebr, this.stderr);
                this.stderrThread.start();
                while (!this.stdoutThread.isReady() || !this.stderrThread.isReady()) {
                }
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException e) {
                    this.log.warn(ME, "Process [" + this.commandArr[0] + "] was interrupted");
                }
                this.exitValue = this.process.exitValue();
                if (this.log.TRACE) {
                    this.log.trace(ME, "Process [" + this.commandArr[0] + "] finished its work, exit=" + this.exitValue + ", good bye");
                }
                this.stdoutThread.stopIt();
                this.stderrThread.stopIt();
                this.process.destroy();
                this.stdoutThread.join();
                this.stderrThread.join();
                this.process = null;
                Object var8_8 = null;
                if (this.stdoutThread != null) {
                    this.stdoutThread.stopIt();
                    this.stdoutThread = null;
                }
                if (this.stderrThread != null) {
                    this.stderrThread.stopIt();
                    this.stderrThread = null;
                }
                return;
            }
            catch (Exception e) {
                this.errorText = "Process [" + this.commandArr[0] + "] could not be started: " + e.toString();
                this.log.error(ME, this.errorText);
                Object var8_9 = null;
                if (this.stdoutThread != null) {
                    this.stdoutThread.stopIt();
                    this.stdoutThread = null;
                }
                if (this.stderrThread != null) {
                    this.stderrThread.stopIt();
                    this.stderrThread = null;
                }
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            if (this.stdoutThread != null) {
                this.stdoutThread.stopIt();
                this.stdoutThread = null;
            }
            if (this.stderrThread != null) {
                this.stderrThread.stopIt();
                this.stderrThread = null;
            }
            throw throwable;
        }
    }

    public void stop() {
        try {
            if (this.process != null) {
                this.process.destroy();
            }
        }
        catch (Exception e) {
            this.log.error(ME, "Process kill failed: " + e.toString());
        }
        if (this.stdoutThread != null) {
            this.stdoutThread.stopIt();
            this.stdoutThread = null;
        }
        if (this.stderrThread != null) {
            this.stderrThread.stopIt();
            this.stderrThread = null;
        }
    }

    public String getStdout() {
        return this.stdout.toString();
    }

    public String getStderr() {
        return this.stderr.toString();
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getErrorText() {
        return this.errorText;
    }

    public static void main(String[] args) {
        String[] commandArr = new String[]{args[0]};
        String[] envArr = new String[]{};
        String[] ar = new String[]{"-trace", "true"};
        Global glob = new Global(ar);
        Execute execute = new Execute(glob, commandArr, envArr);
        execute.run();
        System.out.println("Stdout of " + args[0] + " is:\n" + execute.getStdout());
        System.out.println("Stderr of " + args[0] + " is:\n" + execute.getStderr());
        System.out.println("Exit   of " + args[0] + " is: " + execute.getExitValue());
    }

    private class OutputThread
    extends Thread {
        private final String ME = "OutputThread";
        private Execute boss;
        private BufferedReader br;
        private StringBuffer result;
        private boolean isReady = false;
        private boolean stopIt = false;

        OutputThread(Execute boss, BufferedReader br, StringBuffer result) {
            this.boss = boss;
            this.br = br;
            this.result = result;
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            if (((Execute)Execute.this).log.TRACE) {
                Execute.this.log.trace("OutputThread", "Start reading lines from process ...");
            }
            try {
                this.isReady = true;
                block2: do {
                    String str;
                    if (!this.br.ready()) continue;
                    while ((str = this.br.readLine()) != null) {
                        void var1_1;
                        this.result.append((String)var1_1).append("\n");
                        if (Execute.this.outListener != null) {
                            if (this == Execute.this.stdoutThread) {
                                Execute.this.outListener.stdout((String)var1_1);
                            } else {
                                Execute.this.outListener.stderr((String)var1_1);
                            }
                        }
                        if (!this.br.ready()) continue block2;
                    }
                } while (!this.stopIt);
                this.br.close();
                if (((Execute)Execute.this).log.TRACE) {
                    Execute.this.log.trace("OutputThread", "End reading lines from process.");
                }
            }
            catch (IOException e) {
                Execute.this.log.error("OutputThread", "Could not read process output: " + e.toString());
            }
        }

        void stopIt() {
            this.stopIt = true;
        }

        boolean isReady() {
            return this.isReady;
        }
    }
}

