/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.Vector;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class FileLocator {
    private static final String ME = "FileLocator";
    private Global glob;
    private LogChannel log;

    public FileLocator(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("core");
    }

    public final String findFile(String[] path, String filename) throws XmlBlasterException {
        File file = new File(filename);
        if (file.isAbsolute()) {
            this.log.warn(ME, "the filename '" + filename + "' is absolute, I will ignore the given search path '" + path + "'");
            if (file.exists()) {
                if (file.isDirectory()) {
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, "FileLocator.findFile", "the given name '" + file.getAbsolutePath() + "' is a directory");
                }
                if (!file.canRead()) {
                    throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, "FileLocator.findFile", "don't have the rights to read the file '" + file.getAbsolutePath() + "'");
                }
                return file.getAbsolutePath();
            }
        }
        XmlBlasterException ex = null;
        int i = 0;
        while (i < path.length) {
            File tmp = new File(path[i], filename);
            if (tmp.exists()) {
                if (tmp.isDirectory()) {
                    ex = new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, "FileLocator.findFile", "the given name '" + tmp.getAbsolutePath() + "' is a directory");
                } else if (!tmp.canRead()) {
                    ex = new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, "FileLocator.findFile", "don't have the rights to read the file '" + tmp.getAbsolutePath() + "'");
                } else {
                    return tmp.getAbsolutePath();
                }
            }
            ++i;
        }
        if (ex != null) {
            throw ex;
        }
        return null;
    }

    public final String[] parsePath(String pathAsString, String separator) {
        if (pathAsString == null || separator == null) {
            return null;
        }
        if (pathAsString.trim().length() < 1) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(pathAsString, separator);
        int size = tokenizer.countTokens();
        String[] ret = new String[size];
        int i = 0;
        while (i < ret.length) {
            ret[i] = tokenizer.nextToken();
            ++i;
        }
        return ret;
    }

    public final String findFile(String path, String separator, String filename) throws XmlBlasterException {
        String[] parsedPath = this.parsePath(path, separator);
        return this.findFile(parsedPath, filename);
    }

    public final String findFile(String path, String filename) throws XmlBlasterException {
        return this.findFile(path, ":", filename);
    }

    public final String[] createXmlBlasterSearchPath() {
        String javaHome;
        String javaExtDirs;
        String home;
        Vector<String> vec = new Vector<String>();
        vec.add(".");
        String projectHome = System.getProperty("PROJECT_HOME");
        if (projectHome != null && projectHome.length() > 0) {
            vec.add(projectHome);
        }
        if ((home = System.getProperty("user.home")) != null && home.length() > 0) {
            vec.add(home);
        }
        if ((javaExtDirs = System.getProperty("java.ext.dirs")) != null && javaExtDirs.length() > 0) {
            vec.add(javaExtDirs);
        }
        if ((javaHome = System.getProperty("java.home")) != null && javaHome.length() > 0) {
            vec.add(javaHome);
        }
        String[] ret = vec.toArray(new String[vec.size()]);
        return ret;
    }

    private final URL findFileInSinglePath(String path, String filename) {
        if (this.log.CALL) {
            this.log.call(ME, "findFileInSinglePath with path='" + path + "' and filename='" + filename + "'");
        }
        File file = null;
        file = path != null ? new File(path, filename) : new File(filename);
        if (file.exists()) {
            if (file.isDirectory()) {
                this.log.warn(ME, "findFileInSinglePath: the given name '" + file.getAbsolutePath() + "' is not a file, it is a directory");
                return null;
            }
            if (!file.canRead()) {
                this.log.warn(ME, "findFileInSinglePath: don't have the rights to read the file '" + file.getAbsolutePath() + "'");
                return null;
            }
            try {
                return file.toURL();
            }
            catch (MalformedURLException ex) {
                this.log.warn(ME, "findFileInSinglePath: path='" + path + "', filename='" + filename + " exception: " + ex.getMessage());
                return null;
            }
        }
        return null;
    }

    public final URL findFileInXmlBlasterSearchPath(String propertyName, String filename) {
        String path = null;
        URL ret = null;
        path = this.glob.getProperty().get(propertyName, (String)null);
        if (path != null) {
            if (this.log.TRACE) {
                this.log.trace(ME, "findFileInXmlBlasterSearchPath: the path: '" + path + "' and the filename to search: '" + filename + "'");
            }
            if ((ret = this.findFileInSinglePath(null, path)) != null) {
                return ret;
            }
        }
        if ((ret = this.findFileInSinglePath(path = System.getProperty("user.dir", "."), filename)) != null) {
            return ret;
        }
        ret = this.findFileInSinglePath(null, filename);
        if (ret != null) {
            return ret;
        }
        path = this.glob.getProperty().get("PROJECT_HOME", (String)null);
        if (path != null && (ret = this.findFileInSinglePath(path, filename)) != null) {
            return ret;
        }
        path = System.getProperty("user.home", null);
        if (path != null && (ret = this.findFileInSinglePath(path, filename)) != null) {
            return ret;
        }
        try {
            URL url = this.glob.getClassLoaderFactory().getXmlBlasterClassLoader().getResource(filename);
            if (url != null) {
                return url;
            }
        }
        catch (XmlBlasterException ex) {
            this.log.warn(ME, "findFileInXmlBlasterSearchPath: " + ex.getMessage());
        }
        path = System.getProperty("java.ext.dirs", null);
        if (path != null && (ret = this.findFileInSinglePath(path, filename)) != null) {
            return ret;
        }
        path = System.getProperty("java.home", null);
        if (path != null) {
            return this.findFileInSinglePath(path, filename);
        }
        return null;
    }

    public static void main(String[] args) {
        Global glob = Global.instance();
        glob.init(args);
        LogChannel log = glob.getLog("test");
        FileLocator locator = new FileLocator(glob);
        try {
            String ret = locator.findFileInXmlBlasterSearchPath("pluginsFile", "xmlBlasterPlugins.xml").getFile();
            if (ret != null) {
                System.out.println("The file 'xmlBlasterPlugins.xml' has been found");
                System.out.println("Its complete path is: '" + ret + "'");
            } else {
                System.out.println("The file 'xmlBlasterPlugins.xml' has not been found");
            }
        }
        catch (Exception ex) {
            System.err.println("Error occured: " + ex.toString());
        }
    }
}

