/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.applet.Applet;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.jutils.JUtilsException;
import org.jutils.init.Property;
import org.jutils.log.LogChannel;
import org.jutils.log.LogDeviceConsole;
import org.jutils.log.LogDeviceFile;
import org.jutils.log.LogableDevice;
import org.jutils.runtime.Sleeper;
import org.jutils.text.StringHelper;
import org.xmlBlaster.authentication.HttpIORServer;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.PluginLoader;
import org.xmlBlaster.client.XmlBlasterAccess;
import org.xmlBlaster.client.dispatch.ClientDispatchConnectionsHandler;
import org.xmlBlaster.client.protocol.CbServerPluginManager;
import org.xmlBlaster.client.protocol.ProtocolPluginManager;
import org.xmlBlaster.client.queuemsg.ClientEntryFactory;
import org.xmlBlaster.protocol.I_CallbackDriver;
import org.xmlBlaster.util.JAXPFactory;
import org.xmlBlaster.util.Timeout;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlProcessor;
import org.xmlBlaster.util.classloader.ClassLoaderFactory;
import org.xmlBlaster.util.classloader.StandaloneClassLoaderFactory;
import org.xmlBlaster.util.cluster.NodeId;
import org.xmlBlaster.util.context.ContextNode;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.dispatch.DispatchConnectionsHandler;
import org.xmlBlaster.util.dispatch.DispatchManager;
import org.xmlBlaster.util.dispatch.DispatchWorkerPool;
import org.xmlBlaster.util.dispatch.plugins.DispatchPluginManager;
import org.xmlBlaster.util.key.I_MsgKeyFactory;
import org.xmlBlaster.util.key.I_QueryKeyFactory;
import org.xmlBlaster.util.key.MsgKeySaxFactory;
import org.xmlBlaster.util.key.QueryKeySaxFactory;
import org.xmlBlaster.util.log.I_LogDeviceFactory;
import org.xmlBlaster.util.log.LogDevicePluginManager;
import org.xmlBlaster.util.plugin.PluginManagerBase;
import org.xmlBlaster.util.plugin.PluginRegistry;
import org.xmlBlaster.util.qos.ConnectQosSaxFactory;
import org.xmlBlaster.util.qos.DisconnectQosSaxFactory;
import org.xmlBlaster.util.qos.I_ConnectQosFactory;
import org.xmlBlaster.util.qos.I_DisconnectQosFactory;
import org.xmlBlaster.util.qos.I_MsgQosFactory;
import org.xmlBlaster.util.qos.I_QueryQosFactory;
import org.xmlBlaster.util.qos.I_StatusQosFactory;
import org.xmlBlaster.util.qos.MsgQosSaxFactory;
import org.xmlBlaster.util.qos.QueryQosSaxFactory;
import org.xmlBlaster.util.qos.StatusQosQuickParseFactory;
import org.xmlBlaster.util.qos.address.Address;
import org.xmlBlaster.util.queue.I_EntryFactory;
import org.xmlBlaster.util.queue.QueuePluginManager;
import org.xmlBlaster.util.recorder.RecorderPluginManager;

public class Global
implements Cloneable {
    private static Global firstInstance;
    private String versionDefault = "0.903";
    private String version = "0.903";
    private String buildTimestamp = "05/12/2004 11:58 PM";
    private String buildJavaVendor = "IBM Corporation";
    private String buildJavaVersion = "1.3.1";
    protected String ME = "Global";
    protected String ip_addr = null;
    protected String id = "";
    protected Property property = null;
    protected String errorText = null;
    protected ContextNode contextNode;
    protected String cbHostname = null;
    protected String addressNormalized = null;
    protected final LogChannel log;
    private ClassLoaderFactory classLoaderFactory = null;
    protected Map nativeCallbackDriverMap;
    protected Map objectMap;
    protected Address bootstrapAddress;
    protected PluginLoader clientSecurityLoader;
    protected QueuePluginManager queuePluginManager;
    protected DispatchPluginManager dispatchPluginManager;
    protected ProtocolPluginManager protocolPluginManager;
    protected CbServerPluginManager cbServerPluginManager;
    protected RecorderPluginManager recorderPluginManager;
    private HttpIORServer httpServer;
    protected XmlProcessor xmlProcessor;
    protected Hashtable logChannels = new Hashtable();
    protected LogChannel logDefault;
    protected SAXParserFactory saxFactory;
    protected DocumentBuilderFactory docBuilderFactory;
    protected TransformerFactory transformerFactory;
    protected I_MsgKeyFactory msgKeyFactory;
    protected I_QueryKeyFactory queryKeyFactory;
    protected I_ConnectQosFactory connectQosFactory;
    protected I_DisconnectQosFactory disconnectQosFactory;
    protected I_MsgQosFactory msgQosFactory;
    protected I_QueryQosFactory queryQosFactory;
    protected I_StatusQosFactory statusQosFactory;
    protected Timeout pingTimer;
    protected Timeout burstModeTimer;
    protected Timeout messageTimer;
    protected Timeout jdbcConnectionPoolTimer;
    protected DispatchWorkerPool dispatchWorkerPool;
    protected LogDevicePluginManager logDevicePluginManager = null;
    private boolean creatingLogInstance = false;
    protected static int counter;
    private PluginManagerBase pluginManager;
    private PluginRegistry pluginRegistry;
    protected I_XmlBlasterAccess xmlBlasterAccess;
    protected boolean isDoingShutdown = false;
    protected boolean wipeOutDB = false;
    protected I_EntryFactory entryFactory;
    static /* synthetic */ Class class$org$xmlBlaster$util$Global;
    static /* synthetic */ Class class$org$jutils$init$Property;
    static /* synthetic */ Class class$org$xmlBlaster$client$PluginLoader;
    static /* synthetic */ Class class$org$xmlBlaster$util$recorder$RecorderPluginManager;
    static /* synthetic */ Class class$org$xmlBlaster$util$queue$QueuePluginManager;
    static /* synthetic */ Class class$org$xmlBlaster$util$dispatch$plugins$DispatchPluginManager;
    static /* synthetic */ Class class$org$xmlBlaster$util$XmlProcessor;
    static /* synthetic */ Class class$org$xmlBlaster$util$classloader$ClassLoaderFactory;

    public Global() {
        this(null, true, false);
    }

    public Global(Properties props) {
        this(Property.propsToArgs(props));
    }

    public Global(String[] args) {
        this(args, true, false);
    }

    public Global(String[] args, boolean loadPropFile, boolean checkInstance) {
        ++counter;
        if (checkInstance && firstInstance != null) {
            System.out.println("######Global args constructor invoked again, try Global.instance()");
            Thread.dumpStack();
        }
        Class clazz = class$org$xmlBlaster$util$Global == null ? (class$org$xmlBlaster$util$Global = Global.class$("org.xmlBlaster.util.Global")) : class$org$xmlBlaster$util$Global;
        synchronized (clazz) {
            if (firstInstance == null) {
                firstInstance = this;
            }
        }
        this.initProps(args, loadPropFile);
        this.initId();
        this.logDevicePluginManager = new LogDevicePluginManager(this);
        this.log = this.logDefault = new LogChannel(null, this.getProperty());
        this.initLog(this.logDefault);
        this.nativeCallbackDriverMap = Collections.synchronizedMap(new HashMap());
        this.objectMap = Collections.synchronizedMap(new HashMap());
    }

    public String getVersion() {
        if (this.version.indexOf("@") == -1) {
            return this.version;
        }
        return this.versionDefault;
    }

    public String getBuildTimestamp() {
        return this.buildTimestamp;
    }

    public String getBuildJavaVendor() {
        return this.buildJavaVendor;
    }

    public String getBuildJavaVersion() {
        return this.buildJavaVersion;
    }

    public static int waitOnKeyboardHit(String str) {
        if (str != null) {
            System.out.println(str);
        }
        int ret = 0;
        try {
            ret = System.in.read();
            int num = System.in.available();
            int i = 0;
            while (i < num) {
                System.in.read();
                ++i;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return ret;
    }

    protected void initId() {
        this.id = this.getProperty().get("server.node.id", (String)null);
        if (this.id == null) {
            this.id = this.getProperty().get("cluster.node.id", "xmlBlaster");
        }
        if (this.id == null && this.getBootstrapAddress().getBootstrapPort() > 0) {
            this.id = this.getBootstrapAddress().getBootstrapHostname() + ":" + this.getBootstrapAddress().getBootstrapPort();
        }
    }

    protected void shallowCopy(Global utilGlob) {
        this.ip_addr = utilGlob.ip_addr;
        this.id = utilGlob.id;
        this.property = utilGlob.property;
        this.errorText = utilGlob.errorText;
        this.cbHostname = utilGlob.cbHostname;
        this.nativeCallbackDriverMap = utilGlob.nativeCallbackDriverMap;
        this.objectMap = utilGlob.objectMap;
        this.bootstrapAddress = utilGlob.bootstrapAddress;
        this.clientSecurityLoader = utilGlob.clientSecurityLoader;
        this.recorderPluginManager = utilGlob.recorderPluginManager;
        this.logChannels = utilGlob.logChannels;
        this.logDefault = utilGlob.logDefault;
        this.logDevicePluginManager = utilGlob.logDevicePluginManager;
    }

    private void initLog(LogChannel lc) {
        String key = lc.getChannelKey();
        boolean useOld = true;
        if (this.logDevicePluginManager != null) {
            Global global = this;
            synchronized (global) {
                if (this.creatingLogInstance) {
                    lc.addLogDevice(new LogDeviceConsole(lc));
                    return;
                }
                this.creatingLogInstance = true;
                String[] devices = null;
                if (key != null) {
                    devices = this.getProperty().get("logDevice[" + key + "]", new String[0], ",");
                }
                if (devices == null || devices.length == 0) {
                    devices = this.getProperty().get("logDevice", new String[0], ",");
                }
                if (devices != null && devices.length > 0) {
                    int i = 0;
                    while (i < devices.length) {
                        block21: {
                            block20: {
                                try {
                                    I_LogDeviceFactory fac = this.logDevicePluginManager.getFactory(devices[i], "1.0");
                                    LogableDevice dev = fac.getLogDevice(lc);
                                    if (this.log != null && this.log.TRACE) {
                                        this.log.trace(this.ME, "Setting logDevice " + key + "[" + devices[i] + "]=" + (dev != null && dev.getClass() != null ? dev.getClass().getName() : "null"));
                                    }
                                    if (dev == null) break block20;
                                    lc.addLogDevice(dev);
                                }
                                catch (XmlBlasterException ex) {
                                    if (this.log != null) {
                                        this.log.error(this.ME, "initLog(): Error in getting LogDeviceFactory for " + key);
                                    } else {
                                        System.out.println(this.ME + ".initLog(): Error in getting LogDeviceFactory for " + key);
                                    }
                                    break block21;
                                }
                            }
                            useOld = false;
                        }
                        ++i;
                    }
                }
                this.creatingLogInstance = false;
            }
        }
        if (useOld) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using old logging behaviour for '" + key + "'");
            }
            boolean bVal = this.getProperty().get("logConsole", true);
            if (key != null) {
                this.getProperty().get("logConsole[" + key + "]", bVal);
            }
            if (bVal) {
                LogDeviceConsole ldc = new LogDeviceConsole(lc);
                lc.addLogDevice(ldc);
            }
            String strFilename = this.getProperty().get("logFile", (String)null);
            if (key != null) {
                strFilename = this.getProperty().get("logFile[" + key + "]", strFilename);
            }
            if (strFilename != null) {
                LogDeviceFile ldf = new LogDeviceFile(lc, strFilename);
                lc.addLogDevice(ldf);
                System.out.println("Global: Redirected logging output to file '" + strFilename + "'");
            }
        }
    }

    public boolean addLogChannel(LogChannel log) {
        if (log == null) {
            Thread.dumpStack();
            throw new IllegalArgumentException("Global.addLogChannel(null)");
        }
        String key = log.getChannelKey();
        if (key != null && key.length() > 0) {
            this.initLog(log);
            this.logChannels.put(key, log);
            if (log.TRACE) {
                log.trace(this.ME, "New log channel '" + key + "' ready: " + LogChannel.bitToLogLevel(log.getLogLevel()));
            }
            return true;
        }
        return false;
    }

    public LogChannel getLog(String key) {
        if (key == null) {
            return this.logDefault;
        }
        Object obj = this.logChannels.get(key);
        if (obj != null) {
            return (LogChannel)obj;
        }
        LogChannel lc = new LogChannel(key, this.getProperty());
        this.addLogChannel(lc);
        return lc;
    }

    public boolean changeLogLevel(String logLevel, String bool) throws XmlBlasterException {
        try {
            boolean b = Property.toBool(bool);
            this.changeLogLevel(logLevel, b);
            return b;
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(this, ErrorCode.INTERNAL_UNKNOWN, this.ME, "changeLogLevel failed", e);
        }
    }

    public void changeLogLevel(String logLevel, boolean value) throws XmlBlasterException {
        if (logLevel == null || logLevel.length() < 1) {
            return;
        }
        try {
            int start = logLevel.indexOf("[");
            if (start != -1) {
                int end = logLevel.indexOf("]");
                if (start < 1 || end == -1 || end <= start + 1) {
                    throw new XmlBlasterException(this, ErrorCode.USER_CONFIGURATION, this.ME, "Illegal loglevel syntax '" + logLevel + "'");
                }
                String key = logLevel.substring(start + 1, end);
                Object obj = this.logChannels.get(key);
                if (obj == null) {
                    throw new XmlBlasterException(this, ErrorCode.USER_CONFIGURATION, this.ME, "LogChannel '" + key + "' is not known");
                }
                LogChannel log = (LogChannel)obj;
                if (value) {
                    log.addLogLevelChecked(logLevel.substring(0, start));
                } else {
                    log.removeLogLevelChecked(logLevel.substring(0, start));
                }
                return;
            }
            if (value) {
                this.logDefault.addLogLevelChecked(logLevel);
            } else {
                this.logDefault.removeLogLevelChecked(logLevel);
            }
            Enumeration e = this.logChannels.elements();
            while (e.hasMoreElements()) {
                LogChannel log = (LogChannel)e.nextElement();
                if (value) {
                    log.info(this.ME, "Setting logLevel '" + logLevel + "' for '" + log.getChannelKey() + "' to true");
                    log.addLogLevelChecked(logLevel);
                    continue;
                }
                log.info(this.ME, "Removing logLevel '" + logLevel + "' for '" + log.getChannelKey() + "'");
                log.removeLogLevelChecked(logLevel);
            }
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(this, ErrorCode.INTERNAL_UNKNOWN, this.ME, "", e);
        }
    }

    public boolean getLogLevel(String logLevel) throws XmlBlasterException {
        if (logLevel == null || logLevel.length() < 1) {
            throw new XmlBlasterException(this, ErrorCode.USER_CONFIGURATION, this.ME, "Illegal loglevel syntax '" + logLevel + "'");
        }
        try {
            int start = logLevel.indexOf("[");
            if (start != -1) {
                int end = logLevel.indexOf("]");
                if (start < 1 || end == -1 || end <= start + 1) {
                    throw new XmlBlasterException(this, ErrorCode.USER_CONFIGURATION, this.ME, "Illegal loglevel syntax '" + logLevel + "'");
                }
                String key = logLevel.substring(start + 1, end);
                Object obj = this.logChannels.get(key);
                if (obj == null) {
                    throw new XmlBlasterException(this, ErrorCode.USER_CONFIGURATION, this.ME, "LogChannel '" + key + "' is not known");
                }
                LogChannel log = (LogChannel)obj;
                return log.isLoglevelEnabled(logLevel.substring(0, start));
            }
            return this.logDefault.isLoglevelEnabled(logLevel);
        }
        catch (JUtilsException e) {
            throw new XmlBlasterException(this, ErrorCode.INTERNAL_UNKNOWN, this.ME, "", e);
        }
    }

    private int initProps(String[] args) {
        return this.initProps(args, true);
    }

    private int initProps(String[] args, boolean loadPropFile) {
        if (this.property == null) {
            Class clazz = class$org$jutils$init$Property == null ? (class$org$jutils$init$Property = Global.class$("org.jutils.init.Property")) : class$org$jutils$init$Property;
            synchronized (clazz) {
                if (this.property == null) {
                    try {
                        this.property = loadPropFile ? new Property("xmlBlaster.properties", true, args, true) : new Property(null, true, args, true);
                    }
                    catch (JUtilsException e) {
                        this.errorText = this.ME + ": Error in xmlBlaster.properties: " + e.toString();
                        System.err.println(this.errorText);
                        try {
                            this.property = new Property(null, true, args, true);
                        }
                        catch (JUtilsException e2) {
                            this.errorText = this.ME + " ERROR: " + e2.toString();
                            System.err.println(this.errorText);
                            try {
                                this.property = new Property(null, true, new String[0], true);
                            }
                            catch (JUtilsException e3) {
                                this.errorText = this.ME + " ERROR: " + e3.toString();
                                System.err.println(this.errorText);
                            }
                        }
                        int n = -1;
                        return n;
                    }
                }
            }
        }
        return 0;
    }

    public int init(Properties props) {
        return this.init(Property.propsToArgs(props));
    }

    public int init(String[] args) {
        String[] stringArray = args = args == null ? new String[]{} : args;
        if (args.length > 0) {
            this.bootstrapAddress = null;
        }
        try {
            this.property.addArgs2Props(args);
            this.initId();
            this.logDefault.initialize(this.property);
            return this.property.wantsHelp() ? 1 : 0;
        }
        catch (JUtilsException e) {
            this.errorText = this.ME + " ERROR: " + e.toString();
            System.err.println(this.errorText);
            return -1;
        }
    }

    public final boolean wantsHelp() {
        return this.property.wantsHelp();
    }

    public String getErrorText() {
        return this.errorText;
    }

    public int init(Applet applet) {
        this.property.setApplet(applet);
        return this.property.wantsHelp() ? 1 : 0;
    }

    public final ContextNode getContextNode() {
        return this.contextNode;
    }

    public boolean isServerSide() {
        return false;
    }

    public NodeId getNodeId() {
        return null;
    }

    public String getId() {
        return this.id;
    }

    public String getStrippedId() {
        return Global.getStrippedString(this.getId());
    }

    public static final String getStrippedString(String text) {
        String strippedId = StringHelper.replaceAll(text, "/", "");
        strippedId = StringHelper.replaceAll(strippedId, ".", "_");
        strippedId = StringHelper.replaceAll(strippedId, ":", "_");
        strippedId = StringHelper.replaceAll(strippedId, "[", "_");
        strippedId = StringHelper.replaceAll(strippedId, "]", "_");
        return StringHelper.replaceAll(strippedId, "\\", "");
    }

    public void setId(String id) {
        this.id = id;
        if (this.contextNode == null) {
            this.contextNode = new ContextNode(this, "node", this.getStrippedId(), ContextNode.ROOT_NODE);
        } else {
            this.contextNode.setInstanceName(this.getStrippedId());
        }
    }

    public String getLogPrefixDashed() {
        return "";
    }

    public String getLogPrefix() {
        return "";
    }

    public static Global instance() {
        if (firstInstance == null) {
            Class clazz = class$org$xmlBlaster$util$Global == null ? (class$org$xmlBlaster$util$Global = Global.class$("org.xmlBlaster.util.Global")) : class$org$xmlBlaster$util$Global;
            synchronized (clazz) {
                if (firstInstance == null) {
                    new Global();
                }
            }
        }
        return firstInstance;
    }

    public final Global getClone(String[] args) {
        Global g = (Global)this.clone();
        if (args != null && args.length > 0) {
            g.init(args);
        }
        return g;
    }

    protected Object clone() {
        return new Global(Property.propsToArgs(this.property.getProperties()), false, false);
    }

    public final Property getProperty() {
        return this.property;
    }

    public final I_MsgKeyFactory getMsgKeyFactory() {
        if (this.msgKeyFactory == null) {
            Global global = this;
            synchronized (global) {
                if (this.msgKeyFactory == null) {
                    this.msgKeyFactory = new MsgKeySaxFactory(this);
                }
            }
        }
        return this.msgKeyFactory;
    }

    public final I_QueryKeyFactory getQueryKeyFactory() {
        if (this.queryKeyFactory == null) {
            Global global = this;
            synchronized (global) {
                if (this.queryKeyFactory == null) {
                    this.queryKeyFactory = new QueryKeySaxFactory(this);
                }
            }
        }
        return this.queryKeyFactory;
    }

    public final I_ConnectQosFactory getConnectQosFactory() {
        if (this.connectQosFactory == null) {
            Global global = this;
            synchronized (global) {
                if (this.connectQosFactory == null) {
                    this.connectQosFactory = new ConnectQosSaxFactory(this);
                }
            }
        }
        return this.connectQosFactory;
    }

    public final I_DisconnectQosFactory getDisconnectQosFactory() {
        if (this.disconnectQosFactory == null) {
            Global global = this;
            synchronized (global) {
                if (this.disconnectQosFactory == null) {
                    this.disconnectQosFactory = new DisconnectQosSaxFactory(this);
                }
            }
        }
        return this.disconnectQosFactory;
    }

    public final I_MsgQosFactory getMsgQosFactory() {
        if (this.msgQosFactory == null) {
            Global global = this;
            synchronized (global) {
                if (this.msgQosFactory == null) {
                    this.msgQosFactory = new MsgQosSaxFactory(this);
                }
            }
        }
        return this.msgQosFactory;
    }

    public final I_QueryQosFactory getQueryQosFactory() {
        if (this.queryQosFactory == null) {
            Global global = this;
            synchronized (global) {
                if (this.queryQosFactory == null) {
                    this.queryQosFactory = new QueryQosSaxFactory(this);
                }
            }
        }
        return this.queryQosFactory;
    }

    public final I_StatusQosFactory getStatusQosFactory() {
        if (this.statusQosFactory == null) {
            Global global = this;
            synchronized (global) {
                if (this.statusQosFactory == null) {
                    this.statusQosFactory = new StatusQosQuickParseFactory(this);
                }
            }
        }
        return this.statusQosFactory;
    }

    public final I_CallbackDriver getNativeCallbackDriver(String key) {
        if (this.log.CALL) {
            this.log.call(this.ME, "getNativeCallbackDriver(" + key + ")");
        }
        return (I_CallbackDriver)this.nativeCallbackDriverMap.get(key);
    }

    public final void addNativeCallbackDriver(String key, I_CallbackDriver driver) {
        if (this.log.CALL) {
            this.log.call(this.ME, "addNativeCallbackDriver(" + key + "," + driver.getName() + ")");
        }
        this.nativeCallbackDriverMap.put(key, driver);
    }

    public final void removeNativeCallbackDriver(String key) {
        if (this.log.CALL) {
            this.log.call(this.ME, "removeNativeCallbackDriver(" + key + ")");
        }
        this.nativeCallbackDriverMap.remove(key);
    }

    public final Object getObjectEntry(String key) {
        return this.objectMap.get(key);
    }

    public final void addObjectEntry(String key, Object driver) {
        this.objectMap.put(key, driver);
    }

    public final void removeObjectEntry(String key) {
        this.objectMap.remove(key);
    }

    public final void setBootstrapAddress(Address address) {
        this.bootstrapAddress = address;
    }

    public final Address getBootstrapAddress() {
        if (this.bootstrapAddress == null) {
            Global global = this;
            synchronized (global) {
                if (this.bootstrapAddress == null) {
                    if (this.log.CALL) {
                        this.log.call(this.ME, "Entering getBootstrapAddress(), trying to resolve one ...");
                    }
                    this.bootstrapAddress = new Address(this);
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "Initialized bootstrapAddress to host=" + this.bootstrapAddress.getBootstrapHostname() + " port=" + this.bootstrapAddress.getBootstrapPort() + ", rawAddress='" + this.bootstrapAddress.getRawAddress() + "'");
                    }
                    this.bootstrapAddress.setRawAddress(this.bootstrapAddress.getBootstrapUrl());
                }
            }
        }
        return this.bootstrapAddress;
    }

    public String getCbHostname() {
        if (this.cbHostname == null) {
            Address addr = this.getBootstrapAddress();
            this.cbHostname = this.getProperty().get("bootstrapHostnameCB", this.getCbHostname(addr.getBootstrapHostname(), addr.getBootstrapPort()));
        }
        return this.cbHostname;
    }

    public String getCbHostname(String hostname, int port) {
        String cbHostname = null;
        if (port > 0) {
            try {
                Socket sock = new Socket(hostname, port);
                cbHostname = sock.getLocalAddress().getHostAddress();
                sock.close();
                sock = null;
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Default cb host is " + this.cbHostname);
                }
            }
            catch (IOException e) {
                this.log.trace(this.ME, "Can't find default cb hostname: " + e.toString());
            }
        }
        if (cbHostname == null) {
            cbHostname = this.getLocalIP();
        }
        return cbHostname;
    }

    /*
     * WARNING - void declaration
     */
    public String accessFromInternalHttpServer(Address address, String urlPath, boolean verbose) throws XmlBlasterException {
        Address addr;
        if (this.logDefault.CALL) {
            this.logDefault.call(this.ME, "Entering accessFromInternalHttpServer(" + (address == null ? "null" : address.getRawAddress()) + ") ...");
        }
        if ((addr = address) != null && addr.getBootstrapPort() > 0) {
            if (addr.getBootstrapHostname() == null || addr.getBootstrapHostname().length() < 1) {
                addr.setBootstrapHostname(this.getLocalIP());
            }
        } else {
            addr = this.getBootstrapAddress();
        }
        try {
            int numbytes;
            if (urlPath != null && !urlPath.startsWith("/")) {
                urlPath = "/" + urlPath;
            }
            if (this.logDefault.TRACE) {
                this.logDefault.trace(this.ME, "Trying internal http server on " + addr.getBootstrapHostname() + ":" + addr.getBootstrapPort() + "" + urlPath);
            }
            URL nsURL = new URL("http", addr.getBootstrapHostname(), addr.getBootstrapPort(), urlPath);
            InputStream nsis = nsURL.openStream();
            byte[] bytes = new byte[4096];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            int ii = 0;
            while (ii < 20 && nsis.available() <= 0) {
                if (this.logDefault.TRACE) {
                    this.logDefault.trace(this.ME, "XmlBlaster on host " + addr.getBootstrapHostname() + " and bootstrapPort " + addr.getBootstrapPort() + " returns empty data, trying again after sleeping 10 milli ...");
                }
                Sleeper.sleep(10L);
                ++ii;
            }
            while (nsis.available() > 0 && (numbytes = nsis.read(bytes)) > 0) {
                void var9_13;
                bos.write(bytes, 0, (int)var9_13);
            }
            nsis.close();
            String data = bos.toString();
            if (this.logDefault.TRACE) {
                this.logDefault.trace(this.ME, "Retrieved http data='" + data + "'");
            }
            return data;
        }
        catch (MalformedURLException e) {
            String text = "XmlBlaster not found on host " + addr.getBootstrapHostname() + " and bootstrap port " + addr.getBootstrapPort() + ".";
            this.logDefault.error(this.ME, text + e.toString());
            e.printStackTrace();
            throw new XmlBlasterException(this, ErrorCode.USER_CONFIGURATION, this.ME + "NoHttpServer", text, e);
        }
        catch (IOException e) {
            if (verbose) {
                this.logDefault.warn(this.ME, "XmlBlaster not found on host " + addr.getBootstrapHostname() + " and bootstrapPort " + addr.getBootstrapPort() + ": " + e.toString());
            }
            throw new XmlBlasterException(this, ErrorCode.COMMUNICATION_NOCONNECTION, this.ME + "NoHttpServer", "XmlBlaster not found on host " + addr.getBootstrapHostname() + " and bootstrap port " + addr.getBootstrapPort() + ".", e);
        }
    }

    public final String getLocalIP() {
        if (this.ip_addr == null) {
            if (this.getBootstrapAddress().hasBootstrapHostname()) {
                this.ip_addr = this.getBootstrapAddress().getBootstrapHostname();
            } else {
                try {
                    this.ip_addr = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    this.logDefault.warn(this.ME, "Can't determine local IP address, try e.g. '-bootstrapHostname 192.168.10.1' on command line: " + e.toString());
                }
                if (this.ip_addr == null) {
                    this.ip_addr = "127.0.0.1";
                }
            }
        }
        return this.ip_addr;
    }

    public final PluginLoader getClientSecurityPluginLoader() {
        Class clazz = class$org$xmlBlaster$client$PluginLoader == null ? (class$org$xmlBlaster$client$PluginLoader = Global.class$("org.xmlBlaster.client.PluginLoader")) : class$org$xmlBlaster$client$PluginLoader;
        synchronized (clazz) {
            if (this.clientSecurityLoader == null) {
                this.clientSecurityLoader = new PluginLoader(this);
            }
        }
        return this.clientSecurityLoader;
    }

    public RecorderPluginManager getRecorderPluginManager() {
        Class clazz = class$org$xmlBlaster$util$recorder$RecorderPluginManager == null ? (class$org$xmlBlaster$util$recorder$RecorderPluginManager = Global.class$("org.xmlBlaster.util.recorder.RecorderPluginManager")) : class$org$xmlBlaster$util$recorder$RecorderPluginManager;
        synchronized (clazz) {
            if (this.recorderPluginManager == null) {
                this.recorderPluginManager = new RecorderPluginManager(this);
            }
        }
        return this.recorderPluginManager;
    }

    public final QueuePluginManager getQueuePluginManager() {
        if (this.queuePluginManager == null) {
            Class clazz = class$org$xmlBlaster$util$queue$QueuePluginManager == null ? (class$org$xmlBlaster$util$queue$QueuePluginManager = Global.class$("org.xmlBlaster.util.queue.QueuePluginManager")) : class$org$xmlBlaster$util$queue$QueuePluginManager;
            synchronized (clazz) {
                if (this.queuePluginManager == null) {
                    this.queuePluginManager = new QueuePluginManager(this);
                }
            }
        }
        return this.queuePluginManager;
    }

    public final DispatchPluginManager getDispatchPluginManager() {
        if (this.dispatchPluginManager == null) {
            Class clazz = class$org$xmlBlaster$util$dispatch$plugins$DispatchPluginManager == null ? (class$org$xmlBlaster$util$dispatch$plugins$DispatchPluginManager = Global.class$("org.xmlBlaster.util.dispatch.plugins.DispatchPluginManager")) : class$org$xmlBlaster$util$dispatch$plugins$DispatchPluginManager;
            synchronized (clazz) {
                if (this.dispatchPluginManager == null) {
                    this.dispatchPluginManager = new DispatchPluginManager(this);
                }
            }
        }
        return this.dispatchPluginManager;
    }

    public final XmlProcessor getXmlProcessor() throws XmlBlasterException {
        if (this.xmlProcessor == null) {
            Class clazz = class$org$xmlBlaster$util$XmlProcessor == null ? (class$org$xmlBlaster$util$XmlProcessor = Global.class$("org.xmlBlaster.util.XmlProcessor")) : class$org$xmlBlaster$util$XmlProcessor;
            synchronized (clazz) {
                if (this.xmlProcessor == null) {
                    this.xmlProcessor = new XmlProcessor(this);
                }
            }
        }
        return this.xmlProcessor;
    }

    public ClassLoaderFactory getClassLoaderFactory() {
        boolean useXmlBlasterClassloader = this.getProperty().get("useXmlBlasterClassloader", true);
        if (!useXmlBlasterClassloader) {
            return null;
        }
        Class clazz = class$org$xmlBlaster$util$classloader$ClassLoaderFactory == null ? (class$org$xmlBlaster$util$classloader$ClassLoaderFactory = Global.class$("org.xmlBlaster.util.classloader.ClassLoaderFactory")) : class$org$xmlBlaster$util$classloader$ClassLoaderFactory;
        synchronized (clazz) {
            if (this.classLoaderFactory == null) {
                String clf = this.getProperty().get("classLoaderFactory", (String)null);
                if (clf != null) {
                    try {
                        Class<?> clfc = Thread.currentThread().getContextClassLoader().loadClass(clf);
                        this.classLoaderFactory = (ClassLoaderFactory)clfc.newInstance();
                        this.classLoaderFactory.init(this);
                        ClassLoaderFactory classLoaderFactory = this.classLoaderFactory;
                        return classLoaderFactory;
                    }
                    catch (Exception e) {
                        this.log.warn(this.ME, "Could not load custom classLoaderFactory " + clf + " using StandaloneClassLoaderFactory");
                    }
                }
                this.classLoaderFactory = new StandaloneClassLoaderFactory(this);
            }
        }
        return this.classLoaderFactory;
    }

    public final HttpIORServer getHttpServer() throws XmlBlasterException {
        if (this.httpServer == null) {
            Global global = this;
            synchronized (global) {
                if (this.httpServer == null) {
                    this.httpServer = new HttpIORServer(this, this.getBootstrapAddress().getBootstrapHostname(), this.getBootstrapAddress().getBootstrapPort());
                }
            }
        }
        return this.httpServer;
    }

    public final synchronized void shutdownHttpServer() {
        try {
            if (this.httpServer != null) {
                this.httpServer.shutdown();
            }
            this.httpServer = null;
        }
        catch (Throwable e) {
            this.log.warn(this.ME, "Problems during ORB cleanup: " + e.toString());
            e.printStackTrace();
        }
    }

    public SAXParserFactory getSAXParserFactory() throws XmlBlasterException {
        if (this.saxFactory == null) {
            try {
                if (this.log.DUMP) {
                    this.log.dump(this.ME, this.getProperty().toXml());
                }
                this.saxFactory = JAXPFactory.newSAXParserFactory(this.getProperty().get("javax.xml.parsers.SAXParserFactory", "org.apache.crimson.jaxp.SAXParserFactoryImpl"));
            }
            catch (FactoryConfigurationError e) {
                throw new XmlBlasterException(this, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, this.ME, "SAXParserFactoryError", e);
            }
        }
        return this.saxFactory;
    }

    public DocumentBuilderFactory getDocumentBuilderFactory() throws XmlBlasterException {
        if (this.docBuilderFactory == null) {
            try {
                if (this.log.DUMP) {
                    this.log.dump(this.ME, this.getProperty().toXml());
                }
                this.docBuilderFactory = JAXPFactory.newDocumentBuilderFactory(this.getProperty().get("javax.xml.parsers.DocumentBuilderFactory", "org.apache.crimson.jaxp.DocumentBuilderFactoryImpl"));
            }
            catch (FactoryConfigurationError e) {
                throw new XmlBlasterException(this, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, this.ME, "DocumentBuilderFactoryError", e);
            }
        }
        return this.docBuilderFactory;
    }

    public TransformerFactory getTransformerFactory() throws XmlBlasterException {
        if (this.transformerFactory == null) {
            try {
                this.transformerFactory = JAXPFactory.newTransformerFactory(this.getProperty().get("javax.xml.transform.TransformerFactory", "org.apache.xalan.processor.TransformerFactoryImpl"));
            }
            catch (TransformerFactoryConfigurationError e) {
                throw new XmlBlasterException(this, ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, this.ME, "TransformerFactoryError", e);
            }
        }
        return this.transformerFactory;
    }

    public I_EntryFactory getEntryFactory() {
        if (this.entryFactory != null) {
            return this.entryFactory;
        }
        Global global = this;
        synchronized (global) {
            this.entryFactory = new ClientEntryFactory();
            this.entryFactory.initialize(this);
            I_EntryFactory i_EntryFactory = this.entryFactory;
            return i_EntryFactory;
        }
    }

    public static String encode(String s, String enc) {
        return URLEncoder.encode(s);
    }

    public static String decode(String s, String enc) {
        try {
            return URLDecoder.decode(s);
        }
        catch (Exception e) {
            System.out.println("PANIC in decode(" + s + "): " + e.toString());
            return s;
        }
    }

    public final ProtocolPluginManager getProtocolPluginManager() {
        if (this.protocolPluginManager == null) {
            Global global = this;
            synchronized (global) {
                if (this.protocolPluginManager == null) {
                    this.protocolPluginManager = new ProtocolPluginManager(this);
                }
            }
        }
        return this.protocolPluginManager;
    }

    public final CbServerPluginManager getCbServerPluginManager() {
        if (this.cbServerPluginManager == null) {
            Global global = this;
            synchronized (global) {
                if (this.cbServerPluginManager == null) {
                    this.cbServerPluginManager = new CbServerPluginManager(this);
                }
            }
        }
        return this.cbServerPluginManager;
    }

    public final Timeout getBurstModeTimer() {
        if (this.burstModeTimer == null) {
            Global global = this;
            synchronized (global) {
                if (this.burstModeTimer == null) {
                    this.burstModeTimer = new Timeout("XmlBlaster.BurstmodeTimer");
                }
            }
        }
        return this.burstModeTimer;
    }

    public final Timeout getPingTimer() {
        if (this.pingTimer == null) {
            Global global = this;
            synchronized (global) {
                if (this.pingTimer == null) {
                    this.pingTimer = new Timeout("XmlBlaster.PingTimer");
                }
            }
        }
        return this.pingTimer;
    }

    public final Timeout getMessageTimer() {
        if (this.messageTimer == null) {
            Global global = this;
            synchronized (global) {
                if (this.messageTimer == null) {
                    boolean useWeakReferences = true;
                    this.messageTimer = new Timeout("XmlBlaster.MessageTimer", useWeakReferences);
                }
            }
        }
        return this.messageTimer;
    }

    public final Timeout getJdbcConnectionPoolTimer() {
        if (this.jdbcConnectionPoolTimer == null) {
            Global global = this;
            synchronized (global) {
                if (this.jdbcConnectionPoolTimer == null) {
                    this.jdbcConnectionPoolTimer = new Timeout("XmlBlaster.JdbcConnectionPoolTimer");
                }
            }
        }
        return this.jdbcConnectionPoolTimer;
    }

    public final DispatchWorkerPool getDispatchWorkerPool() {
        if (this.dispatchWorkerPool == null) {
            Global global = this;
            synchronized (global) {
                if (this.dispatchWorkerPool == null) {
                    this.dispatchWorkerPool = new DispatchWorkerPool(this);
                }
            }
        }
        return this.dispatchWorkerPool;
    }

    public DispatchConnectionsHandler createDispatchConnectionsHandler(DispatchManager dispatchManager) throws XmlBlasterException {
        return new ClientDispatchConnectionsHandler(this, dispatchManager);
    }

    public void finalize() {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Entering finalize");
        }
        this.shutdown();
    }

    public void shutdown() {
        if (this.isDoingShutdown) {
            return;
        }
        this.isDoingShutdown = true;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Destroying util.Global handle");
        }
        if (this.dispatchWorkerPool != null) {
            this.dispatchWorkerPool.shutdown();
            this.dispatchWorkerPool = null;
        }
        if (this.burstModeTimer != null) {
            this.burstModeTimer.shutdown();
            this.burstModeTimer = null;
        }
        if (this.pingTimer != null) {
            this.pingTimer.shutdown();
            this.pingTimer = null;
        }
        if (this.messageTimer != null) {
            this.messageTimer.shutdown();
            this.messageTimer = null;
        }
        if (this.jdbcConnectionPoolTimer != null) {
            this.jdbcConnectionPoolTimer.shutdown();
            this.jdbcConnectionPoolTimer = null;
        }
        this.shutdownHttpServer();
        if (this.xmlProcessor != null) {
            this.xmlProcessor.shutdown();
            this.xmlProcessor = null;
        }
        Class clazz = class$org$xmlBlaster$util$Global == null ? (class$org$xmlBlaster$util$Global = Global.class$("org.xmlBlaster.util.Global")) : class$org$xmlBlaster$util$Global;
        synchronized (clazz) {
            if (firstInstance != null && this == firstInstance) {
                firstInstance = null;
            }
        }
        this.isDoingShutdown = false;
    }

    public boolean isServer() {
        return false;
    }

    public PluginManagerBase getPluginManager() {
        if (this.pluginManager == null) {
            Global global = this;
            synchronized (global) {
                if (this.pluginManager == null) {
                    this.pluginManager = new PluginManagerBase(this);
                }
            }
        }
        return this.pluginManager;
    }

    public PluginRegistry getPluginRegistry() {
        if (this.pluginRegistry == null) {
            Global global = this;
            synchronized (global) {
                if (this.pluginRegistry == null) {
                    this.pluginRegistry = new PluginRegistry(this);
                }
            }
        }
        return this.pluginRegistry;
    }

    public I_XmlBlasterAccess getXmlBlasterAccess() {
        if (this.xmlBlasterAccess == null) {
            Global global = this;
            synchronized (global) {
                if (this.xmlBlasterAccess == null) {
                    this.xmlBlasterAccess = new XmlBlasterAccess(this);
                }
            }
        }
        return this.xmlBlasterAccess;
    }

    public void setWipeOutDB(boolean doWipeout) {
        this.wipeOutDB = doWipeout;
    }

    public boolean getWipeOutDB() {
        return this.wipeOutDB;
    }

    public static String getStackTraceAsString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream pstr = new PrintStream(baos);
        new Exception().printStackTrace(pstr);
        return new String(baos.toByteArray());
    }

    public String usage() {
        StringBuffer sb = new StringBuffer(4028);
        sb.append(XmlBlasterAccess.usage(this));
        sb.append(Global.logUsage());
        return sb.toString();
    }

    public static String logUsage() {
        StringBuffer sb = new StringBuffer(1024);
        sb.append("Logging options:\n");
        sb.append("   -info  false        Supress info output.\n");
        sb.append("   -trace true         Show code trace.\n");
        sb.append("   -dump  true         Dump internal state.\n");
        sb.append("   -call  true         Show important method entries\n");
        sb.append("   -time true          Display some performance data.\n");
        sb.append("   -logFile <fileName> Log to given file.\n");
        sb.append("   -logDevice file,console  Log to console and above file.\n");
        sb.append("   Example:  -logFile /tmp/test.log -logDevice file,console -call true -trace[corba] true.\n");
        sb.append("\n");
        sb.append("Control properties framework:\n");
        sb.append("   -propertyFile <file> Specify an xmlBlaster property file to load.\n");
        sb.append("                        The contained settings overwrite a property file found in the xmlBlaster.jar file.\n");
        sb.append("   -property.verbose   0 switches logging off, 2 is most verbose when loading properties on startup [1].\n");
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println("NO GLOBAL, Hit a key");
        try {
            System.in.read();
        }
        catch (IOException e) {
            // empty catch block
        }
        Global glob = new Global(args);
        try {
            while (true) {
                System.out.println("NO XmlBlasterAccess, Hit a key");
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    // empty catch block
                }
                XmlBlasterAccess a = new XmlBlasterAccess(glob);
                System.out.println("connecting ...");
                a.connect(null, null);
                System.out.println("connected ...");
                System.out.println("Hit a key");
                try {
                    System.in.read();
                }
                catch (IOException e) {
                    // empty catch block
                }
                a.disconnect(null);
                System.out.println("All is shutdown: Hit a key");
                try {
                    System.in.read();
                }
                catch (IOException iOException) {}
            }
        }
        catch (Exception e) {
            System.out.println("Global.main: " + e.toString());
            return;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        counter = 0;
    }
}

