/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.xmlBlaster.util.Global;

public class JAXPFactory {
    private static final String ME = "JAXPFactory";
    private static final JAXPFactory factory = new JAXPFactory();

    public static SAXParserFactory newSAXParserFactory() throws FactoryConfigurationError {
        return SAXParserFactory.newInstance();
    }

    public static SAXParserFactory newSAXParserFactory(String factoryName) throws FactoryConfigurationError {
        try {
            SAXParserFactory spf = (SAXParserFactory)factory.getClass().getClassLoader().loadClass(factoryName).newInstance();
            return spf;
        }
        catch (Exception e) {
            throw new FactoryConfigurationError(e, e.getMessage());
        }
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory() throws FactoryConfigurationError {
        return DocumentBuilderFactory.newInstance();
    }

    public static DocumentBuilderFactory newDocumentBuilderFactory(String factoryName) throws FactoryConfigurationError {
        try {
            DocumentBuilderFactory dbf = (DocumentBuilderFactory)factory.getClass().getClassLoader().loadClass(factoryName).newInstance();
            return dbf;
        }
        catch (Exception e) {
            throw new FactoryConfigurationError(e, e.getMessage());
        }
    }

    public static TransformerFactory newTransformerFactory() throws TransformerFactoryConfigurationError {
        return TransformerFactory.newInstance();
    }

    public static TransformerFactory newTransformerFactory(String factoryName) throws TransformerFactoryConfigurationError {
        try {
            TransformerFactory tf = (TransformerFactory)factory.getClass().getClassLoader().loadClass(factoryName).newInstance();
            return tf;
        }
        catch (Exception e) {
            throw new TransformerFactoryConfigurationError(e, e.getMessage());
        }
    }

    private static Object newInstance(String className) throws InstanceException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                Global.instance().getLog("core").warn(ME, "newInstance: 'Thread.currentThread().getContextClassLoader()' returns null!");
                return Class.forName(className).newInstance();
            }
            Class<?> fac = classLoader.loadClass(className);
            if (fac == null) {
                Global.instance().getLog("core").warn(ME, "newInstance: 'classLoader.loadClass(" + className + ")' returns null!");
            }
            return fac.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new InstanceException("Could not find class: " + className, e);
        }
        catch (Exception e) {
            throw new InstanceException("Exception: " + e.toString() + "Could not load factory: " + className, e);
        }
    }

    static class InstanceException
    extends Exception {
        private Exception exception;

        InstanceException(String msg, Exception x) {
            super(msg);
            this.exception = x;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

