/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.Serializable;
import org.xmlBlaster.client.key.PublishKey;
import org.xmlBlaster.client.qos.PublishQos;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnitRaw;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.def.MethodName;
import org.xmlBlaster.util.key.KeyData;
import org.xmlBlaster.util.qos.QosData;

public final class MsgUnit
implements Serializable {
    private static final transient byte[] EMPTY_BYTEARR = new byte[0];
    private transient Global glob;
    private QosData qosData;
    private byte[] content;
    private KeyData keyData;

    public MsgUnit(String key, byte[] content, String qos) throws XmlBlasterException {
        this((Global)null, key, content, qos);
    }

    public MsgUnit(Global glob, String key, byte[] content, String qos) throws XmlBlasterException {
        this(glob, key, content, qos, MethodName.PUBLISH);
    }

    public MsgUnit(Global glob, MsgUnitRaw msgUnitRaw, MethodName methodName) throws XmlBlasterException {
        this(glob, msgUnitRaw.getKey(), msgUnitRaw.getContent(), msgUnitRaw.getQos(), methodName);
    }

    public MsgUnit(Global glob, String key, byte[] content, String qos, MethodName methodName) throws XmlBlasterException {
        this.glob = glob == null ? Global.instance() : glob;
        this.setContent(content);
        if (methodName == MethodName.PUBLISH) {
            this.qosData = this.glob.getMsgQosFactory().readObject(qos);
            this.keyData = this.glob.getMsgKeyFactory().readObject(key);
        } else if (methodName == MethodName.UPDATE) {
            this.qosData = this.glob.getMsgQosFactory().readObject(qos);
            this.keyData = this.glob.getMsgKeyFactory().readObject(key);
        } else if (methodName == MethodName.SUBSCRIBE || methodName == MethodName.UNSUBSCRIBE || methodName == MethodName.GET || methodName == MethodName.ERASE) {
            this.qosData = this.glob.getQueryQosFactory().readObject(qos);
            this.keyData = this.glob.getQueryKeyFactory().readObject(key);
        } else if (methodName == MethodName.CONNECT) {
            this.qosData = this.glob.getConnectQosFactory().readObject(qos);
            this.keyData = null;
        } else if (methodName == MethodName.DISCONNECT) {
            this.qosData = this.glob.getDisconnectQosFactory().readObject(qos);
            this.keyData = null;
        } else {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_NOTIMPLEMENTED, "MsgUnit", "Sorry method support for '" + methodName.toString() + "' is missing");
        }
    }

    public MsgUnit(String key, String contentAsString, String qos) throws XmlBlasterException {
        this(null, key, contentAsString, qos);
    }

    public MsgUnit(Global glob, String key, String contentAsString, String qos) throws XmlBlasterException {
        this(glob, key, contentAsString.getBytes(), qos, MethodName.PUBLISH);
    }

    public MsgUnit(PublishKey key, String contentAsString, PublishQos qos) {
        this(key, contentAsString.getBytes(), qos);
    }

    public MsgUnit(PublishKey key, byte[] content, PublishQos qos) {
        this(key.getData(), content, qos.getData());
    }

    public MsgUnit(KeyData key, byte[] content, QosData qos) {
        if (qos == null) {
            Thread.dumpStack();
            throw new IllegalArgumentException("MsgUnit constructor with qos=" + qos + " is invalid");
        }
        this.glob = qos.getGlobal();
        this.keyData = key;
        this.qosData = qos;
        this.setContent(content);
    }

    public MsgUnit(MsgUnit old, KeyData key, byte[] content, QosData qos) {
        this.glob = old.getGlobal();
        this.qosData = qos == null ? (QosData)old.getQosData().clone() : qos;
        this.keyData = key == null ? (KeyData)old.getKeyData().clone() : key;
        this.setContent(content == null ? old.getContent() : content);
    }

    public Global getGlobal() {
        return this.glob;
    }

    public void setGlobal(Global glob) {
        this.glob = glob;
        if (this.keyData != null) {
            this.keyData.setGlobal(this.glob);
        }
        this.qosData.setGlobal(this.glob);
    }

    public MethodName getMethodName() {
        return this.qosData.getMethod();
    }

    public void setContent(byte[] content) {
        this.content = content == null ? EMPTY_BYTEARR : content;
    }

    public String getKeyOid() {
        if (this.keyData != null) {
            return this.keyData.getOid();
        }
        return null;
    }

    public String getKey() {
        if (this.keyData != null) {
            return this.keyData.toXml();
        }
        return null;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentStr() {
        return new String(this.content);
    }

    public String getQos() {
        return this.qosData.toXml();
    }

    public KeyData getKeyData() {
        return this.keyData;
    }

    public QosData getQosData() {
        return this.qosData;
    }

    public String getLogId() {
        return this.getKeyOid() + "/" + this.getQosData().getRcvTimestamp();
    }

    public String getContentMime() {
        return this.keyData != null ? this.keyData.getContentMime() : null;
    }

    public String getContentMimeExtended() {
        return this.keyData != null ? this.keyData.getContentMimeExtended() : null;
    }

    public String getDomain() {
        return this.keyData != null ? this.keyData.getDomain() : null;
    }

    public MsgUnit getClone() {
        byte[] newContent = new byte[this.content.length];
        System.arraycopy(this.content, 0, newContent, 0, this.content.length);
        return new MsgUnit(this.keyData == null ? null : (KeyData)this.keyData.clone(), this.content, (QosData)this.qosData.clone());
    }

    public MsgUnitRaw getMsgUnitRaw() {
        return new MsgUnitRaw(this, this.keyData == null ? null : this.keyData.toXml(), this.content, this.qosData == null ? null : this.qosData.toXml());
    }

    public boolean sameContent(byte[] newContent) {
        if (newContent == null) {
            return this.content.length < 1;
        }
        if (this.content.length != newContent.length) {
            return false;
        }
        int ii = 0;
        while (ii < newContent.length) {
            if (this.content[ii] != newContent[ii]) {
                return false;
            }
            ++ii;
        }
        return true;
    }

    public long size() {
        return this.qosData.size() + (this.keyData == null ? 0 : this.keyData.size()) + this.content.length;
    }

    public String toXml() {
        return this.toXml(null, -1);
    }

    public String toXml(String extraOffset) {
        return this.toXml(extraOffset, -1);
    }

    public String toXml(String extraOffset, int maxContentLen) {
        StringBuffer sb = new StringBuffer(1024);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        if (this.keyData != null) {
            sb.append(this.keyData.toXml(extraOffset + " "));
        }
        if (maxContentLen < 0 || this.content.length < maxContentLen) {
            sb.append(offset).append("  <content><![CDATA[").append(new String(this.content)).append("]]></content>");
        } else if (maxContentLen > 0) {
            sb.append(offset).append("  <content size='").append(this.content.length).append("'><![CDATA[");
            sb.append(new String(this.content, 0, maxContentLen)).append("...]]></content>");
        }
        sb.append(this.qosData.toXml(extraOffset + " "));
        return sb.toString();
    }
}

