/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

public final class MsgUnitRaw {
    private static final transient byte[] EMPTY_BYTEARR = new byte[0];
    private static final transient String EMPTY_STRING = "";
    private final transient Object msgUnit;
    private final String qos;
    private final String key;
    private final byte[] content;

    public MsgUnitRaw(Object msgUnit, String key, byte[] content, String qos) {
        this.msgUnit = msgUnit;
        this.qos = qos == null ? EMPTY_STRING : qos;
        this.key = key == null ? EMPTY_STRING : key;
        this.content = content == null ? EMPTY_BYTEARR : content;
    }

    public MsgUnitRaw(String key, byte[] content, String qos) {
        this(null, key, content, qos);
    }

    public String getKey() {
        return this.key;
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getContentStr() {
        return new String(this.content);
    }

    public String getQos() {
        return this.qos;
    }

    public long size() {
        return this.qos.length() + this.key.length() + this.content.length;
    }

    public Object getMsgUnit() {
        return this.msgUnit;
    }

    public String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer();
        String offset = "\n";
        if (extraOffset == null) {
            extraOffset = EMPTY_STRING;
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<MsgUnitRaw>");
        sb.append(this.key);
        sb.append(offset).append(" <content>").append(new String(this.content)).append("</content>");
        sb.append(this.qos);
        sb.append(offset).append("</MsgUnitRaw>\n");
        return sb.toString();
    }
}

