/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jutils.log.LogChannel;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.StopParseException;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class SaxHandlerBase
implements ContentHandler,
ErrorHandler,
LexicalHandler {
    private String ME = "SaxHandlerBase";
    protected final Global glob;
    private final LogChannel log;
    protected Locator locator = null;
    protected StringBuffer character = new StringBuffer();
    protected String xmlSource;
    protected String xmlLiteral;
    private boolean useLexicalHandler = false;

    public SaxHandlerBase() {
        this(null);
    }

    public SaxHandlerBase(Global glob) {
        this.glob = glob == null ? Global.instance() : glob;
        this.log = this.glob.getLog(null);
        if (this.log.CALL) {
            this.log.trace(this.ME, "Creating new SaxHandlerBase");
        }
    }

    public void init(InputSource inputSource) throws XmlBlasterException {
        this.parse(inputSource);
    }

    public void init(String xmlSource, InputSource inputSource) throws XmlBlasterException {
        this.xmlSource = xmlSource;
        this.parse(inputSource);
    }

    public void init(String xmlLiteral) throws XmlBlasterException {
        if (xmlLiteral == null) {
            xmlLiteral = "";
        }
        this.xmlLiteral = xmlLiteral;
        if (xmlLiteral.length() > 0) {
            this.parse(xmlLiteral);
        }
    }

    public void setUseLexicalHandler(boolean useLexicalHandler) {
        this.useLexicalHandler = useLexicalHandler;
    }

    public boolean getUseLexicalHandler() {
        return this.useLexicalHandler;
    }

    private void parse(String xmlData) throws XmlBlasterException {
        this.parse(new InputSource(new StringReader(xmlData)));
    }

    private void parse(InputSource xmlData) throws XmlBlasterException {
        try {
            try {
                SAXParserFactory spf = this.glob.getSAXParserFactory();
                boolean validate = this.glob.getProperty().get("javax.xml.parsers.validation", false);
                spf.setValidating(validate);
                SAXParser sp = spf.newSAXParser();
                XMLReader parser = sp.getXMLReader();
                parser.setContentHandler(this);
                parser.setErrorHandler(this);
                if (this.useLexicalHandler) {
                    try {
                        parser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
                    }
                    catch (SAXNotRecognizedException e) {
                        this.log.warn(this.ME, "The SAX parser does not support the LexicalHandler interface, CDATA sections can't be restored" + e.toString());
                    }
                    catch (SAXNotSupportedException e) {
                        this.log.warn(this.ME, "The SAX parser does not support the LexicalHandler interface, CDATA sections can't be restored" + e.toString());
                    }
                }
                parser.parse(xmlData);
            }
            catch (StopParseException e) {
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "StopParseException: Parsing execution stopped half the way");
                }
                if (e.hasError()) {
                    throw e.getXmlBlasterException();
                }
                Object var9_14 = null;
                this.locator = null;
                return;
            }
            catch (Throwable e) {
                String location;
                if (e instanceof SAXException) {
                    StopParseException stop;
                    Exception exc;
                    SAXException saxE = (SAXException)e;
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, "SAXException: Parsing execution stopped half the way");
                    }
                    if ((exc = saxE.getException()) instanceof StopParseException && (stop = (StopParseException)exc).hasError()) {
                        throw stop.getXmlBlasterException();
                    }
                }
                String string = location = this.locator == null ? "" : this.locator.toString();
                if (e instanceof SAXParseException) {
                    location = this.getLocationString((SAXParseException)e);
                } else if (this.xmlSource != null) {
                    location = this.xmlSource;
                }
                if (e.getMessage() != null && e.getMessage().indexOf("org.xmlBlaster.util.StopParseException") > -1) {
                    if (this.log.TRACE) {
                        this.log.trace(this.ME, location + ": Parsing execution stopped half the way: " + e.getMessage() + ": " + e.toString());
                    }
                    Object var9_15 = null;
                    this.locator = null;
                    return;
                }
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Error while SAX parsing: " + location + ": " + e.toString() + "\n" + xmlData);
                    e.printStackTrace();
                }
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME + ".parse()", "Error while SAX parsing " + location + ":\n" + xmlData, e);
            }
            Object var9_13 = null;
            this.locator = null;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            this.locator = null;
            throw throwable;
        }
    }

    public String toString() {
        return this.xmlLiteral;
    }

    public String toXml() {
        return this.xmlLiteral;
    }

    public void characters(char[] ch, int start, int length) {
        this.character.append(ch, start, length);
    }

    public void endDocument() {
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        this.log.warn(this.ME, "Please provide your endElement() implementation");
    }

    public void endPrefixMapping(String prefix) {
        this.log.warn(this.ME, "Entering endPrefixMapping(prefix=" + prefix + ") ...");
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void processingInstruction(String target, String data) {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void skippedEntity(String name) {
        this.log.warn(this.ME, "Entering skippedEntity() ...");
    }

    public void startDocument() {
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
        this.log.warn(this.ME, "Please provide your startElement() implementation");
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.log.warn(this.ME, "Entering startPrefixMapping() ...");
    }

    public void warning(SAXParseException ex) {
        this.log.warn(this.ME, "warning: " + this.getLocationString(ex) + ": " + ex.getMessage() + " PublicId=" + ex.getPublicId() + ", SystemId=" + ex.getSystemId() + "\n" + this.xmlLiteral);
    }

    public void error(SAXParseException ex) {
        this.log.warn(this.ME, "error: " + this.getLocationString(ex) + ": " + ex.getMessage() + "\n" + this.xmlLiteral);
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        if (ex.getMessage().indexOf("org.xmlBlaster.util.StopParseException") > -1) {
            if (this.log.TRACE) {
                this.log.trace(this.ME + ".fatalError", "Parsing execution stopped half the way");
            }
            return;
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME + ".fatalError", this.getLocationString(ex) + ": " + ex.getMessage() + "\n" + this.xmlLiteral);
            ex.printStackTrace();
        }
        throw ex;
    }

    public void notationDecl(String name, String publicId, String systemId) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "notationDecl(name=" + name + ", publicId=" + publicId + ", systemId=" + systemId + ")");
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
        if (this.log.TRACE) {
            this.log.trace(this.ME, "unparsedEntityDecl(name=" + name + ", publicId=" + publicId + ", systemId=" + systemId + ", notationName=" + notationName + ")");
        }
    }

    private String getLocationString(SAXParseException ex) {
        String systemId;
        StringBuffer str = new StringBuffer();
        if (this.xmlSource != null) {
            str.append(this.xmlSource).append(":");
        }
        if ((systemId = ex.getSystemId()) != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    public void comment(char[] ch, int start, int length) {
    }

    public void endCDATA() {
    }

    public void endDTD() {
    }

    public void endEntity(String name) {
    }

    public void startCDATA() {
    }

    public void startDTD(String name, String publicId, String systemId) {
    }

    public void startEntity(String name) {
    }
}

