/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.Serializable;
import org.jutils.text.StringHelper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.cluster.NodeId;

public final class SessionName
implements Serializable {
    private static String ME = "SessionName";
    private final transient Global glob;
    public static final String ROOT_MARKER_TAG = "/node";
    public static final String SUBJECT_MARKER_TAG = "client";
    private String absoluteName;
    private NodeId nodeId;
    private String relativeName;
    private final String subjectId;
    private long pubSessionId;

    public SessionName(Global glob, String name) {
        this(glob, (NodeId)null, name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SessionName(Global glob, NodeId nodeId, String name) {
        String tmp;
        Global global = this.glob = glob == null ? Global.instance() : glob;
        if (name == null) {
            throw new IllegalArgumentException(ME + ": Your given name is null");
        }
        String relative = name;
        if (name.startsWith("/")) {
            String[] arr = StringHelper.toArray(name, "/");
            if (arr.length == 0) {
                throw new IllegalArgumentException(ME + ": '" + name + "': The root tag must be '/node'.");
            }
            if (arr.length > 0 && !"node".equals(arr[0])) {
                throw new IllegalArgumentException(ME + ": '" + name + "': The root tag must be '/node'.");
            }
            if (arr.length > 1) {
                if (nodeId != null) {
                    this.nodeId = nodeId;
                } else {
                    this.nodeId = new NodeId(arr[1]);
                    if ("unknown".equals(this.nodeId.getId())) {
                        this.nodeId = null;
                    }
                }
            }
            if (arr.length > 2 && !SUBJECT_MARKER_TAG.equals(arr[2])) {
                throw new IllegalArgumentException(ME + ": '" + name + "': 'client' tag is missing.");
            }
            relative = "";
            int i = 3;
            while (i < arr.length) {
                relative = relative + arr[i];
                if (i < arr.length - 1) {
                    relative = relative + "/";
                }
                ++i;
            }
        }
        if (this.nodeId == null) {
            if (nodeId != null) {
                this.nodeId = nodeId;
            } else if (glob.isServer()) {
                this.nodeId = glob.getNodeId();
            }
        }
        if (relative.length() < 1) {
            throw new IllegalArgumentException(ME + ": '" + name + "': No relative information found.");
        }
        int ii = 0;
        String[] arr = StringHelper.toArray(relative, "/");
        if (arr.length <= ii) throw new IllegalArgumentException(ME + ": '" + name + "': No relative information found.");
        if (SUBJECT_MARKER_TAG.equals(tmp = arr[ii++])) {
            if (arr.length <= ii) throw new IllegalArgumentException(ME + ": '" + name + "': No relative information found.");
            this.subjectId = arr[ii++];
        } else {
            this.subjectId = tmp;
        }
        if (arr.length <= ii) return;
        this.pubSessionId = Long.parseLong(arr[ii++]);
    }

    public SessionName(Global glob, SessionName sessionName, long pubSessionId) {
        this(glob, sessionName.getAbsoluteName());
        this.pubSessionId = pubSessionId;
    }

    public String getAbsoluteName() {
        if (this.absoluteName == null) {
            StringBuffer buf = new StringBuffer(256);
            if (this.nodeId != null) {
                buf.append("/node/").append(this.nodeId.getId()).append("/");
            }
            buf.append(this.getRelativeName());
            this.absoluteName = buf.toString();
        }
        return this.absoluteName;
    }

    public String toString() {
        return this.getAbsoluteName();
    }

    public String getRelativeName() {
        if (this.relativeName == null) {
            StringBuffer buf = new StringBuffer(126);
            buf.append("client/").append(this.subjectId);
            if (this.isSession()) {
                buf.append("/").append("" + this.pubSessionId);
            }
            this.relativeName = buf.toString();
        }
        return this.relativeName;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }

    public String getNodeIdStr() {
        return this.nodeId == null ? null : this.nodeId.getId();
    }

    public String getLoginName() {
        return this.subjectId;
    }

    public final boolean isInternalLoginName() {
        return this.subjectId.startsWith("_");
    }

    public final boolean isPluginInternalLoginName() {
        return this.subjectId.startsWith("_") && !this.isCoreInternalLoginName();
    }

    public final boolean isCoreInternalLoginName() {
        return this.subjectId.startsWith("__");
    }

    public long getPublicSessionId() {
        return this.pubSessionId;
    }

    public boolean isSession() {
        return this.pubSessionId != 0L;
    }

    public boolean isPubSessionIdInternal() {
        return this.pubSessionId < 0L;
    }

    public boolean isPubSessionIdUser() {
        return this.pubSessionId > 0L;
    }

    public boolean equalsRelative(SessionName sessionName) {
        return this.getRelativeName().equals(sessionName.getRelativeName());
    }

    public boolean equalsAbsolute(SessionName sessionName) {
        return this.getAbsoluteName().equals(sessionName.getAbsoluteName());
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<SessionName id='").append(this.getAbsoluteName());
        sb.append("' isSession='").append(this.isSession()).append("'>");
        sb.append(offset).append(" <nodeId>").append(this.getNodeIdStr()).append("</nodeId>");
        sb.append(offset).append(" <relativeName>").append(this.getRelativeName()).append("</relativeName>");
        sb.append(offset).append(" <loginName>").append(this.getLoginName()).append("</loginName>");
        sb.append(offset).append(" <pubSessionId>").append(this.getPublicSessionId()).append("</pubSessionId>");
        sb.append(offset).append("</SessionName>");
        return sb.toString();
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        try {
            SessionName sessionName = new SessionName(glob, "jack");
            System.out.println("AbsoluteName=" + sessionName.getAbsoluteName() + " RelativeName=" + sessionName.getRelativeName());
        }
        catch (IllegalArgumentException e) {
            System.out.println("ERROR: " + e.toString());
        }
    }
}

