/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.xmlBlaster.util.Container;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_Timeout;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.WeakObj;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class Timeout
extends Thread {
    private static String ME = "Timeout";
    private TreeMap map = null;
    private boolean running = true;
    private boolean ready = false;
    private final boolean debug = false;
    private final boolean useWeakReference;
    private boolean mapHasNewEntry;

    public Timeout() {
        this("Timeout-Thread", false);
    }

    public Timeout(String name) {
        this(name, false);
    }

    public Timeout(String name, boolean useWeakReference) {
        super(name);
        this.useWeakReference = useWeakReference;
        this.map = new TreeMap();
        this.setDaemon(true);
        this.start();
        while (!this.ready) {
            try {
                Thread.currentThread();
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getSize() {
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            int n = this.map.size();
            return n;
        }
    }

    public void run() {
        while (this.running) {
            Object callback;
            long delay = 100000L;
            Container container = null;
            TreeMap treeMap = this.map;
            synchronized (treeMap) {
                try {
                    Timestamp nextWakeup = (Timestamp)this.map.firstKey();
                    long next = nextWakeup.getMillis();
                    long current = System.currentTimeMillis();
                    delay = next - current;
                    if (delay <= 0L) {
                        container = (Container)this.map.remove(nextWakeup);
                    }
                }
                catch (NoSuchElementException e) {
                    // empty catch block
                }
                this.mapHasNewEntry = false;
            }
            if (container != null) {
                callback = container.getCallback();
                if (callback == null) continue;
                callback.timeout(container.getUserData());
                continue;
            }
            if (delay <= 0L) continue;
            try {
                callback = this;
                synchronized (callback) {
                    this.ready = true;
                    if (!this.mapHasNewEntry) {
                        this.wait(delay);
                    }
                }
            }
            catch (InterruptedException i) {
                // empty catch block
            }
        }
    }

    public final Timestamp addTimeoutListener(I_Timeout listener, long delay, Object userData) {
        if (listener == null) {
            throw new IllegalArgumentException(ME + ": addTimeoutListener() with listener=null");
        }
        Timestamp key = null;
        int nanoCounter = 0;
        long timeMillis = System.currentTimeMillis();
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            while (true) {
                long endNanos;
                Object obj;
                if ((obj = this.map.get(key = new Timestamp(endNanos = (timeMillis + delay) * 1000000L + (long)nanoCounter))) == null) break;
                ++nanoCounter;
            }
            this.map.put(key, new Container(this.useWeakReference, listener, userData));
            this.mapHasNewEntry = true;
        }
        Timeout timeout = this;
        synchronized (timeout) {
            this.notify();
        }
        return key;
    }

    public final Timestamp refreshTimeoutListener(Timestamp key, long delay) throws XmlBlasterException {
        Object obj;
        if (key == null) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new XmlBlasterException(Global.instance(), ErrorCode.INTERNAL_NULLPOINTER, ME + "addTimeoutListener", "The timeout handle is null, no timeout refresh done");
        }
        Object newKey = null;
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            obj = this.map.remove(key);
        }
        if (obj == null) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new XmlBlasterException(Global.instance(), ErrorCode.RESOURCE_UNAVAILABLE, ME, "The timeout handle '" + key + "' is unknown, no timeout refresh done");
        }
        Container container = (Container)obj;
        I_Timeout callback = container.getCallback();
        if (callback == null) {
            if (this.useWeakReference) {
                throw new XmlBlasterException(Global.instance(), ErrorCode.INTERNAL_UNKNOWN, ME, "The weak callback reference for timeout handle '" + key + "' is garbage collected, no timeout refresh done");
            }
            throw new XmlBlasterException(Global.instance(), ErrorCode.INTERNAL_UNKNOWN, ME, "Internal error for timeout handle '" + key + "', no timeout refresh done");
        }
        return this.addTimeoutListener(callback, delay, container.getUserData());
    }

    public final Timestamp addOrRefreshTimeoutListener(I_Timeout listener, long delay, Object userData, Timestamp key) throws XmlBlasterException {
        if (key == null) {
            return this.addTimeoutListener(listener, delay, userData);
        }
        try {
            return this.refreshTimeoutListener(key, delay);
        }
        catch (XmlBlasterException e) {
            if (ErrorCode.RESOURCE_UNAVAILABLE == e.getErrorCode()) {
                return this.addTimeoutListener(listener, delay, userData);
            }
            throw e;
        }
    }

    public final void removeTimeoutListener(Timestamp key) {
        if (key == null) {
            return;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Container container = (Container)this.map.remove(key);
            if (container != null) {
                container.reset();
                Object var3_3 = null;
            }
        }
    }

    public final boolean isExpired(Timestamp key) {
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            boolean bl = this.map.get(key) == null;
            return bl;
        }
    }

    public final long spanToTimeout(Timestamp key) {
        if (key == null) {
            return -1L;
        }
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Container container = (Container)this.map.get(key);
            if (container == null) {
                long l = -1L;
                return l;
            }
            long l = this.getTimeout(key) - System.currentTimeMillis();
            return l;
        }
    }

    public final long elapsed(Timestamp key) {
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            Container container = (Container)this.map.get(key);
            if (container == null) {
                long l = -1L;
                return l;
            }
            long l = System.currentTimeMillis() - container.creation;
            return l;
        }
    }

    public final long getTimeout(Timestamp key) {
        if (key == null) {
            return -1L;
        }
        return key.getMillis();
    }

    public final void removeAll() {
        TreeMap treeMap = this.map;
        synchronized (treeMap) {
            this.map.clear();
        }
    }

    public void shutdown() {
        this.removeAll();
        this.running = false;
        Timeout timeout = this;
        synchronized (timeout) {
            this.notify();
        }
    }

    public static void main(String[] args) throws Exception {
        Timeout t = new Timeout();
        System.out.println("Timeout constructor done, sleeping 10 sec");
        try {
            Thread.currentThread();
            Thread.sleep(10000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    static void testStrongReference() {
        Timeout timeout = new Timeout("TestTimer");
        System.out.println("Timer created and ready.");
        Timestamp timeoutHandle = timeout.addTimeoutListener(new I_Timeout(){

            public void timeout(Object userData) {
                System.out.println("Timeout happened");
                System.exit(0);
            }
        }, 2000L, null);
        try {
            Thread.currentThread();
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.err.println("ERROR: Timeout not occurred.");
        System.exit(1);
    }

    static void testWeakReference() {
        Timeout timeout = new Timeout("TestTimer", true);
        System.out.println("Timer created and ready.");
        WeakObj weakObj = new WeakObj();
        Object anotherRef = new Object();
        Timestamp timeoutHandle = timeout.addTimeoutListener(weakObj, 4000L, weakObj);
        weakObj = null;
        System.gc();
        System.out.println("Called gc()");
        try {
            Thread.currentThread();
            Thread.sleep(8000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.out.println("SUCCESS: No timeout happened");
        System.exit(0);
    }
}

