/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.Serializable;
import java.util.Date;

public class Timestamp
implements Comparable,
Serializable {
    public static final int MILLION = 1000000;
    public static final int BILLION = 1000000000;
    private static int nanoCounter = 0;
    private static long lastMillis = 0L;
    private final long timestamp;
    private transient Long timestampLong;
    private transient String strFormat = null;
    protected String tagName = "timestamp";
    static /* synthetic */ Class class$org$xmlBlaster$util$Timestamp;

    public Timestamp() {
        Class clazz = class$org$xmlBlaster$util$Timestamp == null ? (class$org$xmlBlaster$util$Timestamp = Timestamp.class$("org.xmlBlaster.util.Timestamp")) : class$org$xmlBlaster$util$Timestamp;
        synchronized (clazz) {
            long timeMillis = System.currentTimeMillis();
            if (lastMillis < timeMillis) {
                nanoCounter = 0;
                lastMillis = timeMillis;
                this.timestamp = timeMillis * 1000000L;
                return;
            }
            if (lastMillis == timeMillis) {
                if (++nanoCounter >= 1000000) {
                    throw new RuntimeException("org.xmlBlaster.util.Timestamp nanoCounter overflow - internal error");
                }
                this.timestamp = timeMillis * 1000000L + (long)nanoCounter;
                return;
            }
            if (++nanoCounter >= 1000000) {
                throw new RuntimeException("org.xmlBlaster.util.Timestamp nanoCounter overflow - the system time seems to go back into past, giving up after 1000000 times: System.currentTimeMillis() is not ascending old=" + lastMillis + " new=" + timeMillis);
            }
            this.timestamp = lastMillis * 1000000L + (long)nanoCounter;
            System.err.println("WARNING: org.xmlBlaster.util.Timestamp System.currentTimeMillis() is not ascending old=" + lastMillis + " new=" + timeMillis + " created timestamp=" + this.timestamp);
            return;
        }
    }

    public Timestamp(long nanos) {
        this.timestamp = nanos;
    }

    public final long getTimestamp() {
        return this.timestamp;
    }

    public final Long getTimestampLong() {
        if (this.timestampLong == null) {
            this.timestampLong = new Long(this.timestamp);
        }
        return this.timestampLong;
    }

    public final int getNanosOnly() {
        return (int)(this.timestamp % 1000000000L);
    }

    public final int getMillisOnly() {
        return this.getNanosOnly() / 1000000;
    }

    public final long getMillis() {
        return this.timestamp / 1000000L;
    }

    public final long getTime() {
        return this.getMillis();
    }

    public String toString() {
        if (this.strFormat == null) {
            java.sql.Timestamp ts = new java.sql.Timestamp(this.getMillis());
            ts.setNanos(this.getNanosOnly());
            this.strFormat = ts.toString();
        }
        return this.strFormat;
    }

    public static Timestamp valueOf(String s) {
        java.sql.Timestamp tsSql = java.sql.Timestamp.valueOf(s);
        return new Timestamp(((Date)tsSql).getTime() / 1000L * 1000L * 1000000L + (long)tsSql.getNanos());
    }

    public int compareTo(Object obj) {
        Timestamp ts = (Timestamp)obj;
        if (this.timestamp > ts.getTimestamp()) {
            return 1;
        }
        if (this.timestamp < ts.getTimestamp()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Timestamp ts) {
        return this.timestamp == ts.getTimestamp();
    }

    public boolean equals(Object obj) {
        if (obj instanceof Timestamp) {
            return this.equals((Timestamp)obj);
        }
        return false;
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        return this.toXml(extraOffset, false);
    }

    public final String toXml(String extraOffset, boolean literal) {
        StringBuffer sb = new StringBuffer(200);
        String offset = "\n ";
        if (extraOffset != null) {
            offset = offset + extraOffset;
        }
        if (literal) {
            sb.append(offset).append("<").append(this.tagName).append(" nanos='").append(this.getTimestamp()).append("'>");
            sb.append(offset).append(" ").append(this.toString());
            sb.append(offset).append("</").append(this.tagName).append(">");
        } else {
            sb.append(offset).append("<").append(this.tagName).append(" nanos='").append(this.getTimestamp()).append("'/>");
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            if (args[0].indexOf(":") != -1) {
                Timestamp tt = Timestamp.valueOf(args[0]);
                System.out.println(tt.toXml("", true));
            } else {
                long nanos = Long.valueOf(args[0]);
                Timestamp tt = new Timestamp(nanos);
                System.out.println(tt.toXml("", true));
            }
            System.exit(0);
        }
        int count = 5;
        StringBuffer buf = new StringBuffer(count * 120);
        int ii = 0;
        while (ii < count) {
            Timestamp.test(buf);
            ++ii;
        }
        System.out.println(buf);
        Timestamp.testToString();
        Timestamp.testToString();
        Timestamp.testToString();
        System.out.println("TEST 1");
        Timestamp.testValueOf();
        Timestamp.testValueOf();
        Timestamp.testValueOf();
        System.out.println("TEST 2");
        Timestamp.testToXml(false);
        Timestamp.testToXml(false);
        Timestamp.testToXml(false);
        System.out.println("TEST 3");
        Timestamp.testToXml(true);
        Timestamp.testToXml(true);
        Timestamp.testToXml(true);
        Timestamp ts1 = new Timestamp();
        Timestamp ts2 = new Timestamp();
        if (ts1.equals(ts2)) {
            System.out.println("ERROR: equals()");
        }
        if (ts2.compareTo(ts1) < 1) {
            System.out.println("ERROR: compareTo()");
        }
        if (!ts2.toString().equals(Timestamp.valueOf(ts2.toString()).toString())) {
            System.out.println("ERROR: valueOf() ts2.toString()=" + ts2.toString() + " Timestamp.valueOf(ts2.toString()).toString()=" + Timestamp.valueOf(ts2.toString()).toString());
        }
        System.out.println(ts2.toXml(""));
        System.out.println(ts2.toXml("", true));
    }

    private static final Timestamp test(StringBuffer buf) {
        Timestamp ts = new Timestamp();
        buf.append("Timestamp toString()=" + ts.toString() + " getTimestamp()=" + ts.getTimestamp() + " getMillis()=" + ts.getMillis() + " getMillisOnly()=" + ts.getMillisOnly() + " getNanosOnly()=" + ts.getNanosOnly() + " getScannedAndDumped()=" + Timestamp.valueOf(ts.toString()).toString() + "\n");
        return ts;
    }

    private static final void testToString() {
        int count = 10000;
        long start = System.currentTimeMillis();
        Timestamp ts = new Timestamp();
        String val = null;
        int ii = 0;
        while (ii < count) {
            val = ts.toString();
            ++ii;
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("toString(): " + count + " toString " + elapsed + " millisec -> " + (double)elapsed * 1000.0 * 1000.0 / (double)count + " nanosec/toString()");
    }

    private static final void testValueOf() {
        int count = 10000;
        Timestamp ts1 = new Timestamp();
        String val = ts1.toString();
        Timestamp ts = null;
        long start = System.currentTimeMillis();
        int ii = 0;
        while (ii < count) {
            ts = Timestamp.valueOf(val);
            ++ii;
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("valueOf(): " + count + " valueOf " + elapsed + " millisec -> " + (double)elapsed * 1000.0 * 1000.0 / (double)count + " nanosec/valueOf()");
    }

    private static final void testToXml(boolean literal) {
        int count = 10000;
        long start = System.currentTimeMillis();
        Timestamp ts = new Timestamp();
        String val = null;
        int ii = 0;
        while (ii < count) {
            val = ts.toXml(null, literal);
            ++ii;
        }
        long elapsed = System.currentTimeMillis() - start;
        System.out.println("toXml(" + literal + "): " + count + " toXml " + elapsed + " millisec -> " + (double)elapsed * 1000.0 * 1000.0 / (double)count + " nanosec/toXml()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

