/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.text.MessageFormat;
import org.jutils.JUtilsException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.Timestamp;
import org.xmlBlaster.util.def.ErrorCode;

public class XmlBlasterException
extends Exception
implements Serializable {
    private final transient Global glob;
    private transient ErrorCode errorCodeEnum;
    private String errorCodeStr;
    private final String node;
    private String location;
    private final String lang;
    private final String versionInfo;
    private transient Timestamp timestamp;
    private final long timestampNanos;
    private final String stackTrace;
    private boolean isServerSide;
    private final transient Throwable cause;
    private String embeddedMessage;
    private final String transactionInfo;
    private static final String DEFAULT_LOGFORMAT = "XmlBlasterException errorCode=[{0}] serverSideException={3} node=[{1}] location=[{2}] message=[{4} : {8}]";
    private static final String DEFAULT_LOGFORMAT_INTERNAL = "XmlBlasterException serverSideException={3} node=[{1}] location=[{2}]\n{8}\nstackTrace={7}\nversionInfo={5}\nerrorCode description={9}\n";
    private String logFormatInternal;
    private final String logFormatResource;
    private final String logFormatCommunication;
    private final String logFormatUser;
    private final String logFormatTransaction;
    private final String logFormatLegacy;
    private final String logFormat;

    public XmlBlasterException(Global glob, ErrorCode errorCodeEnum, String location) {
        this(glob, errorCodeEnum, location, null, null);
    }

    public XmlBlasterException(Global glob, ErrorCode errorCodeEnum, String location, String message) {
        this(glob, errorCodeEnum, location, message, null);
    }

    public XmlBlasterException(Global glob, ErrorCode errorCodeEnum, String location, String message, Throwable cause) {
        this(glob, errorCodeEnum, null, location, null, message, null, null, null, null, null, glob == null ? true : glob.isServerSide(), cause);
    }

    public XmlBlasterException(Global glob, ErrorCode errorCodeEnum, String node, String location, String lang, String message, String versionInfo, Timestamp timestamp, String stackTrace, String embeddedMessage, String transcationInfo, boolean isServerSide) {
        this(glob, errorCodeEnum, node, location, lang, message, versionInfo, timestamp, stackTrace, embeddedMessage, transcationInfo, isServerSide, null);
    }

    private XmlBlasterException(Global glob, ErrorCode errorCodeEnum, String node, String location, String lang, String message, String versionInfo, Timestamp timestamp, String stackTrace, String embeddedMessage, String transcationInfo, boolean isServerSide, Throwable cause) {
        super(message == null || message.length() < 1 ? errorCodeEnum.getLongDescription() : message);
        this.glob = glob == null ? Global.instance() : glob;
        this.logFormat = this.glob.getProperty().get("XmlBlasterException.logFormat", DEFAULT_LOGFORMAT);
        this.logFormatInternal = this.glob.getProperty().get("XmlBlasterException.logFormat.internal", DEFAULT_LOGFORMAT_INTERNAL);
        this.logFormatResource = this.glob.getProperty().get("XmlBlasterException.logFormat.resource", this.logFormat);
        this.logFormatCommunication = this.glob.getProperty().get("XmlBlasterException.logFormat.communication", this.logFormat);
        this.logFormatUser = this.glob.getProperty().get("XmlBlasterException.logFormat.user", this.logFormat);
        this.logFormatTransaction = this.glob.getProperty().get("XmlBlasterException.logFormat.transaction", this.logFormat);
        this.logFormatLegacy = this.glob.getProperty().get("XmlBlasterException.logFormat.legacy", this.logFormat);
        this.errorCodeEnum = errorCodeEnum == null ? ErrorCode.INTERNAL_UNKNOWN : errorCodeEnum;
        this.errorCodeStr = this.errorCodeEnum.getErrorCode();
        this.node = node == null ? this.glob.getId() : node;
        this.location = location;
        this.lang = lang == null ? "en" : lang;
        this.versionInfo = versionInfo == null ? this.createVersionInfo() : versionInfo;
        this.timestamp = timestamp == null ? new Timestamp() : timestamp;
        this.timestampNanos = this.timestamp.getTimestamp();
        this.cause = cause;
        String string = this.stackTrace = stackTrace == null ? this.createStackTrace() : stackTrace;
        this.embeddedMessage = embeddedMessage == null ? (this.cause == null ? "" : this.cause.toString()) : embeddedMessage;
        this.transactionInfo = transcationInfo == null ? "<transaction/>" : transcationInfo;
        this.isServerSide = isServerSide;
    }

    public final void changeErrorCode(ErrorCode errorCodeEnum) {
        if (this.embeddedMessage == null || this.embeddedMessage.length() < 1) {
            this.embeddedMessage = "Original erroCode=" + this.errorCodeStr;
        }
        this.errorCodeEnum = errorCodeEnum == null ? ErrorCode.INTERNAL_UNKNOWN : errorCodeEnum;
        this.errorCodeStr = this.errorCodeEnum.getErrorCode();
    }

    public final Global getGlobal() {
        return this.glob;
    }

    public final ErrorCode getErrorCode() {
        if (this.errorCodeEnum == null) {
            try {
                this.errorCodeEnum = ErrorCode.toErrorCode(this.errorCodeStr);
            }
            catch (IllegalArgumentException e) {
                this.errorCodeEnum = ErrorCode.INTERNAL_UNKNOWN;
            }
        }
        return this.errorCodeEnum;
    }

    public final boolean isErrorCode(ErrorCode code) {
        return this.errorCodeEnum == code;
    }

    public final String getErrorCodeStr() {
        return this.errorCodeStr;
    }

    public final String getNode() {
        return this.node;
    }

    public final String getLocation() {
        return this.location;
    }

    public final void setLocation(String location) {
        this.location = location;
    }

    public final String getLang() {
        return this.lang;
    }

    public String getMessage() {
        Object[] arguments = new Object[]{this.errorCodeStr == null ? "" : this.errorCodeStr, this.node == null ? "" : this.node, this.location == null ? "" : this.location, new Boolean(this.isServerSide()), this.getRawMessage(), this.versionInfo == null ? "" : this.versionInfo, this.timestamp == null ? "" : this.timestamp.toString(), this.stackTrace == null ? "" : this.stackTrace, this.embeddedMessage == null ? "" : this.embeddedMessage, this.errorCodeEnum == null ? "" : this.errorCodeEnum.getUrl()};
        boolean handleAsInternal = this.cause != null && (this.cause instanceof XmlBlasterException && ((XmlBlasterException)this.cause).isInternal() || this.cause instanceof NullPointerException || this.cause instanceof IllegalArgumentException || this.cause instanceof ArrayIndexOutOfBoundsException || this.cause instanceof StringIndexOutOfBoundsException || this.cause instanceof ClassCastException || this.cause instanceof OutOfMemoryError);
        try {
            if (this.isInternal() || handleAsInternal) {
                return MessageFormat.format(this.logFormatInternal, arguments);
            }
            if (this.isResource()) {
                return MessageFormat.format(this.logFormatResource, arguments);
            }
            if (this.isCommunication()) {
                return MessageFormat.format(this.logFormatCommunication, arguments);
            }
            if (this.isUser()) {
                return MessageFormat.format(this.logFormatUser, arguments);
            }
            if (this.errorCodeEnum == ErrorCode.LEGACY) {
                return MessageFormat.format(this.logFormatLegacy, arguments);
            }
            return MessageFormat.format(this.logFormat, arguments);
        }
        catch (IllegalArgumentException e) {
            this.glob.getLog("core").error("XmlBlasterException", "Please check your formatting string for exceptions, usually set by 'XmlBlasterException.logFormat=...' as described in http://www.xmlblaster.org/xmlBlaster/doc/requirements/admin.errorcodes.html: " + e.toString() + "\nOriginal exception is: errorCode=" + this.errorCodeStr + " message=" + this.getRawMessage());
            if (this.isInternal() || handleAsInternal) {
                return MessageFormat.format(DEFAULT_LOGFORMAT_INTERNAL, arguments);
            }
            if (this.isResource()) {
                return MessageFormat.format(DEFAULT_LOGFORMAT, arguments);
            }
            if (this.isCommunication()) {
                return MessageFormat.format(DEFAULT_LOGFORMAT, arguments);
            }
            if (this.isUser()) {
                return MessageFormat.format(DEFAULT_LOGFORMAT, arguments);
            }
            if (this.errorCodeEnum == ErrorCode.LEGACY) {
                return MessageFormat.format(DEFAULT_LOGFORMAT, arguments);
            }
            return MessageFormat.format(DEFAULT_LOGFORMAT, arguments);
        }
    }

    public final String getRawMessage() {
        return super.getMessage() == null ? "" : super.getMessage();
    }

    public final String getVersionInfo() {
        return this.versionInfo;
    }

    public final Timestamp getTimestamp() {
        if (this.timestamp == null) {
            this.timestamp = new Timestamp(this.timestampNanos);
        }
        return this.timestamp;
    }

    public final Throwable getEmbeddedException() {
        return this.cause;
    }

    public final String getStackTraceStr() {
        return this.stackTrace;
    }

    public final String getEmbeddedMessage() {
        return this.embeddedMessage;
    }

    public final String getTransactionInfo() {
        return this.transactionInfo;
    }

    public final boolean isServerSide() {
        return this.isServerSide;
    }

    public final void isServerSide(boolean serverSide) {
        this.isServerSide = serverSide;
    }

    public boolean isInternal() {
        return this.errorCodeStr.startsWith("internal");
    }

    public boolean isResource() {
        return this.errorCodeStr.startsWith("resource");
    }

    public boolean isCommunication() {
        return this.errorCodeStr.startsWith("communication");
    }

    public boolean isUser() {
        return this.errorCodeStr.startsWith("user");
    }

    public boolean isTransaction() {
        return this.errorCodeStr.startsWith("transaction");
    }

    private String createStackTrace() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (this.cause != null) {
            this.cause.printStackTrace(pw);
        }
        this.printStackTrace(pw);
        return sw.toString().trim();
    }

    private String createVersionInfo() {
        StringBuffer buf = new StringBuffer(512);
        buf.append("version=").append(this.glob.getVersion()).append(",");
        buf.append("os.name=").append(System.getProperty("os.name", "unknown").trim()).append(",");
        buf.append("os.version=").append(System.getProperty("os.version", "unknown").trim()).append(",");
        buf.append("java.vm.vendor=").append(System.getProperty("java.vm.vendor", "unknown").trim()).append(",");
        buf.append("java.vm.version=").append(System.getProperty("java.vm.version", "unknown").trim()).append(",");
        buf.append("os.arch=").append(System.getProperty("os.arch", "unknown").trim()).append(",");
        buf.append("build.timestamp=").append(this.glob.getBuildTimestamp()).append(",");
        buf.append("build.java.vendor=").append(this.glob.getBuildJavaVendor()).append(",");
        buf.append("build.java.version=").append(this.glob.getBuildJavaVersion());
        return buf.toString();
    }

    public XmlBlasterException(String location, String message) {
        this(null, ErrorCode.LEGACY, location, message, null);
    }

    public XmlBlasterException(JUtilsException e) {
        this((Global)null, ErrorCode.LEGACY, e.id, e.reason);
    }

    public String toString() {
        String text = "errorCode=" + this.getErrorCodeStr() + " message=" + this.getRawMessage();
        if (this.embeddedMessage != null && this.embeddedMessage.length() > 0) {
            text = text + " : " + this.embeddedMessage;
        }
        return text;
    }

    public static XmlBlasterException parseToString(Global glob, String toString) {
        String errorCode = toString;
        String reason = toString;
        int start = toString.indexOf("errorCode=");
        int end = toString.indexOf(" message=");
        if (start >= 0) {
            if (end >= 0) {
                try {
                    errorCode = toString.substring(start + "errorCode=".length(), end);
                }
                catch (IndexOutOfBoundsException e1) {}
            } else {
                try {
                    errorCode = toString.substring(start + "errorCode=".length());
                }
                catch (IndexOutOfBoundsException e2) {
                    // empty catch block
                }
            }
        }
        if (end >= 0) {
            try {
                reason = toString.substring(end + " message=".length());
            }
            catch (IndexOutOfBoundsException e3) {
                // empty catch block
            }
        }
        try {
            return new XmlBlasterException(glob, ErrorCode.toErrorCode(errorCode), "XmlBlasterException", reason);
        }
        catch (IllegalArgumentException e) {
            glob.getLog("core").warn("XmlBlasterException", "Parsing exception string <" + toString + "> failed: " + e.toString());
            return new XmlBlasterException(glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, "XmlBlasterException", toString);
        }
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(this.getMessage().length() + 256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<exception errorCode='").append(this.getErrorCodeStr()).append("'>");
        sb.append(offset).append(" <class>").append(this.getClass().getName()).append("</class>");
        sb.append(offset).append(" <isServerSide>").append(this.isServerSide()).append("</isServerSide>");
        sb.append(offset).append(" <node>").append(this.getNode()).append("</node>");
        sb.append(offset).append(" <location>").append(this.getLocation()).append("</location>");
        sb.append(offset).append(" <lang>").append(this.getLang()).append("</lang>");
        sb.append(offset).append(" <message><![CDATA[").append(this.getRawMessage()).append("]]></message>");
        sb.append(offset).append(" <versionInfo>").append(this.getVersionInfo()).append("</versionInfo>");
        sb.append(offset).append(" <timestamp>").append(this.getTimestamp().toString()).append("</timestamp>");
        sb.append(offset).append(" <stackTrace><![CDATA[").append(this.getStackTraceStr()).append("]]></stackTrace>");
        sb.append(offset).append(" <embeddedMessage><![CDATA[").append(this.getEmbeddedMessage()).append("]]></embeddedMessage>");
        sb.append(offset).append("</exception>");
        return sb.toString();
    }

    public byte[] toByteArr() {
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream(1024);
        PrintWriter out = new PrintWriter(byteOut);
        out.write(this.getErrorCodeStr());
        out.write(0);
        out.write(this.getNode());
        out.write(0);
        out.write(this.getLocation());
        out.write(0);
        out.write(this.getLang());
        out.write(0);
        out.write(this.getRawMessage());
        out.write(0);
        out.write(this.getVersionInfo());
        out.write(0);
        out.write(this.getTimestamp().toString());
        out.write(0);
        out.write(this.getStackTraceStr());
        out.write(0);
        out.write(this.getEmbeddedMessage());
        out.write(0);
        out.write(this.getTransactionInfo());
        out.write(0);
        out.write("" + this.isServerSide());
        out.write(0);
        out.flush();
        byte[] result = byteOut.toByteArray();
        return result;
    }

    public static XmlBlasterException parseByteArr(Global glob, byte[] data) {
        int start;
        if (data == null) {
            return new XmlBlasterException(glob, ErrorCode.INTERNAL_UNKNOWN, "XmlBlasterException", "Can't parse given serial XmlBlasterException data");
        }
        int end = start = 0;
        String errorCodeStr = null;
        String node = null;
        String location = null;
        String lang = null;
        String message = null;
        String versionInfo = null;
        String timestampStr = null;
        String stackTrace = null;
        String embeddedMessage = null;
        String transactionInfo = null;
        Boolean exceptionFromServer = new Boolean(true);
        try {
            end = start;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            errorCodeStr = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            node = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            location = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            lang = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            message = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            versionInfo = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            timestampStr = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            stackTrace = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            embeddedMessage = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            transactionInfo = new String(data, start, end - start);
            end = start = end + 1;
            while (end < data.length) {
                if (data[end] == 0) break;
                ++end;
            }
            exceptionFromServer = new Boolean(new String(data, start, end - start));
        }
        catch (StringIndexOutOfBoundsException e) {
            glob.getLog("core").error("XmlBlasterException", "Receiving invalid format for XmlBlasterException in '" + new String(data) + "'");
        }
        ErrorCode errorCode = ErrorCode.INTERNAL_UNKNOWN;
        try {
            errorCode = ErrorCode.toErrorCode(errorCodeStr);
        }
        catch (Throwable e) {
            glob.getLog("core").error("XmlBlasterException", "Receiving invalid errorCode in XmlBlasterException in '" + new String(data) + "'");
            message = "Can't parse XmlBlasterException in method parseByteArr(). original message is '" + new String(data) + "'";
        }
        Timestamp ti = new Timestamp();
        try {
            ti = Timestamp.valueOf(timestampStr);
        }
        catch (Throwable e) {
            glob.getLog("core").trace("XmlBlasterException", "Receiving invalid timestamp in XmlBlasterException in '" + new String(data) + "'");
        }
        return new XmlBlasterException(glob, errorCode, node, location, lang, message, versionInfo, ti, stackTrace, embeddedMessage, transactionInfo, exceptionFromServer);
    }

    public static XmlBlasterException convert(Global glob, String location, String message, Throwable throwable) {
        return XmlBlasterException.convert(glob, ErrorCode.INTERNAL_UNKNOWN, location, message, throwable);
    }

    public static XmlBlasterException convert(Global glob, ErrorCode errorCodeEnum, String location, String message, Throwable throwable) {
        if (throwable instanceof XmlBlasterException) {
            return (XmlBlasterException)throwable;
        }
        if (throwable instanceof NullPointerException) {
            return new XmlBlasterException(glob, ErrorCode.INTERNAL_NULLPOINTER, location, message, throwable);
        }
        if (throwable instanceof IllegalArgumentException) {
            return new XmlBlasterException(glob, ErrorCode.INTERNAL_ILLEGALARGUMENT, location, message, throwable);
        }
        if (throwable instanceof ArrayIndexOutOfBoundsException) {
            return new XmlBlasterException(glob, ErrorCode.INTERNAL_UNKNOWN, location, message, throwable);
        }
        if (throwable instanceof StringIndexOutOfBoundsException) {
            return new XmlBlasterException(glob, ErrorCode.INTERNAL_UNKNOWN, location, message, throwable);
        }
        if (throwable instanceof ClassCastException) {
            return new XmlBlasterException(glob, ErrorCode.INTERNAL_UNKNOWN, location, message, throwable);
        }
        if (throwable instanceof OutOfMemoryError) {
            return new XmlBlasterException(glob, ErrorCode.RESOURCE_OUTOFMEMORY, location, message, throwable);
        }
        return new XmlBlasterException(glob, errorCodeEnum, location, message, throwable);
    }

    public void setLogFormatInternal(String logFormatInternal) {
        this.logFormatInternal = logFormatInternal;
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        XmlBlasterException e = new XmlBlasterException(glob, ErrorCode.RESOURCE_OVERFLOW_QUEUE_BYTES, "LOC", "Bla bla");
        System.out.println(e.toXml());
        byte[] serial = e.toByteArr();
        System.out.println("\n" + new String(serial));
        XmlBlasterException back = XmlBlasterException.parseByteArr(glob, serial);
        System.out.println("BACK\n" + back.toXml());
        System.out.println("\ngetMessage:\n" + back.getMessage());
        e = new XmlBlasterException(glob, ErrorCode.INTERNAL_UNKNOWN, "LOC", "Bla bla");
        System.out.println("\ngetMessage:\n" + e.getMessage());
        e = XmlBlasterException.convert(glob, null, null, new IllegalArgumentException("wrong args"));
        System.out.println("\ngetMessage:\n" + e.getMessage());
    }
}

