/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.rmi.RMISecurityManager;
import org.jutils.JUtilsException;
import org.jutils.io.FileUtil;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.JdkCompatible;
import org.xmlBlaster.util.XmlBlasterException;

public class XmlBlasterSecurityManager {
    private static final String ME = "XmlBlasterSecurityManager";
    private static boolean createdTemporary = false;
    static /* synthetic */ Class class$org$xmlBlaster$util$XmlBlasterSecurityManager;

    /*
     * WARNING - void declaration
     */
    public static void createSecurityManager(Global glob) throws XmlBlasterException {
        LogChannel log = glob.getLog("rmi");
        if (System.getSecurityManager() == null) {
            if (System.getProperty("java.security.policy") != null) {
                log.info(ME, "Setting security policy from file " + System.getProperty("java.security.policy"));
            } else if (glob.getProperty().get("java.security.policy", (String)null) != null) {
                String file = glob.getProperty().get("java.security.policy", (String)null);
                log.info(ME, "Setting security policy from file " + file);
                JdkCompatible.setSystemProperty("java.security.policy", file);
            } else {
                URL serverPolicyURL;
                ClassLoader loader = (class$org$xmlBlaster$util$XmlBlasterSecurityManager == null ? (class$org$xmlBlaster$util$XmlBlasterSecurityManager = XmlBlasterSecurityManager.class$("org.xmlBlaster.util.XmlBlasterSecurityManager")) : class$org$xmlBlaster$util$XmlBlasterSecurityManager).getClassLoader();
                if (loader != null && (serverPolicyURL = loader.getResource("xmlBlaster.policy")) != null) {
                    String serverPolicy = serverPolicyURL.getFile();
                    if (serverPolicy.indexOf("!") == -1) {
                        JdkCompatible.setSystemProperty("java.security.policy", serverPolicy);
                        log.info(ME, "Setting security policy " + serverPolicy + ", found it in your CLASSPATH.");
                    } else {
                        try {
                            String tmp;
                            InputStream is = serverPolicyURL.openStream();
                            String data = "";
                            BufferedReader in = new BufferedReader(new InputStreamReader(is));
                            String sep = System.getProperty("line.separator");
                            while ((tmp = in.readLine()) != null) {
                                void var9_12;
                                data = data + (String)var9_12;
                                data = data + sep;
                            }
                            FileUtil.writeFile("xmlBlaster.policy", data);
                            JdkCompatible.setSystemProperty("java.security.policy", "xmlBlaster.policy");
                            log.info(ME, "Using security policy " + serverPolicy + ", found it in your CLASSPATH.");
                            if (log.TRACE) {
                                log.trace(ME, "Wrote xmlBlaster.policy temporary into local directory to be useful for security manager");
                            }
                            if (log.DUMP) {
                                log.dump(ME, data);
                            }
                            createdTemporary = true;
                        }
                        catch (IOException e) {
                            log.warn(ME, "Can't read xmlBlaster.policy:" + e.toString());
                        }
                        catch (JUtilsException e) {
                            log.warn(ME, "Can't write xmlBlaster.policy temporary to local directory:" + e.toString());
                        }
                    }
                }
            }
            if (System.getProperty("java.security.policy") == null) {
                try {
                    String sep = System.getProperty("line.separator");
                    String data = "grant {" + sep + "   permission java.security.AllPermission;" + sep + "};";
                    FileUtil.writeFile("xmlBlaster.policy", data);
                    JdkCompatible.setSystemProperty("java.security.policy", "xmlBlaster.policy");
                    log.info(ME, "java.security.policy is not set, please include config/xmlBlaster.policy into your CLASSPATH or pass the file on startup like 'java -Djava.security.policy=<path>xmlBlaster.policy'...");
                    log.info(ME, "Caution: granting all rights for now ...");
                    if (log.TRACE) {
                        log.trace(ME, "Wrote xmlBlaster.policy temporary into local directory to be useful for security manager");
                    }
                    if (log.DUMP) {
                        log.dump(ME, data);
                    }
                    createdTemporary = true;
                }
                catch (JUtilsException e) {
                    log.warn(ME, "Can't write xmlBlaster.policy temporary to local directory:" + e.toString());
                    String text = "java.security.policy is not set, please include config/xmlBlaster.policy into your CLASSPATH or pass the file on startup like 'java -Djava.security.policy=<path>xmlBlaster.policy'...";
                    throw new XmlBlasterException("XmlBlasterSecurityManagerFailed", text);
                }
            }
            System.setSecurityManager(new RMISecurityManager());
            if (log.TRACE) {
                log.trace(ME, "Started RMISecurityManager");
            }
            if (createdTemporary) {
                if (log.TRACE) {
                    log.trace(ME, "Removed temporary xmlBlaster.policy from local directory.");
                }
                FileUtil.deleteFile(".", "xmlBlaster.policy");
            }
        } else {
            log.warn(ME, "Another security manager is running already, no config/xmlBlaster.policy bound");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

