/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.crimson.tree.XmlDocument;
import org.jutils.log.LogChannel;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xmlBlaster.util.Global;

public class XmlNotPortable {
    private static final String ME = "XmlNotPortable";
    private static final LogChannel log = Global.instance().getLog("core");

    public static final ByteArrayOutputStream write(Document document) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        if (document instanceof XmlDocument) {
            ((XmlDocument)document).write((OutputStream)out);
        } else {
            log.error(ME, "Code to write XML-ASCII is missing for document class=" + document.getClass().getName());
        }
        return out;
    }

    public static final void mergeNode(Document document, Node node) {
        if (XmlNotPortable.log.CALL) {
            log.call(ME, "mergeNode()");
        }
        if (XmlNotPortable.log.DUMP) {
            log.dump(ME, "mergeNode=" + node.toString());
        }
        if (document instanceof XmlDocument) {
            ((XmlDocument)document).changeNodeOwner(node);
        } else {
            log.error(ME, "Code to merge XML-documents is missing for document class=" + document.getClass().getName());
        }
        document.getDocumentElement().appendChild(node);
        if (XmlNotPortable.log.CALL) {
            log.call(ME, "Successfully merged tree");
        }
    }

    public static final void replaceNode(Node oldNode, Node newNode) {
        Document document;
        if (XmlNotPortable.log.TRACE) {
            log.trace(ME, "replaceNode=" + oldNode.toString());
        }
        if ((document = oldNode.getOwnerDocument()) instanceof XmlDocument) {
            ((XmlDocument)document).changeNodeOwner(newNode);
        } else {
            log.error(ME, "Code to replace XML-nodes is missing for document class=" + document.getClass().getName());
        }
        Node parentNode = oldNode.getParentNode();
        if (parentNode == null) {
            document.getDocumentElement().appendChild(newNode);
            document.getDocumentElement().removeChild(oldNode);
        } else {
            parentNode.appendChild(newNode);
            parentNode.removeChild(oldNode);
        }
        if (XmlNotPortable.log.TRACE) {
            log.trace(ME, "Successfully replaced node");
        }
    }
}

