/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util;

import com.jclark.xsl.dom.XMLProcessorImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.jutils.log.LogChannel;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.I_MergeDomNode;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.XmlNotPortable;

public class XmlToDom {
    private String ME = "XmlToDom";
    private final LogChannel log;
    protected String xmlKey_literal;
    protected Document xmlDoc = null;
    protected Node rootNode = null;
    protected Global glob;

    public XmlToDom(Global glob, String xmlKey_literal) throws XmlBlasterException {
        this.glob = glob;
        this.log = this.glob.getLog("core");
        this.create(xmlKey_literal);
    }

    public final void create(String xmlKey_literal) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.trace(this.ME, "Creating DOM tree");
        }
        if (this.xmlKey_literal != null) {
            this.xmlDoc = null;
            this.rootNode = null;
        }
        this.xmlKey_literal = xmlKey_literal.trim();
        if (!this.xmlKey_literal.startsWith("<")) {
            this.log.error(this.ME + ".XML", "Invalid XML syntax, only XML syntax beginning with \"<\" is supported");
            throw new XmlBlasterException(this.ME + ".XML", "Invalid XML syntax, only XML syntax beginning with \"<\" is supported");
        }
    }

    public final String toString() {
        return this.xmlKey_literal == null ? "" : this.xmlKey_literal;
    }

    public final String literal() {
        return this.xmlKey_literal == null ? "" : this.xmlKey_literal;
    }

    public final NamedNodeMap getRootAttributes() throws XmlBlasterException {
        return this.getRootNode().getAttributes();
    }

    public final Node getRootNode() throws XmlBlasterException {
        this.loadDomTree();
        return this.rootNode;
    }

    public final Document getXmlDoc() throws XmlBlasterException {
        this.loadDomTree();
        return this.xmlDoc;
    }

    private void loadDomTree() throws XmlBlasterException {
        if (this.xmlDoc != null) {
            return;
        }
        StringReader reader = new StringReader(this.xmlKey_literal);
        InputSource input = new InputSource(reader);
        XMLProcessorImpl xmlProc = this.glob.getXmlProcessor().getXmlProcessorImpl();
        try {
            this.xmlDoc = xmlProc.load(input);
        }
        catch (IOException e) {
            this.log.error(this.ME + ".IO", "Problems when building DOM tree from your XML-ASCII string: " + e.toString() + "\n" + this.xmlKey_literal);
            throw new XmlBlasterException(this.ME + ".IO", "Problems when building DOM tree from your XML-ASCII string: " + e.toString() + "\n" + this.xmlKey_literal);
        }
        catch (SAXException e) {
            this.log.error(this.ME + ".SAX", "Problems when building DOM tree from your XML-ASCII string: " + e.toString() + "\n" + this.xmlKey_literal);
            throw new XmlBlasterException(this.ME + ".SAX", "Problems when building DOM tree from your XML-ASCII string: " + e.toString() + "\n" + this.xmlKey_literal);
        }
        this.rootNode = this.xmlDoc.getDocumentElement();
    }

    public final void mergeRootNode(I_MergeDomNode merger) throws XmlBlasterException {
        Node tmpRootNode = this.rootNode;
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Entering mergeRootNode() ...");
        }
        Node node = merger.mergeNode(tmpRootNode);
        this.rootNode = tmpRootNode;
    }

    public String domToXml(String offset) {
        StringBuffer sb = new StringBuffer();
        try {
            ByteArrayOutputStream out = XmlNotPortable.write(this.getXmlDoc());
            StringTokenizer st = new StringTokenizer(out.toString(), "\n");
            while (st.hasMoreTokens()) {
                sb.append(offset).append("   ").append(st.nextToken());
            }
        }
        catch (Exception e) {
            this.log.error(this.ME, "Problems in writing DOM");
            return "";
        }
        String nice = sb.toString();
        int index = nice.indexOf("?>");
        if (index > 0) {
            return sb.substring(index + 2);
        }
        return nice;
    }

    public final StringBuffer printOn() throws XmlBlasterException {
        return this.printOn(null);
    }

    public final StringBuffer printOn(String extraOffset) throws XmlBlasterException {
        StringBuffer sb = new StringBuffer();
        String offset = "\n   ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset + "<XmlToDom>");
        sb.append(this.domToXml(offset + "   "));
        sb.append(offset + "</XmlToDom>");
        return sb;
    }
}

