/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.admin.extern;

import com.sun.jdmk.comm.HtmlAdaptorServer;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.def.ErrorCode;

public class JmxWrapper {
    private final Global glob;
    private final LogChannel log;
    private final String ME;
    private static MBeanServer mbeanServer;
    private static HtmlAdaptorServer html;
    private static final String NAME_PREFIX = "xmlBlaster:name=";
    static /* synthetic */ Class class$javax$management$MBeanServer;

    private MBeanServer getMBeanServer() {
        if (mbeanServer == null) {
            JmxWrapper jmxWrapper = this;
            synchronized (jmxWrapper) {
                if (mbeanServer == null) {
                    mbeanServer = MBeanServerFactory.createMBeanServer();
                }
            }
        }
        return mbeanServer;
    }

    private HtmlAdaptorServer getHtmlAdaptorServer() {
        if (html == null) {
            JmxWrapper jmxWrapper = this;
            synchronized (jmxWrapper) {
                if (html == null) {
                    html = new HtmlAdaptorServer();
                }
            }
        }
        return html;
    }

    public JmxWrapper(Global glob) throws XmlBlasterException {
        this.glob = glob;
        this.log = glob.getLog("jmx");
        this.ME = "JmxWrapper" + this.glob.getLogPrefixDashed();
        this.init();
    }

    public void init() throws XmlBlasterException {
        if (mbeanServer == null) {
            JmxWrapper jmxWrapper = this;
            synchronized (jmxWrapper) {
                if (mbeanServer == null) {
                    try {
                        mbeanServer = MBeanServerFactory.createMBeanServer(this.glob.getLocalIP());
                        html = new HtmlAdaptorServer();
                        ObjectName html_name = new ObjectName("Adaptor:name=html,port=8082");
                        mbeanServer.registerMBean(html, html_name);
                        this.log.info(this.ME, "Registered with JMX server, activated HTML adaptor on http://" + this.glob.getLocalIP() + ":8082");
                    }
                    catch (Exception ex) {
                        throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, " could not create MBean Server", ex);
                    }
                    html.start();
                    try {
                        this.startXmlBlasterConnector(mbeanServer);
                    }
                    catch (XmlBlasterException ex) {
                        this.log.error(this.ME, "Error when starting xmlBlasterConnector " + ex.toString());
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public void register(Object obj, String name) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "register(" + name + ")");
        }
        if (obj == null) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, " could not register '" + name + "' into MBean Server since object to register is null.");
        }
        try {
            ObjectName objName = new ObjectName(NAME_PREFIX + name);
            mbeanServer.registerMBean(obj, objName);
        }
        catch (Exception ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, " could not register '" + name + "' into MBean Server.", ex);
        }
    }

    public void unRegister(String name) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "unRegister(" + name + ")");
        }
        try {
            ObjectName objName = new ObjectName(NAME_PREFIX + name);
            mbeanServer.unregisterMBean(objName);
        }
        catch (Exception ex) {
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, " could not register '" + name + "' into MBean Server.", ex);
        }
    }

    public void startXmlBlasterConnector(MBeanServer mbeanServer) throws XmlBlasterException {
        try {
            this.log.info(this.ME, "Registering embedded xmlBlasterConnector for JMX...");
            ObjectName xmlBlasterConnector_name = new ObjectName("Adaptor:transport=xmlBlaster,port=3424");
            mbeanServer.createMBean("org.xmlBlaster.util.admin.extern.XmlBlasterConnector", xmlBlasterConnector_name, null);
            this.log.info(this.ME, "Trying to start internal xmlBlaster - with own MBeanServer as Parameter");
            try {
                mbeanServer.invoke(xmlBlasterConnector_name, "startInternal", new Object[]{JmxWrapper.mbeanServer}, new String[]{(class$javax$management$MBeanServer == null ? (class$javax$management$MBeanServer = JmxWrapper.class$("javax.management.MBeanServer")) : class$javax$management$MBeanServer).getName()});
            }
            catch (Exception ex) {
                throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_CONFIGURATION, this.ME, " could not register  connector into MBean Server.", ex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.error(this.ME, "Error when registering new Connector >>  " + e.toString());
            throw new XmlBlasterException(this.glob, ErrorCode.RESOURCE_UNAVAILABLE, this.ME, " could not start embedded xmlBlasterConnector", e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

