/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.admin.extern;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;

public class SerializeHelper {
    private final Global glob;
    private final LogChannel log;
    private final String ME;

    public SerializeHelper(Global glob) {
        this.glob = glob;
        this.log = glob.getLog("jmx");
        this.ME = "SerializeHelper" + this.glob.getLogPrefixDashed();
    }

    public byte[] serializeObject(Object obj) throws IOException {
        this.log.info(this.ME, "Serializing object " + obj);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            throw new IOException("Unable to serializeObject " + ex.toString());
        }
        return bos.toByteArray();
    }

    public Object deserializeObject(byte[] mybyte) throws IOException {
        this.log.info(this.ME, "Deserializing object ");
        Object obj = new Object();
        ByteArrayInputStream bas = new ByteArrayInputStream(mybyte);
        try {
            ObjectInputStream ois = new ObjectInputStream(bas);
            obj = ois.readObject();
        }
        catch (ClassNotFoundException ex) {
            throw new IOException("Unable to rebuild Object  " + ex.toString());
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return obj;
    }
}

