/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.admin.extern;

import java.util.Properties;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotificationFilter;
import javax.management.ObjectName;
import org.jutils.log.LogChannel;
import org.xmlBlaster.client.I_Callback;
import org.xmlBlaster.client.I_XmlBlasterAccess;
import org.xmlBlaster.client.key.SubscribeKey;
import org.xmlBlaster.client.key.UpdateKey;
import org.xmlBlaster.client.qos.ConnectQos;
import org.xmlBlaster.client.qos.ConnectReturnQos;
import org.xmlBlaster.client.qos.PublishReturnQos;
import org.xmlBlaster.client.qos.SubscribeQos;
import org.xmlBlaster.client.qos.UpdateQos;
import org.xmlBlaster.util.EmbeddedXmlBlaster;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.MsgUnit;
import org.xmlBlaster.util.admin.extern.MethodInvocation;
import org.xmlBlaster.util.admin.extern.NotifListener;
import org.xmlBlaster.util.admin.extern.SerializeHelper;
import org.xmlBlaster.util.admin.extern.XmlBlasterConnectorMBean;
import org.xmlBlaster.util.qos.address.Address;

public class XmlBlasterConnector
implements XmlBlasterConnectorMBean,
I_Callback {
    private String ME = "XmlBlasterConnector";
    private I_XmlBlasterAccess xmlBlasterAccess;
    private MBeanServer server = null;
    private SerializeHelper serHelp;
    private LogChannel log;
    private Global glob = new Global();
    private EmbeddedXmlBlaster embeddedXmlBlaster = null;
    private static int port = 3424;
    public static int UNKNOWN = -9999;
    public static int SENDING = 1000;
    public static int FINISHED = 1;
    public boolean jmxInterfaceAlive = false;

    public XmlBlasterConnector() {
        this.log = this.glob.getLog("jmx");
        this.serHelp = new SerializeHelper(this.glob);
    }

    public void start(String agentID) {
        this.server = MBeanServerFactory.createMBeanServer(agentID);
        this.log.info(this.ME, "external Start of MBeanAdaptor, new MBeanServer...");
        this.log.warn(this.ME, "Starting external....");
        this.startEmbeddedXmlBlasterServer();
    }

    public void startInternal(MBeanServer server) {
        this.server = server;
        this.log.info(this.ME, "internal Start of MBeanAdaptor, MBeanServer reused... " + server);
        this.startEmbeddedXmlBlasterServer();
    }

    public void startEmbeddedXmlBlasterServer() {
        try {
            this.log.info(this.ME, "Starting new Embedded xmlBlaster responsible for internal jmx-messages on port " + port);
            Global localServerGlob = new Global();
            Properties prop = new Properties();
            prop.setProperty("bootstrapPort", "3424");
            prop.setProperty("bootstrapHostname", "127.0.0.1");
            prop.setProperty("SecurityServer.Plugin", "NONE");
            prop.setProperty("xmlBlaster.activateJmx", "false");
            prop.setProperty("admin.remoteconsole.port", "2703");
            prop.setProperty("plugin/socket/port", "0");
            prop.setProperty("plugin/xmlrpc/port", "0");
            prop.setProperty("plugin/rmi/registryPort", "1122");
            prop.setProperty("cluster", "false");
            localServerGlob.init(prop);
            this.embeddedXmlBlaster = EmbeddedXmlBlaster.startXmlBlaster(localServerGlob);
            this.glob.init(prop);
            Address addr = new Address(this.glob);
            addr.setBootstrapPort(port);
            this.glob.setBootstrapAddress(addr);
            this.xmlBlasterAccess = this.glob.getXmlBlasterAccess();
            this.log.info(this.ME, "Connecting to embedded xmlBlaster on port " + port);
            if (this.xmlBlasterAccess != null) {
                this.jmxInterfaceAlive = true;
            }
            this.log.info(this.ME, "Registered new xmlBlasterConnector, running on " + this.glob.getBootstrapAddress().getBootstrapUrl());
            this.log.info(this.ME, "registering new topic \"xmlBlasterMBeans\"");
            SubscribeKey subKey = new SubscribeKey(this.glob, "xmlBlasterMBeans_Invoke");
            SubscribeQos sQos = new SubscribeQos(this.glob);
            sQos.setWantLocal(false);
            ConnectQos qos = new ConnectQos(this.glob, "InternalConnector", "connector");
            ConnectReturnQos rQos = this.xmlBlasterAccess.connect(qos, this);
            this.log.info(this.ME, "Connect: " + rQos.toString());
            this.xmlBlasterAccess.subscribe(subKey, sQos);
            this.log.info(this.ME, "internal JMX Connector ready and waiting...");
        }
        catch (Exception ex) {
            this.log.error(this.ME, "Error when invoking internal Server for Connector: " + ex.toString());
            ex.printStackTrace();
        }
    }

    public String update(String cbSessionId, UpdateKey updateKey, byte[] content, UpdateQos updateQos) {
        this.log.info(this.ME, "Received asynchronous message \"update()\" ServerSide '" + updateKey.getOid() + "' state=" + updateQos.getState() + " from xmlBlaster");
        MethodInvocation mi = null;
        this.log.info(this.ME, "Is the Server available ? - " + this.server.getDefaultDomain());
        try {
            mi = (MethodInvocation)this.serHelp.deserializeObject(content);
            this.log.info(this.ME, "Called Method: " + mi.getMethodName());
        }
        catch (Exception ex) {
            this.log.error(this.ME, "Error when trying to expand MethodInvocationObject " + ex.toString());
        }
        String ID = mi.getId();
        this.log.info(this.ME, "MethodInvocationID on server:  " + ID);
        mi.setMBeanServer(this.server);
        mi.setTargetHost(this.glob.getLocalIP());
        mi.invoke();
        if (mi.getMethodName().equals("addNotificationListener")) {
            this.addNotification(mi);
        }
        if (mi.getMethodName().equals("removeNotificationListener")) {
            this.removeNotification(mi);
        }
        mi.setId(ID);
        this.log.info(this.ME, "Status of the MethodInvocation ? " + mi.getStatus());
        try {
            this.log.info(this.ME, "Trying to connect as internal user");
            ConnectQos qos = new ConnectQos(this.glob, "InternalConnector", "connector");
            this.log.info(this.ME, "Trying to republish MethodInvocationObject again...");
            PublishReturnQos rqos = this.xmlBlasterAccess.publish(new MsgUnit("<key oid='xmlBlasterMBeans_Return'/>", this.serHelp.serializeObject(mi), "<qos/>"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.log.error(this.ME, "Error when trying to republish MethodInvocation " + ex.toString());
            ex.printStackTrace();
        }
        return "";
    }

    private void removeNotification(MethodInvocation mi) {
        Object[] params = mi.getParams();
        try {
            this.server.removeNotificationListener((ObjectName)params[0], new NotifListener(this, this.xmlBlasterAccess, this.glob));
        }
        catch (Exception ex) {
            this.log.error(this.ME, "Error when disabling serversided Notification for MBean " + ex);
        }
    }

    private void addNotification(MethodInvocation mi) {
        Object[] params = mi.getParams();
        try {
            this.server.createMBean((String)params[1], (ObjectName)params[0]);
        }
        catch (Exception ex) {
            this.log.error(this.ME, "Error when creating MBean on server for Notification-matters " + ex.toString());
        }
        try {
            this.server.addNotificationListener((ObjectName)params[0], new NotifListener(this, this.xmlBlasterAccess, this.glob), (NotificationFilter)params[2], null);
        }
        catch (InstanceNotFoundException ex) {
            this.log.error(this.ME, "Error when enabling serversided Notification for MBean " + ex);
        }
    }

    public boolean isConnectorAlive() {
        return this.jmxInterfaceAlive;
    }

    public void stop(String agentId) {
        EmbeddedXmlBlaster.stopXmlBlaster(this.embeddedXmlBlaster);
        this.jmxInterfaceAlive = false;
    }
}

