/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.plugin.PluginInfo;

public class PluginClassLoader
extends URLClassLoader {
    private String ME = "PluginClassLoader";
    private final String pluginName;
    private String pluginPackage;
    private final LogChannel log;

    public PluginClassLoader(Global glob, URL[] urls, PluginInfo pluginInfo) {
        super(urls);
        this.log = glob.getLog("classloader");
        this.pluginName = pluginInfo.getClassName();
        this.pluginPackage = this.pluginName.substring(0, this.pluginName.lastIndexOf("."));
        this.ME = "PluginClassLoader-" + this.pluginName.substring(this.pluginName.lastIndexOf(46) + 1);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader parent = this.getClass().getClassLoader();
        if (name.startsWith("java.")) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using default JVM class loader for java class " + name);
            }
            return parent.loadClass(name);
        }
        if ((name.startsWith("org.xmlBlaster") || name.startsWith("org.jutils") || name.startsWith("org.omg")) && !name.startsWith(this.pluginPackage)) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using default JVM class loader for " + name);
            }
            return parent.loadClass(name);
        }
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using specific class loader from cache for " + name);
            }
            return clazz;
        }
        try {
            clazz = this.findClass(name);
            this.resolveClass(clazz);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using specific class loader for " + name);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using default JVM class loader for " + name + " as not found in specific class loader");
            }
            clazz = parent.loadClass(name);
            this.resolveClass(clazz);
            return clazz;
        }
    }
}

