/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.classloader;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import org.jutils.log.LogChannel;
import org.jutils.text.StringHelper;
import org.xmlBlaster.util.Global;
import org.xmlBlaster.util.XmlBlasterException;
import org.xmlBlaster.util.classloader.ClassLoaderFactory;
import org.xmlBlaster.util.classloader.LoaderInfo;
import org.xmlBlaster.util.classloader.PluginClassLoader;
import org.xmlBlaster.util.classloader.XmlBlasterClassLoader;
import org.xmlBlaster.util.def.ErrorCode;
import org.xmlBlaster.util.plugin.PluginInfo;

public class StandaloneClassLoaderFactory
implements ClassLoaderFactory {
    public String ME;
    private Global glob;
    private LogChannel log;
    private ArrayList classPath = null;
    private int instanceCounter = 0;

    public StandaloneClassLoaderFactory() {
    }

    public StandaloneClassLoaderFactory(Global glob) {
        this.init(glob);
    }

    public void init(Global glob) {
        ++this.instanceCounter;
        this.ME = "ClassLoaderFactory-" + this.instanceCounter;
        this.glob = glob;
        this.log = glob.getLog("classloader");
        if (this.log.CALL) {
            this.log.call(this.ME, "ClassLoaderFactory constructor #" + this.instanceCounter);
        }
    }

    public URLClassLoader getPluginClassLoader(PluginInfo pluginInfo) throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering getPluginClassLoader for plugin=" + pluginInfo.getClassName());
        }
        Properties pluginParams = pluginInfo.getParameters();
        LoaderInfo loaderInfo = StandaloneClassLoaderFactory.getLoaderInfo(this, pluginInfo.getClassName());
        if (this.log.TRACE) {
            this.log.trace(this.ME, loaderInfo.toString());
        }
        String classPathStr = (String)((Hashtable)pluginParams).get("classpath");
        ArrayList<String> classPath = new ArrayList<String>();
        if (classPathStr != null) {
            this.log.info(this.ME, "Analyzing classpath=" + classPathStr + " for plugin " + pluginInfo.getClassName());
            StringTokenizer st = new StringTokenizer(classPathStr, ";:");
            while (st.hasMoreElements()) {
                File f;
                String jar = (String)st.nextElement();
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Looking for jar '" + jar + "' ...");
                }
                if ((f = new File(jar)).canRead()) {
                    classPath.add(jar);
                    continue;
                }
                String jarStripped = f.getName();
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Looking for jarStripped '" + jarStripped + "' ...");
                }
                if ((f = new File(jarStripped)).canRead()) {
                    classPath.add(jarStripped);
                    continue;
                }
                String resourceJar = loaderInfo.rootPath + jar;
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Looking for resourceJar=" + resourceJar + " ...");
                }
                if ((f = new File(resourceJar)).canRead()) {
                    classPath.add(resourceJar);
                    continue;
                }
                String resourceJarStripped = loaderInfo.rootPath + jar;
                if (this.log.TRACE) {
                    this.log.trace(this.ME, "Looking for resourceJarStripped=" + resourceJarStripped + " ...");
                }
                if ((f = new File(resourceJarStripped)).canRead()) {
                    classPath.add(resourceJarStripped);
                    continue;
                }
                this.log.info(this.ME, "Plugin '" + pluginInfo.getClassName() + "' specific jar file '" + jar + "' not found, using JVM default CLASSPATH");
                URL[] urls = ((URLClassLoader)this.getClass().getClassLoader()).getURLs();
                int j = 0;
                while (j < urls.length) {
                    if (urls[j].getFile().equalsIgnoreCase(jar)) {
                        classPath.add(urls[j].toString());
                    }
                    ++j;
                }
            }
        }
        if (classPath.size() > 0) {
            if (loaderInfo.jarPath != null) {
                classPath.add(loaderInfo.jarPath);
            } else {
                classPath.add(loaderInfo.rootPath);
            }
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "Found " + classPath.size() + " plugin specific jar files");
        }
        return new PluginClassLoader(this.glob, this.stringToUrl(classPath), pluginInfo);
    }

    public URLClassLoader getXmlBlasterClassLoader() throws XmlBlasterException {
        if (this.log.CALL) {
            this.log.call(this.ME, "Entering getXmlBlasterClassLoader ...");
        }
        LoaderInfo loaderInfo = StandaloneClassLoaderFactory.getLoaderInfo(this, "org.xmlBlaster.Main");
        if (this.log.TRACE) {
            this.log.trace(this.ME, loaderInfo.toString());
        }
        ArrayList<String> classPath = new ArrayList<String>();
        if (loaderInfo.jarPath != null) {
            classPath.add(loaderInfo.jarPath);
        } else {
            classPath.add(loaderInfo.rootPath);
        }
        URL[] urls = ((URLClassLoader)this.getClass().getClassLoader()).getURLs();
        int i = 0;
        while (i < urls.length) {
            String xmlBlasterJar = (String)classPath.get(0);
            if (urls[i].getFile().indexOf(xmlBlasterJar) < 0) {
                classPath.add(urls[i].getFile());
            }
            ++i;
        }
        if (this.log.TRACE) {
            String text = "Build new classpath with " + classPath.size() + " entries:";
            int i2 = 0;
            while (i2 < classPath.size()) {
                text = text + (String)classPath.get(i2);
                if (i2 < classPath.size() - 1) {
                    text = text + ":";
                }
                ++i2;
            }
            this.log.trace(this.ME, text);
        }
        return new XmlBlasterClassLoader(this.glob, this.stringToUrl(classPath));
    }

    public static LoaderInfo getLoaderInfo(Object caller, String plugin) throws XmlBlasterException {
        String ME = "ClassLoaderFactory";
        if (plugin == null || plugin.length() < 1) {
            Thread.currentThread();
            Thread.dumpStack();
            throw new XmlBlasterException(Global.instance(), ErrorCode.INTERNAL_ILLEGALARGUMENT, ME, "getLoaderInfo() with plugin=null");
        }
        String classResource = StandaloneClassLoaderFactory.which(caller, plugin);
        if (classResource == null) {
            String text = "Can't find class " + plugin + ", please check your plugin name and your CLASSPATH";
            throw new XmlBlasterException(Global.instance(), ErrorCode.RESOURCE_CONFIGURATION_PLUGINFAILED, ME, text);
        }
        String pluginSlashed = StringHelper.replaceAll(plugin, ".", "/");
        String jarPath = null;
        String jarName = null;
        String rootPath = "";
        if (classResource.indexOf(33) == -1) {
            rootPath = classResource.substring(0, classResource.lastIndexOf(pluginSlashed));
        } else {
            jarPath = classResource.substring(classResource.indexOf("/"), classResource.indexOf("!"));
            jarName = jarPath.substring(jarPath.lastIndexOf("/") + 1, jarPath.length());
            rootPath = jarPath.substring(0, jarPath.lastIndexOf(jarName));
        }
        LoaderInfo loaderInfo = new LoaderInfo(plugin, rootPath, jarPath, jarName, pluginSlashed);
        return loaderInfo;
    }

    private URL[] stringToUrl(ArrayList stringUrls) throws XmlBlasterException {
        int ii;
        if (stringUrls == null) {
            return new URL[0];
        }
        URL[] url = new URL[stringUrls.size()];
        try {
            ii = 0;
            while (ii < stringUrls.size()) {
                url[ii] = new URL("file", null, (String)stringUrls.get(ii));
                ++ii;
            }
        }
        catch (MalformedURLException e) {
            throw new XmlBlasterException(this.glob, ErrorCode.INTERNAL_UNKNOWN, this.ME, "Malformed Url Exception occured: ", e);
        }
        if (this.log.TRACE) {
            this.log.trace(this.ME, "New Classpath as URL before creating classloader:");
            ii = 0;
            while (ii < url.length) {
                this.log.trace(this.ME, ">>" + ii + ": " + url[ii].toString() + "<<");
                ++ii;
            }
        }
        return url;
    }

    public static String which(Object caller, String className) {
        if (!className.startsWith("/")) {
            className = "/" + className;
        }
        className = className.replace('.', '/');
        className = className + ".class";
        URL classUrl = caller.getClass().getResource(className);
        if (classUrl != null) {
            return classUrl.getFile().toString();
        }
        return null;
    }
}

