/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.classloader;

import java.net.URL;
import java.net.URLClassLoader;
import org.jutils.log.LogChannel;
import org.xmlBlaster.util.Global;

public class XmlBlasterClassLoader
extends URLClassLoader {
    private String ME = "XmlBlasterClassLoader";
    private final LogChannel log;
    private final boolean useXmlBlasterClassloader;

    public XmlBlasterClassLoader(Global glob, URL[] urls) {
        super(urls);
        this.log = glob.getLog("classloader");
        this.useXmlBlasterClassloader = glob.getProperty().get("classloader.xmlBlaster", false);
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader parent = this.getClass().getClassLoader();
        if (!this.useXmlBlasterClassloader) {
            return parent.loadClass(name);
        }
        if (name.startsWith("java.")) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using default JVM class loader for java class " + name);
            }
            return parent.loadClass(name);
        }
        if (name.startsWith("org.xmlBlaster.I_Main") || name.startsWith("org.omg") || name.startsWith("org.w3c")) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using default JVM class loader for " + name);
            }
            return parent.loadClass(name);
        }
        Class<?> clazz = this.findLoadedClass(name);
        if (clazz != null) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using specific class loader from cache for " + name);
            }
            return clazz;
        }
        try {
            clazz = this.findClass(name);
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using specific class loader for " + name);
            }
            return clazz;
        }
        catch (ClassNotFoundException e) {
            if (this.log.TRACE) {
                this.log.trace(this.ME, "Using default JVM class loader for " + name + " as not found in specific class loader");
            }
            clazz = parent.loadClass(name);
            this.resolveClass(clazz);
            return clazz;
        }
    }

    public void appendURL(URL url) {
        this.addURL(url);
    }

    private void debugState(String name) {
        this.log.trace(this.ME, "Looking up class: " + name);
        this.log.trace(this.ME, "Local path is: " + this.getURLPath());
    }

    String getURLPath() {
        URL[] urls = this.getURLs();
        StringBuffer buff = new StringBuffer();
        if (urls != null && urls.length > 0) {
            int i = 0;
            while (i < urls.length) {
                buff.append(urls[i].toString()).append(";");
                ++i;
            }
        }
        return buff.toString();
    }
}

