/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.cluster;

import java.io.Serializable;
import org.xmlBlaster.util.Global;

public final class NodeId
implements Comparable,
Serializable {
    private static final String ME = "NodeId";
    private String id;

    public NodeId(String id) {
        this.setId(id);
    }

    public final String getId() {
        return this.id;
    }

    public final void setId(String id) {
        int index;
        if (id == null || id.length() < 1) {
            Global.instance().getLog("cluster").error(ME, "Cluster node has no name please specify one with -cluster.node.id XXX");
            id = "NoNameNode";
        }
        this.id = id;
        if (this.id.startsWith("/node/")) {
            this.id = this.id.substring("/node/".length());
        }
        if ((index = this.id.indexOf("/")) == 0) {
            throw new IllegalArgumentException("NodeId: The given cluster node ID '" + id + "' may not start with a '/'");
        }
        if (index > 0) {
            this.id = this.id.substring(0, index);
        }
    }

    public final String toString() {
        return this.getId();
    }

    public final int compareTo(Object obj) {
        NodeId n = (NodeId)obj;
        return this.toString().compareTo(n.toString());
    }

    public final boolean equals(NodeId n) {
        if (this.id == null) {
            return n == null || n.getId() == null;
        }
        if (n == null || n.getId() == null) {
            return false;
        }
        return this.id.equals(n.getId());
    }
}

