/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.context;

import java.util.ArrayList;
import org.xmlBlaster.util.Global;

public final class ContextNode {
    private static String ME = "ContextNode";
    public static final String SEP = "/";
    public static final String ROOT_MARKER_TAG = "/xmlBlaster";
    public static final String CLUSTER_MARKER_TAG = "node";
    public static final String SUBJECT_MARKER_TAG = "client";
    public static final String SESSION_MARKER_TAG = "session";
    public static final String TOPIC_MARKER_TAG = "topic";
    private String className;
    private String instanceName;
    private ContextNode parent;
    private ArrayList childs;
    public static final ContextNode ROOT_NODE = null;

    public ContextNode(Global glob, String className, String instanceName, ContextNode parent) {
        this.className = className;
        this.instanceName = instanceName;
        this.parent = parent;
    }

    public String getClassName() {
        return this.className;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public ContextNode getParent() {
        return this.parent;
    }

    public void addChild(ContextNode child) {
        if (this.childs == null) {
            this.childs = new ArrayList();
        }
        this.childs.add(child);
    }

    public ContextNode[] getChildren() {
        if (this.childs == null) {
            return new ContextNode[0];
        }
        return this.childs.toArray(new ContextNode[this.childs.size()]);
    }

    public String getAbsoluteName() {
        StringBuffer sb = new StringBuffer(256);
        if (this.parent == ROOT_NODE) {
            return sb.append(ROOT_MARKER_TAG).append(SEP).append(this.className).append(SEP).append(this.instanceName).toString();
        }
        return sb.append(this.parent.getAbsoluteName()).append(SEP).append(this.className).append(SEP).append(this.instanceName).toString();
    }

    public String getAbsoluteName(String schema) {
        StringBuffer sb = new StringBuffer(256);
        if (this.parent == ROOT_NODE) {
            return sb.append(schema).append(":").append(ROOT_MARKER_TAG).append(SEP).append(this.className).append("[@id='").append(this.instanceName).append("']").toString();
        }
        return sb.append(this.parent.getAbsoluteName(schema)).append(SEP).append(this.className).append("[@id='").append(this.instanceName).append("']").toString();
    }

    public String toString() {
        return this.getAbsoluteName();
    }

    public String getRelativeName() {
        StringBuffer sb = new StringBuffer(256);
        return sb.append(this.className).append(SEP).append(this.instanceName).toString();
    }

    public String getRelativeName(String schema) {
        StringBuffer sb = new StringBuffer(256);
        return sb.append(schema).append(":").append(this.className).append("[@id='").append(this.instanceName).append("']").toString();
    }

    public boolean equalsRelative(ContextNode contextNode) {
        return this.getRelativeName().equals(contextNode.getRelativeName());
    }

    public boolean equalsAbsolute(ContextNode contextNode) {
        return this.getAbsoluteName().equals(contextNode.getAbsoluteName());
    }

    public final String toXml() {
        return this.toXml(null);
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        if (extraOffset == null) {
            extraOffset = "";
        }
        String offset = "\n " + extraOffset;
        sb.append(offset).append("<ContextNode class='").append(this.className).append("' instance='").append(this.instanceName).append("'/>");
        return sb.toString();
    }

    public static void main(String[] args) {
        Global glob = new Global(args);
        try {
            ContextNode heron = new ContextNode(glob, CLUSTER_MARKER_TAG, "heron", null);
            System.out.println("AbsoluteName=" + heron.getAbsoluteName() + " RelativeName=" + heron.getRelativeName());
            ContextNode jack = new ContextNode(glob, SUBJECT_MARKER_TAG, "jack", heron);
            System.out.println("AbsoluteName=" + jack.getAbsoluteName() + " RelativeName=" + jack.getRelativeName());
            ContextNode ses2 = new ContextNode(glob, SESSION_MARKER_TAG, "2", jack);
            System.out.println("AbsoluteName=" + ses2.getAbsoluteName() + " RelativeName=" + ses2.getRelativeName());
            ContextNode hello = new ContextNode(glob, TOPIC_MARKER_TAG, "hello", heron);
            System.out.println("AbsoluteName=" + hello.getAbsoluteName() + " RelativeName=" + hello.getRelativeName());
        }
        catch (IllegalArgumentException e) {
            System.out.println("ERROR: " + e.toString());
        }
    }
}

