/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.def;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Hashtable;

public final class MethodName
implements Serializable {
    private static final Hashtable hash = new Hashtable();
    private final String methodName;
    private final int argType;
    private final int returnType;
    private transient byte[] methodNameBytes;
    private static final int RETURN_VOID = 0;
    private static final int RETURN_STRING = 1;
    private static final int RETURN_STRINGARR = 2;
    private static final int RETURN_MSGARR = 3;
    private static final int ARG_QOS = 0;
    private static final int ARG_KEYQOS = 1;
    private static final int ARG_MSGARR = 2;
    private static final int ARG_STR_MSGARR = 3;
    public static final MethodName CONNECT = new MethodName("connect", 0, 1);
    public static final MethodName DISCONNECT = new MethodName("disconnect", 0, 0);
    public static final MethodName GET = new MethodName("get", 1, 3);
    public static final MethodName ERASE = new MethodName("erase", 1, 2);
    public static final MethodName PUBLISH = new MethodName("publish", 2, 2);
    public static final MethodName PUBLISH_ARR = new MethodName("publishArr", 2, 2);
    public static final MethodName PUBLISH_ONEWAY = new MethodName("publishOneway", 2, 0);
    public static final MethodName SUBSCRIBE = new MethodName("subscribe", 1, 1);
    public static final MethodName UNSUBSCRIBE = new MethodName("unSubscribe", 1, 2);
    public static final MethodName UPDATE = new MethodName("update", 3, 2);
    public static final MethodName UPDATE_ONEWAY = new MethodName("updateOneway", 3, 0);
    public static final MethodName PING = new MethodName("ping", 0, 1);
    public static final MethodName DUMMY = new MethodName("dummy", 0, 1);
    public static final MethodName UNKNOWN = new MethodName("unknown", 0, 1);

    private MethodName(String methodName, int argType, int returnType) {
        if (methodName == null) {
            throw new IllegalArgumentException("Your given methodName is null");
        }
        this.methodName = methodName;
        this.argType = argType;
        this.returnType = returnType;
        hash.put(methodName, this);
    }

    public String toString() {
        return this.methodName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean equals(MethodName other) {
        return this.getMethodName().equals(other.getMethodName());
    }

    public byte[] getMethodNameBytes() {
        if (this.methodNameBytes == null) {
            this.methodNameBytes = this.methodName.getBytes();
        }
        return this.methodNameBytes;
    }

    public boolean wantsQosArg() {
        return this.argType == 0;
    }

    public boolean wantsKeyQosArg() {
        return this.argType == 1;
    }

    public boolean wantsMsgArrArg() {
        return this.argType == 2;
    }

    public boolean wantsStrMsgArrArg() {
        return this.argType == 3;
    }

    public boolean returnsVoid() {
        return this.returnType == 0;
    }

    public boolean returnsString() {
        return this.returnType == 1;
    }

    public boolean returnsStringArr() {
        return this.returnType == 2;
    }

    public boolean returnsMsgArr() {
        return this.returnType == 3;
    }

    public static final MethodName toMethodName(String methodName) throws IllegalArgumentException {
        if (methodName == null) {
            throw new IllegalArgumentException("MethodName: A 'null' methodName is invalid");
        }
        Object entry = hash.get(methodName);
        if (entry != null) {
            return (MethodName)entry;
        }
        entry = hash.get(methodName = methodName.toLowerCase());
        if (entry == null) {
            throw new IllegalArgumentException("MethodName: The given methodName=" + methodName + " is unknown");
        }
        return (MethodName)entry;
    }

    public static final MethodName toMethodName(byte[] methodNameBytes) throws IllegalArgumentException {
        return MethodName.toMethodName(new String(methodNameBytes));
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.getMethodName());
    }

    public static void main(String[] args) {
        MethodName methodName;
        try {
            methodName = MethodName.toMethodName((String)null);
            System.out.println("null should not return");
        }
        catch (Throwable e) {
            System.out.println("ERROR: " + e.toString());
        }
        methodName = MethodName.toMethodName("UpDaTe");
        System.out.println("OK: " + methodName);
    }

    private static class SerializedForm
    implements Serializable {
        String methodName;

        SerializedForm(String methodName) {
            this.methodName = methodName;
        }

        Object readResolve() throws ObjectStreamException {
            return MethodName.toMethodName(this.methodName);
        }
    }
}

