/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.def;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;

public final class PriorityEnum
implements Serializable {
    private final int priority;
    public static final PriorityEnum MIN_PRIORITY = new PriorityEnum(0);
    public static final PriorityEnum MIN1_PRIORITY = new PriorityEnum(1);
    public static final PriorityEnum MIN2_PRIORITY = new PriorityEnum(2);
    public static final PriorityEnum LOW_PRIORITY = new PriorityEnum(3);
    public static final PriorityEnum LOW4_PRIORITY = new PriorityEnum(4);
    public static final PriorityEnum NORM_PRIORITY = new PriorityEnum(5);
    public static final PriorityEnum NORM6_PRIORITY = new PriorityEnum(6);
    public static final PriorityEnum HIGH_PRIORITY = new PriorityEnum(7);
    public static final PriorityEnum HIGH8_PRIORITY = new PriorityEnum(8);
    public static final PriorityEnum MAX_PRIORITY = new PriorityEnum(9);
    private static final PriorityEnum[] priorityEnumArr = new PriorityEnum[]{MIN_PRIORITY, MIN1_PRIORITY, MIN2_PRIORITY, LOW_PRIORITY, LOW4_PRIORITY, NORM_PRIORITY, NORM6_PRIORITY, HIGH_PRIORITY, HIGH8_PRIORITY, MAX_PRIORITY};
    private static final Integer[] integerArr = new Integer[]{new Integer(0), new Integer(1), new Integer(2), new Integer(3), new Integer(4), new Integer(5), new Integer(6), new Integer(7), new Integer(8), new Integer(9)};

    private PriorityEnum(int priority) {
        this.priority = priority;
    }

    private PriorityEnum() {
        this.priority = -1;
        System.out.println("DEFAULT PriorityEnum " + this.toString() + " hashCode=" + this.hashCode());
    }

    public String toString() {
        switch (this.priority) {
            case 0: {
                return "MIN";
            }
            case 3: {
                return "LOW";
            }
            case 5: {
                return "NORM";
            }
            case 7: {
                return "HIGH";
            }
            case 9: {
                return "MAX";
            }
        }
        return "" + this.priority;
    }

    public final int getInt() {
        return this.priority;
    }

    public final Integer getInteger() {
        return integerArr[this.priority];
    }

    public static final PriorityEnum toPriorityEnum(int priority) throws IllegalArgumentException {
        if (priority < 0 || priority > 9) {
            throw new IllegalArgumentException("PriorityEnum: The given priority=" + priority + " is illegal");
        }
        return priorityEnumArr[priority];
    }

    public static final PriorityEnum parsePriority(String prio) throws IllegalArgumentException {
        if (prio == null) {
            throw new IllegalArgumentException("PriorityEnum: Given priority is null");
        }
        prio = prio.trim();
        try {
            int priority = new Integer(prio);
            return PriorityEnum.toPriorityEnum(priority);
        }
        catch (NumberFormatException e) {
            prio = prio.toUpperCase();
            if (prio.startsWith("MIN")) {
                return MIN_PRIORITY;
            }
            if (prio.startsWith("LOW")) {
                return LOW_PRIORITY;
            }
            if (prio.startsWith("NORM")) {
                return NORM_PRIORITY;
            }
            if (prio.startsWith("HIGH")) {
                return HIGH_PRIORITY;
            }
            if (prio.startsWith("MAX")) {
                return MAX_PRIORITY;
            }
            throw new IllegalArgumentException("PriorityEnum:  Wrong format of <priority>" + prio + "</priority>, expected one of MIN|LOW|NORM|HIGH|MAX");
        }
    }

    public static final PriorityEnum parsePriority(String priority, PriorityEnum defaultPriority) {
        try {
            return PriorityEnum.parsePriority(priority);
        }
        catch (IllegalArgumentException e) {
            System.out.println("PriorityEnum: " + e.toString() + ": Setting priority to " + defaultPriority);
            return defaultPriority;
        }
    }

    public Object writeReplace() throws ObjectStreamException {
        return new SerializedForm(this.getInt());
    }

    public static void main(String[] args) {
        String fileName = "PriorityEnum.ser";
        PriorityEnum pOrig = MAX_PRIORITY;
        try {
            FileOutputStream f = new FileOutputStream(fileName);
            ObjectOutputStream objStream = new ObjectOutputStream(f);
            objStream.writeObject(pOrig);
            objStream.flush();
            System.out.println("SUCCESS written " + pOrig.toString());
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.toString());
        }
        PriorityEnum pNew = null;
        try {
            FileInputStream f = new FileInputStream(fileName);
            ObjectInputStream objStream = new ObjectInputStream(f);
            pNew = (PriorityEnum)objStream.readObject();
            System.out.println("SUCCESS loaded " + pNew.toString());
        }
        catch (Exception e) {
            System.err.println("ERROR: " + e.toString());
        }
        if (pNew.toString().equals(pOrig.toString())) {
            System.out.println("SUCCESS, string form is equals " + pNew.toString());
        } else {
            System.out.println("ERROR, string form is different " + pNew.toString());
        }
        int hashOrig = pOrig.hashCode();
        int hashNew = pNew.hashCode();
        if (pNew == pOrig) {
            System.out.println("SUCCESS, hash is same, the objects are identical");
        } else {
            System.out.println("ERROR, hashCode is different hashOrig=" + hashOrig + " hashNew=" + hashNew);
        }
    }

    private static class SerializedForm
    implements Serializable {
        int prio;

        SerializedForm(int prio) {
            this.prio = prio;
        }

        Object readResolve() throws ObjectStreamException {
            return PriorityEnum.toPriorityEnum(this.prio);
        }
    }
}

