/*
 * Decompiled with CFR 0.152.
 */
package org.xmlBlaster.util.def;

final class ResourceInfo {
    public static final String REQ = "REQ";
    public static final String API = "API";
    public static final String URL = "URL";
    private final String type;
    private final String label;
    private final String resource;

    public ResourceInfo(String type, String label, String resource) {
        if (!(REQ.equalsIgnoreCase(type) || API.equalsIgnoreCase(type) || URL.equalsIgnoreCase(type))) {
            throw new IllegalArgumentException("Construction of ResourceInfo with illegal type=" + type);
        }
        if (label == null || label.length() < 1) {
            throw new IllegalArgumentException("Construction of ResourceInfo with empty lable");
        }
        this.type = type.toUpperCase();
        this.label = label;
        this.resource = resource == null ? "" : resource;
    }

    public String getType() {
        return this.type;
    }

    public String getLabel() {
        return this.label;
    }

    public String getResource() {
        return this.resource;
    }

    public final String toXml(String extraOffset) {
        StringBuffer sb = new StringBuffer(256);
        String offset = "\n ";
        if (extraOffset == null) {
            extraOffset = "";
        }
        offset = offset + extraOffset;
        sb.append(offset).append("<ResourceInfo type='").append(this.getType()).append("'");
        sb.append(" label='").append(this.getLabel()).append("'>");
        sb.append(offset).append(" ").append(this.getResource());
        sb.append(offset).append("</ResourceInfo>");
        return sb.toString();
    }
}

